/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.input;

import com.softaspects.framework.galileo.renderers.html.input.InputHiddenRenderer;
import com.softaspects.framework.galileo.renderers.html.input.InputPasswordRenderer;
import com.softaspects.framework.galileo.renderers.html.input.InputRendererWorker;
import com.softaspects.framework.galileo.renderers.html.input.InputTextRenderer;
import com.softaspects.framework.galileo.support.components.input.InputBase;
import com.softaspects.framework.galileo.support.util.ReverseHashMap;

public class InputImpl
extends InputBase {
    private int fSize = 50;
    private int fMaxLength = 100;
    private static ReverseHashMap fComponentTypeToRendererMap = new ReverseHashMap();
    private static ReverseHashMap fComponentTypeToTypeStringMap = new ReverseHashMap();

    static {
        InputImpl.initializeComponentTypeToRendererMap();
        InputImpl.initializeComponentTypeToTypeStringMap();
    }

    public InputImpl(short aComponentType) {
        super(aComponentType);
        InputRendererWorker renderer = (InputRendererWorker)fComponentTypeToRendererMap.getValue(new Short(aComponentType));
        renderer.setComponent(this);
        this.setRenderer(renderer);
    }

    public String getComponentTypeName() {
        return InputImpl.getComponentTypeString(this.fType);
    }

    public int getSize() {
        return this.fSize;
    }

    public void setSize(int aSize) {
        this.fSize = aSize;
    }

    public int getMaxLength() {
        return this.fMaxLength;
    }

    public void setMaxLength(int aMaxLength) {
        this.fMaxLength = aMaxLength;
    }

    private static void initializeComponentTypeToRendererMap() {
        fComponentTypeToRendererMap.put(new Short(1), new InputTextRenderer(1));
        fComponentTypeToRendererMap.put(new Short(2), new InputPasswordRenderer(2));
        fComponentTypeToRendererMap.put(new Short(3), new InputHiddenRenderer(3));
    }

    private static void initializeComponentTypeToTypeStringMap() {
        fComponentTypeToTypeStringMap.put(new Short(1), "EDIT");
        fComponentTypeToTypeStringMap.put(new Short(2), "PASSWORD");
        fComponentTypeToTypeStringMap.put(new Short(3), "HIDDEN");
        fComponentTypeToTypeStringMap.put(new Short(4), "TEXTAREA");
        fComponentTypeToTypeStringMap.put(new Short(5), "TOOLBAR");
        fComponentTypeToTypeStringMap.put(new Short(6), "MENUBAR");
        fComponentTypeToTypeStringMap.put(new Short(7), "TREEVIEW");
    }

    public static String getComponentTypeString(short aComponentType) {
        return (String)fComponentTypeToTypeStringMap.getValue(new Short(aComponentType));
    }
}

