/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.components.container.layout;

import com.softaspects.framework.galileo.support.components.container.constraint.TableConstraint;

public class Bounds {
    private int fStartCol = Integer.MAX_VALUE;
    private int fStartRow = Integer.MAX_VALUE;
    private int fEndCol = Integer.MIN_VALUE;
    private int fEndRow = Integer.MIN_VALUE;

    public Bounds() {
        this.clearBounds();
    }

    public Bounds(int aStartCol, int aStartRow, int aEndCol, int aEndRow) {
        this.setStartRow(aStartRow);
        this.setStartCol(aStartCol);
        this.setEndRow(aEndRow);
        this.setEndCol(aEndCol);
    }

    public Bounds(Bounds aBounds) {
        this(aBounds.getStartCol(), aBounds.getStartRow(), aBounds.getEndCol(), aBounds.getEndRow());
    }

    public Bounds(TableConstraint aTableConstraint) {
        this(aTableConstraint.getColumn(), aTableConstraint.getRow(), aTableConstraint.getColumn() + (aTableConstraint.getColSpan() > 1 ? aTableConstraint.getColSpan() - 1 : 0), aTableConstraint.getRow() + (aTableConstraint.getRowSpan() > 1 ? aTableConstraint.getRowSpan() - 1 : 0));
    }

    public void correctBounds(Bounds aBounds) {
        if (aBounds.getStartCol() < this.getStartCol()) {
            this.fStartCol = aBounds.getStartCol();
        }
        if (aBounds.getStartRow() < this.getStartRow()) {
            this.fStartRow = aBounds.getStartRow();
        }
        if (aBounds.getEndCol() > this.getEndCol()) {
            this.fEndCol = aBounds.getEndCol();
        }
        if (aBounds.getEndRow() > this.getEndRow()) {
            this.fEndRow = aBounds.getEndRow();
        }
    }

    public boolean isCrossBounds(Bounds aBounds) {
        boolean rowCross;
        if (aBounds == null || aBounds.isEmpty() || this.isEmpty()) {
            return false;
        }
        boolean colCross = aBounds.getStartCol() >= this.getStartCol() && aBounds.getStartCol() <= this.getEndCol() || this.getStartCol() >= aBounds.getStartCol() && this.getEndCol() <= aBounds.getEndCol();
        boolean bl = rowCross = aBounds.getStartRow() >= this.getStartRow() && aBounds.getStartRow() <= this.getEndRow() || this.getStartRow() >= aBounds.getStartRow() && this.getEndRow() <= aBounds.getEndRow();
        return colCross && rowCross;
    }

    public void setStartCol(int aStartCol) {
        this.fStartCol = aStartCol;
    }

    public int getStartCol() {
        return this.fStartCol;
    }

    public void setStartRow(int aStartRow) {
        this.fStartRow = aStartRow;
    }

    public int getStartRow() {
        return this.fStartRow;
    }

    public void setEndCol(int aEndCol) {
        this.fEndCol = aEndCol;
    }

    public int getEndCol() {
        return this.fEndCol;
    }

    public void setEndRow(int aEndRow) {
        this.fEndRow = aEndRow;
    }

    public int getEndRow() {
        return this.fEndRow;
    }

    public void clearBounds() {
        this.setStartRow(Integer.MAX_VALUE);
        this.setStartCol(Integer.MAX_VALUE);
        this.setEndRow(Integer.MIN_VALUE);
        this.setEndCol(Integer.MIN_VALUE);
    }

    public boolean isEmpty() {
        return this.getStartCol() > this.getEndCol() || this.getStartRow() > this.getEndRow();
    }
}

