/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractHeaderRenderer;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;

public class BaseHeaderRenderer
extends AbstractHeaderRenderer {
    public String makeRender() throws RendererException {
        Table table = this.getTable();
        int columnIndex = this.getColumnIndex();
        String headerId = RendererUtils.getTableHeaderComponentId(table, columnIndex);
        StringBuffer sBuffer = new StringBuffer();
        try {
            sBuffer.append("<P");
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("ID", headerId));
            boolean selected = table.isColumnSelected(columnIndex);
            boolean sorted = table.isColumnSortKey(columnIndex);
            boolean focused = false;
            int foreground = table.getInterfaceManager().getHeaderForeground(selected, sorted, focused, columnIndex);
            if (foreground != 0) {
                String color = ColorFactory.convertColorFromIntToHtml(foreground);
                sBuffer.append(' ');
                String style = RendererFactory.createHtmlStyleString("COLOR", color);
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("STYLE", style));
            }
            sBuffer.append('>');
            sBuffer.append((String)this.getValue());
            return RendererFactory.indentString(5, sBuffer.toString());
        }
        catch (Exception e) {
            throw new RendererException(e.toString());
        }
    }
}

