/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.frame.layout;

import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.container.constraint.BorderConstraint;
import com.softaspects.framework.galileo.support.components.frame.Frame;
import com.softaspects.framework.galileo.support.components.frame.FrameContainer;
import com.softaspects.framework.galileo.support.components.frame.layout.FrameBorderLayoutManager;
import com.softaspects.framework.galileo.support.components.rawdata.RawData;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.jsp.JspWriter;

public class BorderFrameLayoutRenderer
extends ContextRendererImpl {
    private static final int TYPE_NORTH_SOUTH = 1;
    private static final int TYPE_EAST_WEST = 2;
    private static final int FRAMESET_MAIN = 11;
    private static final int FRAMESET_INNER = 12;
    private static final int ATTRIBUTE_ROWS = 1;
    private static final int ATTRIBUTE_COLS = 2;
    private static final String FRAMECONTAINER_SCRIPT_WAS_LOADED = "FRAMECONTAINER_SCRIPT_WAS_LOADED";
    private static final String FRAMECONTAINER_SCRIPT_FUNCTION = "Container";
    private static final String FRAMECONTAINER_ACTION_SCRIPT = "container.js";
    private static HashSet fRules_North_South = new HashSet();
    private static HashSet fRules_East_West = new HashSet();
    private static HashMap fAreasFrameIdMap = new HashMap();
    private static final int[] fMainFrameAreasNorthSouth = new int[]{4, 12, 2};
    private static final int[] fMainFrameAreasEastWest = new int[]{3, 12, 1};
    private static final int[] fInnerFrameAreasNorthSouth;
    private static final int[] fInnerFrameAreasEastWest;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 3;
        fInnerFrameAreasNorthSouth = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 4;
        nArray2[2] = 2;
        fInnerFrameAreasEastWest = nArray2;
        BorderFrameLayoutRenderer.initRulesSetByColumnsAttribute();
        BorderFrameLayoutRenderer.initAreasFrameIdMap();
    }

    private static void initRulesSetByColumnsAttribute() {
        fRules_East_West.add(new Integer(3));
        fRules_East_West.add(new Integer(1));
        fRules_East_West.add(new Integer(0));
        fRules_East_West.add(new Integer(11));
        fRules_North_South.add(new Integer(3));
        fRules_North_South.add(new Integer(1));
        fRules_North_South.add(new Integer(12));
    }

    private static void initAreasFrameIdMap() {
        fAreasFrameIdMap.put(new Integer(4), "_north");
        fAreasFrameIdMap.put(new Integer(2), "_sorth");
        fAreasFrameIdMap.put(new Integer(3), "_east");
        fAreasFrameIdMap.put(new Integer(1), "_west");
        fAreasFrameIdMap.put(new Integer(0), "_center");
        fAreasFrameIdMap.put(new Integer(12), "_inner");
    }

    private static int getAttributeToCalculate(int aArea, int aType) {
        Integer area = new Integer(aArea);
        if (aType == 2 && fRules_East_West.contains(area) || aType == 1 && fRules_North_South.contains(area)) {
            return 2;
        }
        return 1;
    }

    private static String getFrameSetIdPrefix(int aArea) {
        return (String)fAreasFrameIdMap.get(new Integer(aArea));
    }

    public String doRender() throws RendererException {
        JspWriter out = this.fPageContext.getOut();
        FrameContainer container = (FrameContainer)this.getComponent();
        FrameBorderLayoutManager borderLayoutManager = (FrameBorderLayoutManager)container.getFrameLayoutManager();
        borderLayoutManager.doLayout(container);
        try {
            StringBuffer sBuffer = new StringBuffer("<FRAMESET");
            Iterator htmlProperties = RendererFactory.componentBaseHtmlPropertiesIterator(container);
            while (htmlProperties.hasNext()) {
                sBuffer.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            ArrayList<HtmlProperty> aList = new ArrayList<HtmlProperty>();
            if (container.getHintText() != null) {
                aList.add(new HtmlProperty("TITLE", container.getHintText()));
            }
            if (container.getFrameBorder() != null) {
                aList.add(new HtmlProperty("FRAMEBORDER", container.getFrameBorder()));
            }
            if (container.getBorderColor() != 0) {
                String color = ColorFactory.convertColorFromIntToHtml(container.getBorderColor());
                aList.add(new HtmlProperty("BORDERCOLOR", color));
            }
            if (container.getBorder() != -1) {
                aList.add(new HtmlProperty("BORDER", container.getBorder()));
            }
            int type = borderLayoutManager.getType();
            int attribute = BorderFrameLayoutRenderer.getAttributeToCalculate(11, type);
            String size = this.getSizeForFrameSet(type == 1 ? fMainFrameAreasNorthSouth : fMainFrameAreasEastWest, borderLayoutManager, attribute);
            if (attribute == 2) {
                aList.add(new HtmlProperty("ROWS", "*"));
                aList.add(new HtmlProperty("COLS", size));
            } else {
                aList.add(new HtmlProperty("ROWS", size));
                aList.add(new HtmlProperty("COLS", "*"));
            }
            Iterator uniqHtmlProperty = ((AbstractList)aList).iterator();
            while (uniqHtmlProperty.hasNext()) {
                sBuffer.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)uniqHtmlProperty.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            sBuffer.append('>');
            if (type == 1) {
                this.renderArea(4, container, 1);
                this.renderInnerFrameSet(fInnerFrameAreasNorthSouth, container);
                this.renderArea(2, container, 1);
            } else {
                this.renderArea(3, container, 1);
                this.renderInnerFrameSet(fInnerFrameAreasEastWest, container);
                this.renderArea(1, container, 1);
            }
            sBuffer.append("</FRAMESET>");
            RawData rawHtml = container.getRawHtml();
            if (rawHtml != null) {
                sBuffer.append("\n");
                sBuffer.append("<NOFRAMES>");
                RendererFactory.componentRender(rawHtml, this.fPageContext);
                sBuffer.append("\n");
                sBuffer.append("</NOFRAMES>");
            }
            String result = sBuffer.toString();
            if (container.isPageContextRendering()) {
                out.println(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }

    private void renderArea(int aBorder, FrameContainer aContainer, int aInset) throws RendererException, IOException {
        FrameBorderLayoutManager layoutManager = (FrameBorderLayoutManager)aContainer.getFrameLayoutManager();
        int count = layoutManager.getCountLayoutFrames(aBorder);
        if (count > 0) {
            Iterator frames = layoutManager.getLayoutFrames(aBorder);
            JspWriter out = this.fPageContext.getOut();
            if (count > 1) {
                int attribute = BorderFrameLayoutRenderer.getAttributeToCalculate(aBorder, layoutManager.getType());
                String size = this.getSizeForArea(aBorder, layoutManager);
                StringBuffer sBuffer = new StringBuffer("<FRAMESET");
                sBuffer.append(' ');
                String id = String.valueOf(aContainer.getId()) + BorderFrameLayoutRenderer.getFrameSetIdPrefix(aBorder);
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("ID", id));
                sBuffer.append(' ');
                if (attribute == 2) {
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("ROWS", "*"));
                    sBuffer.append(' ');
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("COLS", size));
                } else {
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("ROWS", size));
                    sBuffer.append(' ');
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("COLS", "*"));
                }
                sBuffer.append('>');
                out.println(RendererFactory.indentString(aInset, sBuffer.toString()));
            }
            String indent = RendererFactory.indentString(aInset + (count > 1 ? 2 : 1));
            while (frames.hasNext()) {
                out.print(indent);
                RendererFactory.componentRender((Frame)frames.next(), this.fPageContext);
            }
            if (count > 1) {
                out.println(RendererFactory.indentString(aInset, "</FRAMESET>"));
                out.println();
            }
        }
    }

    private String getSizeForArea(int aBorder, FrameBorderLayoutManager aLayoutManager) {
        Iterator frames = aLayoutManager.getLayoutFrames(aBorder);
        StringBuffer sBuffer = new StringBuffer();
        while (frames.hasNext()) {
            Frame frame = (Frame)frames.next();
            sBuffer.append(frame.getSize() != null ? frame.getSize() : "*");
            if (!frames.hasNext()) continue;
            sBuffer.append(',');
        }
        return sBuffer.toString();
    }

    private void renderInnerFrameSet(int[] aBorders, FrameContainer aContainer) throws RendererException, IOException {
        FrameBorderLayoutManager layoutManager = (FrameBorderLayoutManager)aContainer.getFrameLayoutManager();
        int count = 0;
        int i = 0;
        while (i < aBorders.length) {
            if (layoutManager.getCountLayoutFrames(aBorders[i]) > 0) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            JspWriter out = this.fPageContext.getOut();
            if (count > 1) {
                int attribute = BorderFrameLayoutRenderer.getAttributeToCalculate(12, layoutManager.getType());
                String size = this.getSizeForFrameSet(aBorders, layoutManager, attribute);
                StringBuffer sBuffer = new StringBuffer("<FRAMESET");
                sBuffer.append(' ');
                String id = String.valueOf(aContainer.getId()) + BorderFrameLayoutRenderer.getFrameSetIdPrefix(12);
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("ID", id));
                sBuffer.append(' ');
                if (attribute == 2) {
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("ROWS", "*"));
                    sBuffer.append(' ');
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("COLS", size));
                } else {
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("ROWS", size));
                    sBuffer.append(' ');
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("COLS", "*"));
                }
                sBuffer.append('>');
                out.println(RendererFactory.indentString(1, sBuffer.toString()));
                out.println();
            }
            int i2 = 0;
            while (i2 < aBorders.length) {
                this.renderArea(aBorders[i2], aContainer, 2);
                ++i2;
            }
            if (count > 1) {
                out.println(RendererFactory.indentString(1, "</FRAMESET>"));
                out.println();
            }
        }
    }

    private String getSizeForOneAreaByConstraint(int aBorder, FrameBorderLayoutManager aLayoutManager, int aAttribute) {
        Iterator frames = aLayoutManager.getLayoutFrames(aBorder);
        String result = frames.hasNext() ? "*" : null;
        while (frames.hasNext()) {
            Frame frame = (Frame)frames.next();
            Constraint constraint = frame.getConstraint();
            if (constraint == null || !(constraint instanceof BorderConstraint)) continue;
            BorderConstraint borderConstraint = (BorderConstraint)constraint;
            if (aAttribute == 2 && borderConstraint.getWidth() != null) {
                result = borderConstraint.getWidth();
                break;
            }
            if (aAttribute != 1 || borderConstraint.getHeight() == null) continue;
            result = borderConstraint.getHeight();
            break;
        }
        return result;
    }

    private String getSizeForFrameSet(int[] aBorders, FrameBorderLayoutManager aLayoutManager, int aAttribute) {
        StringBuffer sBuffer = new StringBuffer();
        int type = aLayoutManager.getType();
        int i = 0;
        while (i < aBorders.length) {
            String size = null;
            if (aBorders[i] == 12) {
                int[] areas = type == 1 ? fInnerFrameAreasNorthSouth : fInnerFrameAreasEastWest;
                int j = 0;
                while (j < areas.length) {
                    size = this.getSizeForOneAreaByConstraint(areas[j], aLayoutManager, aAttribute);
                    if (size == null) {
                        ++j;
                        continue;
                    }
                    break;
                }
            } else {
                size = this.getSizeForOneAreaByConstraint(aBorders[i], aLayoutManager, aAttribute);
            }
            if (size != null) {
                sBuffer.append(size);
                sBuffer.append(',');
            }
            ++i;
        }
        if (sBuffer.length() > 0 && sBuffer.charAt(sBuffer.length() - 1) == ',') {
            sBuffer.setLength(sBuffer.length() - 1);
        }
        return sBuffer.toString();
    }
}

