/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table;

import com.softaspects.framework.galileo.components.base.ComponentBaseImpl;
import com.softaspects.framework.galileo.components.base.ComponentImpl;
import com.softaspects.framework.galileo.components.base.Interval;
import com.softaspects.framework.galileo.components.table.CellChanger;
import com.softaspects.framework.galileo.components.table.ChangeCommand;
import com.softaspects.framework.galileo.components.table.ChangeCommandImpl;
import com.softaspects.framework.galileo.components.table.ChangeResult;
import com.softaspects.framework.galileo.components.table.ChangeResultImpl;
import com.softaspects.framework.galileo.components.table.Column;
import com.softaspects.framework.galileo.components.table.ColumnModel;
import com.softaspects.framework.galileo.components.table.ColumnModelImpl;
import com.softaspects.framework.galileo.components.table.Cursor;
import com.softaspects.framework.galileo.components.table.DataModel;
import com.softaspects.framework.galileo.components.table.DataModelImpl;
import com.softaspects.framework.galileo.components.table.Header;
import com.softaspects.framework.galileo.components.table.HeaderImpl;
import com.softaspects.framework.galileo.components.table.InterfaceManager;
import com.softaspects.framework.galileo.components.table.InterfaceManagerImpl;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.table.CellRenderer;
import com.softaspects.framework.galileo.renderers.html.table.HeaderRenderer;
import com.softaspects.framework.galileo.renderers.html.table.TableRendererImpl;
import com.softaspects.framework.galileo.support.components.listmodel.ListSelectionModel;
import com.softaspects.framework.galileo.support.components.listmodel.ListSelectionModelImpl;
import com.softaspects.framework.galileo.support.util.LazyHashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;

public class TableImpl
extends ComponentImpl
implements Table {
    protected int fBorder = 1;
    protected int fBorderColor = 0;
    protected int fCellSpacing = 2;
    protected int fCellPadding = 2;
    protected int fRules = -1;
    protected int fFrame = -1;
    protected int fEditorMode = 0;
    protected int fCaptionAlign = -1;
    protected String fRowHeight = null;
    protected String fVerticalBorderStyle = null;
    protected String fHorizontalBorderStyle = null;
    protected String fBackGround = null;
    protected String fCaption = null;
    protected String fTarget = null;
    protected boolean fRowSelectionAllowed = true;
    protected boolean fAutoColumnCreationMode = true;
    protected boolean fSimpleViewMode = false;
    protected ListSelectionModel fRowSelectionModel;
    protected ColumnModel fTableColumnModel;
    protected DataModel fTableDataModel;
    protected Header fTableHeader;
    protected ChangeResult fTableChangeResponse;
    protected ChangeCommand fTableChangeRequest;
    protected InterfaceManager fInterfaceManager;
    protected LazyHashMap fDefaultRenderersByColumnClass = new LazyHashMap();
    protected LazyHashMap fDefaultEditorsByColumnClass = new LazyHashMap();
    protected LazyHashMap fDefaultComparatorByColumnClass = new LazyHashMap();
    protected LazyHashMap fDefaultCellChangersByColumnClass = new LazyHashMap();
    private static final boolean GENERATE_EXCEPION_IF_HEADER_NOT_FOUND = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;
    static /* synthetic */ Class class$28;
    static /* synthetic */ Class class$29;
    static /* synthetic */ Class class$30;
    static /* synthetic */ Class class$31;
    static /* synthetic */ Class class$32;
    static /* synthetic */ Class class$33;
    static /* synthetic */ Class class$34;
    static /* synthetic */ Class class$35;
    static /* synthetic */ Class class$36;

    public TableImpl(DataModel aTableDataModel, ColumnModel aTableColumnModel, ListSelectionModel aListSelectionModel) {
        if (aListSelectionModel == null) {
            aListSelectionModel = this.createDefaultSelectionModel();
        }
        this.setRowSelectionModel(aListSelectionModel);
        if (aTableDataModel == null) {
            aTableDataModel = this.createDefaultDataModel();
        }
        this.setTableDataModel(aTableDataModel);
        if (aTableColumnModel == null) {
            aTableColumnModel = this.createDefaultColumnModel();
        }
        this.setTableColumnModel(aTableColumnModel);
        this.createDefaultRenderers();
        this.createDefaultEditors();
        this.createDefaultComporators();
        this.createDefaultCellChangers();
        this.setTableHeader(this.createDefaultTableHeader());
        this.setInterfaceManager(new InterfaceManagerImpl());
        this.setRenderer(new TableRendererImpl(this));
        this.fTableChangeRequest = new ChangeCommandImpl();
        this.fTableChangeRequest.setTable(this);
        this.fTableChangeResponse = new ChangeResultImpl();
    }

    public TableImpl(DataModel aTableDataModel, ColumnModel aTableColumnModel) {
        this(aTableDataModel, aTableColumnModel, null);
    }

    public TableImpl(DataModel aTableDataModel) {
        this(aTableDataModel, null);
    }

    public TableImpl() {
        this(null);
    }

    public String getComponentTypeName() {
        return "TABLE_COMPONENT";
    }

    public void setTarget(String aTarget) {
        this.fTarget = aTarget;
    }

    public String getTarget() {
        return this.fTarget;
    }

    public void setEditorMode(int aEditorMode) {
        if (aEditorMode < 0 || aEditorMode > 1) {
            throw new IllegalArgumentException("Table: Editor mode not supported.");
        }
        this.fEditorMode = aEditorMode;
    }

    public int getEditorMode() {
        return this.fEditorMode;
    }

    public void setBorderColor(int aBorderColor) {
        this.fBorderColor = aBorderColor;
    }

    public int getBorderColor() {
        return this.fBorderColor;
    }

    public void setCellPadding(int aCellPadding) {
        ComponentBaseImpl.validateValue(aCellPadding, "CellPadding");
        this.fCellPadding = aCellPadding;
    }

    public int getCellPadding() {
        return this.fCellPadding;
    }

    public void setCellSpacing(int aCellSpacing) {
        ComponentBaseImpl.validateValue(aCellSpacing, "CellPadding");
        this.fCellSpacing = aCellSpacing;
    }

    public int getCellSpacing() {
        return this.fCellSpacing;
    }

    public void setBorder(int aBorder) {
        ComponentBaseImpl.validateValue(aBorder, "Border");
        this.fBorder = aBorder;
    }

    public int getBorder() {
        return this.fBorder;
    }

    public String getBackGround() {
        return this.fBackGround;
    }

    public void setBackGround(String aBackGround) {
        this.fBackGround = aBackGround;
    }

    public int getFrame() {
        return this.fFrame;
    }

    public void setFrame(int aFrame) {
        if (aFrame < 1 || aFrame > 8) {
            throw new IllegalArgumentException("Table: Frame value invalid.");
        }
        this.fFrame = aFrame;
    }

    public int getRules() {
        return this.fRules;
    }

    public void setRules(int aRules) {
        if (aRules < 1 || aRules > 5) {
            throw new IllegalArgumentException("Table: Rules value invalid.");
        }
        this.fRules = aRules;
    }

    public void setRowHeight(String aRowHeight) {
        this.fRowHeight = aRowHeight;
    }

    public String getRowHeight() {
        return this.fRowHeight;
    }

    public void setHorizontalBorderStyle(String aBorderStyle) {
        this.fHorizontalBorderStyle = aBorderStyle;
    }

    public String getHorizontalBorderStyle() {
        return this.fHorizontalBorderStyle;
    }

    public void setVerticalBorderStyle(String aBorderStyle) {
        this.fVerticalBorderStyle = aBorderStyle;
    }

    public String getVerticalBorderStyle() {
        return this.fVerticalBorderStyle;
    }

    public void setCaption(String aCaption) {
        this.fCaption = aCaption;
    }

    public String getCaption() {
        return this.fCaption;
    }

    public void setCaptionAlign(int aCaptionAlign) {
        if (aCaptionAlign < 1 || aCaptionAlign > 4) {
            throw new IllegalArgumentException("Table component: Caption align value is invalid.");
        }
        this.fCaptionAlign = aCaptionAlign;
    }

    public int getCaptionAlign() {
        return this.fCaptionAlign;
    }

    public void setSimpleViewMode(boolean aSimpleViewMode) {
        this.fSimpleViewMode = aSimpleViewMode;
    }

    public boolean isSimpleViewMode() {
        return this.fSimpleViewMode;
    }

    public void setTableHeader(Header aTableHeader) {
        this.fTableHeader = aTableHeader;
    }

    public Header getTableHeader() {
        return this.fTableHeader;
    }

    public void setTableColumnModel(ColumnModel aTableColumnModel) {
        TableImpl.validateValue(aTableColumnModel, "Table column model");
        this.fTableColumnModel = aTableColumnModel;
        if (this.getTableHeader() != null) {
            this.getTableHeader().setTableColumnModel(aTableColumnModel);
        }
        if (this.getTableDataModel() != null && aTableColumnModel.getColumnSortedKey() != -1) {
            this.sortData(aTableColumnModel.getColumnSortedKey(), aTableColumnModel.isColumnSortedAsc());
        }
    }

    public InterfaceManager getInterfaceManager() {
        return this.fInterfaceManager;
    }

    public void setInterfaceManager(InterfaceManager aInterfaceManager) {
        TableImpl.validateValue(aInterfaceManager, "InterfaceManager");
        this.fInterfaceManager = aInterfaceManager;
        this.fInterfaceManager.setTable(this);
    }

    public ColumnModel getTableColumnModel() {
        return this.fTableColumnModel;
    }

    public void setTableDataModel(DataModel aTableDataModel) {
        TableImpl.validateValue(aTableDataModel, "Table data model");
        this.fTableDataModel = aTableDataModel;
        ColumnModel columnModel = this.getTableColumnModel();
        if (columnModel != null) {
            if (columnModel.getColumnSortedKey() != -1) {
                this.sortData(columnModel.getColumnSortedKey(), columnModel.isColumnSortedAsc());
            }
        } else if (this.isAutoColumnCreationMode()) {
            this.setTableColumnModel(this.createDefaultColumnModel());
        }
    }

    public DataModel getTableDataModel() {
        return this.fTableDataModel;
    }

    private Column getColumn(int aColumnIndex) {
        Column tableColumn = this.getTableColumnModel().findColumn(aColumnIndex);
        if (tableColumn == null) {
            TableImpl.columnIndexNotSupported();
        }
        return tableColumn;
    }

    private Header getHeader() {
        Header tableHeader = this.getTableHeader();
        if (tableHeader == null) {
            TableImpl.exceptionHeaderNotFound();
        }
        return tableHeader;
    }

    public void setAutoColumnCreationMode(boolean aAutoColumnCreationMode) {
        this.fAutoColumnCreationMode = aAutoColumnCreationMode;
    }

    public boolean isAutoColumnCreationMode() {
        return this.fAutoColumnCreationMode;
    }

    public int convertColumnIndexToModel(int aViewColumnIndex) {
        ComponentBaseImpl.validateValue(aViewColumnIndex, "Column index");
        Column tableColumn = this.getTableColumnModel().findColumn(aViewColumnIndex);
        return tableColumn == null ? -1 : tableColumn.getTableColumnModelIndex();
    }

    public int convertColumnIndexToView(int aModelColumnIndex) {
        ComponentBaseImpl.validateValue(aModelColumnIndex, "Column index");
        ColumnModel tableColumnModel = this.getTableColumnModel();
        int i = 0;
        while (i < this.getColumnCount()) {
            Column tableColumn = tableColumnModel.findColumn(i);
            if (tableColumn.getTableColumnModelIndex() == aModelColumnIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getRowCount() {
        return this.getTableDataModel().getRowCount();
    }

    public int getColumnCount() {
        return this.getTableColumnModel().getColumnCount();
    }

    public int[] getVisibleColumns() {
        return this.getTableColumnModel().getVisibleColumns();
    }

    public int getVisibleColumnsCount() {
        return this.getTableColumnModel().getVisibleColumnsCount();
    }

    public Object getColumnID(int aColumnIndex) {
        return this.getColumn(aColumnIndex).getID();
    }

    public void setColumnID(int aColumnIndex, Object aID) {
        this.getColumn(aColumnIndex).setID(aID);
    }

    public void setColumnHeaderValue(int aColumnIndex, Object aValue) {
        this.getColumn(aColumnIndex).setHeaderValue(aValue);
    }

    public Object getColumnHeaderValue(int aColumnIndex) {
        return this.getColumn(aColumnIndex).getHeaderValue();
    }

    public void setColumnClass(int aColumnIndex, Class aColumnClass) {
        this.getColumn(aColumnIndex).setColumnClass(aColumnClass);
    }

    public Class getColumnClass(int aColumnIndex) {
        return this.getColumn(aColumnIndex).getColumnClass();
    }

    public Class getCellClass(int aRowIndex, int aColumnIndex) {
        return this.getColumnClass(aColumnIndex);
    }

    public Object getValueAt(int aRowIndex, int aViewColumnIndex) {
        ComponentBaseImpl.validateValue(aRowIndex, "Row index");
        int modelColumnIndex = this.convertColumnIndexToModel(aViewColumnIndex);
        TableImpl.validateFoundIndex(modelColumnIndex);
        return this.getTableDataModel().getValueAt(aRowIndex, modelColumnIndex);
    }

    public void setValueAt(Object aValue, int aRowIndex, int aViewColumnIndex) {
        ComponentBaseImpl.validateValue(aRowIndex, "Row index");
        int modelColumnIndex = this.convertColumnIndexToModel(aViewColumnIndex);
        TableImpl.validateFoundIndex(modelColumnIndex);
        this.getTableDataModel().setValueAt(aValue, aRowIndex, modelColumnIndex);
    }

    public boolean isCellEditable(int aRowIndex, int aColumnIndex) {
        ComponentBaseImpl.validateValue(aRowIndex, "Row index");
        int modelColumnIndex = this.convertColumnIndexToModel(aColumnIndex);
        TableImpl.validateFoundIndex(modelColumnIndex);
        return this.getTableDataModel().isCellEditable(aRowIndex, modelColumnIndex);
    }

    public Iterator getEditableCells() {
        ArrayList<int[]> listCells = new ArrayList<int[]>();
        DataModel dataModel = this.getTableDataModel();
        int i = 0;
        while (i < this.getColumnCount()) {
            int columnIndex = this.convertColumnIndexToModel(i);
            int j = 0;
            while (j < this.getRowCount()) {
                if (dataModel.isCellEditable(j, columnIndex)) {
                    listCells.add(new int[]{j, columnIndex});
                }
                ++j;
            }
            ++i;
        }
        return ((AbstractList)listCells).iterator();
    }

    public void addColumn(Column aTableColumn) {
        int modelIndex = aTableColumn.getTableColumnModelIndex();
        Object columnId = this.getTableDataModel().getColumnID(modelIndex);
        if (aTableColumn.getHeaderValue() == null) {
            aTableColumn.setHeaderValue(columnId);
        }
        this.getTableColumnModel().addColumn(aTableColumn);
    }

    public void removeColumn(Column aTableColumn) {
        this.getTableColumnModel().removeColumn(aTableColumn);
    }

    public void removeColumn(int aColumnIndex) {
        this.getTableColumnModel().removeColumn(aColumnIndex);
    }

    public void moveColumn(int aColumnIndex, int aNewColumnIndex) {
        this.getTableColumnModel().moveColumn(aColumnIndex, aNewColumnIndex);
    }

    public void setColumnSortSupported(int aColumnIndex, boolean aSortSupported) {
        this.getColumn(aColumnIndex).setSortSupported(aSortSupported);
    }

    public boolean isColumnSortSupported(int aColumnIndex) {
        return this.getColumn(aColumnIndex).isSortSupported();
    }

    public void setColumnVisible(int aColumnIndex, boolean aVisible) {
        this.getColumn(aColumnIndex).setVisible(aVisible);
    }

    public boolean isColumnVisible(int aColumnIndex) {
        return this.getColumn(aColumnIndex).isVisible();
    }

    public void setColumnNoWrapMode(int aColumnIndex, boolean aNoWrapMode) {
        this.getColumn(aColumnIndex).setNoWrapMode(aNoWrapMode);
    }

    public void setColoumnHighLightAllowed(int aColumnIndex, boolean aHighLightAllowed) {
        this.getColumn(aColumnIndex).setHighLightAllowed(aHighLightAllowed);
    }

    public boolean isColumnHighLightAllowed(int aColumnIndex) {
        int highLightAllowed = this.getTableColumnModel().getHighLightAllowed();
        if (highLightAllowed == -1) {
            return this.getColumn(aColumnIndex).isHighLightAllowed();
        }
        return highLightAllowed == 1;
    }

    public boolean isColumnNoWrapMode(int aColumnIndex) {
        int noWrapMode = this.getTableColumnModel().getNoWrapMode();
        if (noWrapMode == -1) {
            return this.getColumn(aColumnIndex).isNoWrapMode();
        }
        return noWrapMode == 1;
    }

    public void setColumnHintText(int aColumnIndex, String aHintText) {
        this.getColumn(aColumnIndex).setHintText(aHintText);
    }

    public String getColumnHintText(int aColumnIndex) {
        return this.getColumn(aColumnIndex).getHintText();
    }

    public void setColumnPrefferedWidth(int aColumnIndex, String aPrefferdWidth) {
        this.getColumn(aColumnIndex).setPrefferedWidth(aPrefferdWidth);
    }

    public String getColumnPrefferedWidth(int aColumnIndex) {
        return this.getColumn(aColumnIndex).getPrefferedWidth();
    }

    public void setColumnMaxLength(int aColumnIndex, int aMaxLength) {
        this.getColumn(aColumnIndex).setMaxLength(aMaxLength);
    }

    public int getColumnMaxLength(int aColumnIndex) {
        return this.getColumn(aColumnIndex).getMaxLength();
    }

    public void setColumnAlignMode(int aColumnIndex, int aAlignMode) {
        this.getColumn(aColumnIndex).setAlignMode(aAlignMode);
    }

    public int getColumnAlignMode(int aColumnIndex) {
        return this.getColumn(aColumnIndex).getAlignMode();
    }

    public void setColumnValignMode(int aColumnIndex, int aValignMode) {
        this.getColumn(aColumnIndex).setValignMode(aValignMode);
    }

    public int getColumnValignMode(int aColumnIndex) {
        return this.getColumn(aColumnIndex).getValignMode();
    }

    public void removeRow(int aRowIndex) {
        this.getTableDataModel().removeRow(aRowIndex);
    }

    public void moveRow(int aOldIndex, int aNewIndex) {
        this.getTableDataModel().moveRow(aOldIndex, aNewIndex);
    }

    public void sortData(int aColumnIndex, boolean aAscSort) {
        int columnIndex = this.convertColumnIndexToModel(aColumnIndex);
        TableImpl.validateFoundIndex(columnIndex);
        Comparator columnComparator = this.getDataColumnComparator(aColumnIndex);
        DataModel dataModel = this.getTableDataModel();
        List dataList = dataModel.getDataList();
        Comparator rowComparator = dataModel.getRowComparator(columnComparator, columnIndex, aAscSort);
        Collections.sort(dataList, rowComparator);
        this.getTableColumnModel().setColumnSortedKey(aColumnIndex);
        this.getTableColumnModel().setColumnSortedAsc(aAscSort);
    }

    public boolean isColumnSortKey(int aColumnIndex) {
        return this.isColumnSortSupported(aColumnIndex) && this.getTableColumnModel().isColumnSortKey(aColumnIndex);
    }

    public int getColumnSortedKey() {
        return this.getTableColumnModel().getColumnSortedKey();
    }

    public boolean isColumnSortedAsc() {
        return this.getTableColumnModel().isColumnSortedAsc();
    }

    public Cursor getCursor() {
        return this.getTableDataModel().getCursor();
    }

    public Iterator getDataByCursor() {
        return this.getTableDataModel().getDataByCursor();
    }

    public int getRowCountByCursor() {
        return this.getTableDataModel().getRowCountByCursor();
    }

    public int getFirstRowIndexByCursor() {
        return this.getTableDataModel().getFirstRowIndexByCursor();
    }

    public int getLastRowIndexByCursor() {
        return this.getTableDataModel().getLastRowIndexByCursor();
    }

    public void setCursorPageSize(int aPageSize) {
        this.getTableDataModel().setCursorPageSize(aPageSize);
    }

    public int getCursorPageSize() {
        return this.getTableDataModel().getCursorPageSize();
    }

    public int getCursorCurrentPage() {
        return this.getTableDataModel().getCursorCurrentPage();
    }

    public void cursorToStart() {
        this.getTableDataModel().cursorToStart();
    }

    public void cursorToEnd() {
        this.getTableDataModel().cursorToEnd();
    }

    public void cursorStepForward() {
        this.getTableDataModel().cursorStepForward();
    }

    public void cursorStepBackward() {
        this.getTableDataModel().cursorStepBackward();
    }

    public void cursorGoToPage(int aPage) {
        this.getTableDataModel().getCursor().setStep(aPage);
    }

    public boolean isCursorFirstPage() {
        return this.getTableDataModel().isCursorFirstPage();
    }

    public boolean isCursorLastPage() {
        return this.getTableDataModel().isCursorLastPage();
    }

    public int getCursorPagesCount() {
        return this.getTableDataModel().getCursorPagesCount();
    }

    public void changeRowSelectionByCursor() {
        if (this.isRowSelectionAllowed()) {
            int i = this.getFirstRowIndexByCursor();
            while (i <= this.getLastRowIndexByCursor()) {
                if (this.isRowSelected(i)) {
                    return;
                }
                ++i;
            }
            this.getRowSelectionModel().clear();
            this.addRowSelectionInterval(new Interval(this.getFirstRowIndexByCursor()));
        }
    }

    private static final void exceptionHeaderNotFound() {
    }

    public void setShowHeader(boolean aShowHeader) {
        this.getHeader().setShowHeader(aShowHeader);
    }

    public boolean isShowHeader() {
        Header tableHeader = this.getTableHeader();
        return tableHeader == null ? false : tableHeader.isShowHeader();
    }

    public HeaderRenderer getColumnHeaderRenderer(int aColumnIndex) {
        Column tableColumn = this.getTableColumnModel().findColumn(aColumnIndex);
        if (tableColumn != null) {
            HeaderRenderer renderer = tableColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getHeader().getDefaultHeaderRenderer();
            }
            return renderer;
        }
        return null;
    }

    public void setHeaderNoWrapMode(boolean aNoWrapMode) {
        this.getHeader().setNoWrapMode(aNoWrapMode);
    }

    public boolean isHeaderNoWrapMode() {
        Header tableHeader = this.getTableHeader();
        return tableHeader == null ? false : tableHeader.isNoWrapMode();
    }

    public void setHeaderHighLightAllowed(boolean aHighLightAllowed) {
        this.getHeader().setHighLightAllowed(aHighLightAllowed);
    }

    public boolean isHeaderHighLightAllowed() {
        Header tableHeader = this.getTableHeader();
        return tableHeader == null ? false : tableHeader.isHighLightAllowed();
    }

    public void setHeaderHintText(String aHintText) {
        this.getHeader().setHintText(aHintText);
    }

    public String getHeaderHintText(int aColumnIndex) {
        Header tableHeader;
        String columnHint = this.getColumn(aColumnIndex).getHintText();
        String result = null;
        result = columnHint == null ? ((tableHeader = this.getTableHeader()) == null ? null : tableHeader.getHintText()) : columnHint;
        return result;
    }

    public void setHeaderHeight(String aHeight) {
        this.getHeader().setHeight(aHeight);
    }

    public String getHeaderHeight() {
        Header tableHeader = this.getTableHeader();
        return tableHeader == null ? null : tableHeader.getHeight();
    }

    public void setHeaderAlignMode(int aAlignMode) {
        this.getHeader().setAlignMode(aAlignMode);
    }

    public int getHeaderAlignMode() {
        Header tableHeader = this.getTableHeader();
        return tableHeader == null ? -1 : tableHeader.getAlignMode();
    }

    public void setHeaderValignMode(int aValignMode) {
        this.getHeader().setValignMode(aValignMode);
    }

    public int getHeaderValignMode() {
        Header tableHeader = this.getTableHeader();
        return tableHeader == null ? -1 : tableHeader.getValignMode();
    }

    public void setDefaultRendererByClass(Class aColumnClass, CellRenderer aTableCellRenderer) {
        TableImpl.validateValue(aColumnClass, "Column class");
        if (aTableCellRenderer != null) {
            this.fDefaultRenderersByColumnClass.put(aColumnClass, aTableCellRenderer);
        } else {
            this.fDefaultRenderersByColumnClass.remove(aColumnClass);
        }
    }

    public void setDefaultRendererByClass(Class aColumnClass, Class aTableCellRendererClass) {
        TableImpl.validateValue(aColumnClass, "Column class");
        if (aTableCellRendererClass != null) {
            this.fDefaultRenderersByColumnClass.putLazyValue(aColumnClass, aTableCellRendererClass);
        } else {
            this.fDefaultRenderersByColumnClass.remove(aColumnClass);
        }
    }

    public CellRenderer getDefaultRendererByClass(Class aColumnClass) {
        TableImpl.validateValue(aColumnClass, "Column class");
        Object renderer = this.fDefaultRenderersByColumnClass.get(aColumnClass);
        if (renderer != null) {
            return (CellRenderer)renderer;
        }
        return this.getDefaultRendererByClass(aColumnClass.getSuperclass());
    }

    public void setDefaultEditorByClass(Class aColumnClass, CellRenderer aTableCellEditor) {
        TableImpl.validateValue(aColumnClass, "Column class");
        if (aTableCellEditor != null) {
            this.fDefaultEditorsByColumnClass.put(aColumnClass, aTableCellEditor);
        } else {
            this.fDefaultEditorsByColumnClass.remove(aColumnClass);
        }
    }

    public void setDefaultEditorByClass(Class aColumnClass, Class aTableCellEditorClass) {
        TableImpl.validateValue(aColumnClass, "Column class");
        if (aTableCellEditorClass != null) {
            this.fDefaultEditorsByColumnClass.putLazyValue(aColumnClass, aTableCellEditorClass);
        } else {
            this.fDefaultEditorsByColumnClass.remove(aColumnClass);
        }
    }

    public CellRenderer getDefaultEditorByClass(Class aColumnClass) {
        TableImpl.validateValue(aColumnClass, "Column class");
        Object renderer = this.fDefaultEditorsByColumnClass.get(aColumnClass);
        if (renderer != null) {
            return (CellRenderer)renderer;
        }
        return this.getDefaultEditorByClass(aColumnClass.getSuperclass());
    }

    public void setDefaultComparatorByClass(Class aColumnClass, Comparator aTableCellComparartor) {
        TableImpl.validateValue(aColumnClass, "Column class");
        if (aTableCellComparartor != null) {
            this.fDefaultComparatorByColumnClass.put(aColumnClass, aTableCellComparartor);
        } else {
            this.fDefaultComparatorByColumnClass.remove(aColumnClass);
        }
    }

    public void setDefaultComparatorByClass(Class aColumnClass, Class aTableCellComparartorClass) {
        TableImpl.validateValue(aColumnClass, "Column class");
        if (aTableCellComparartorClass != null) {
            this.fDefaultComparatorByColumnClass.putLazyValue(aColumnClass, aTableCellComparartorClass);
        } else {
            this.fDefaultComparatorByColumnClass.remove(aColumnClass);
        }
    }

    public Comparator getDefaultComparatorByClass(Class aColumnClass) {
        TableImpl.validateValue(aColumnClass, "Column class");
        Object comparator = this.fDefaultComparatorByColumnClass.get(aColumnClass);
        if (comparator != null) {
            return (Comparator)comparator;
        }
        return this.getDefaultComparatorByClass(aColumnClass.getSuperclass());
    }

    public void setDefaultCellChangerByClass(Class aColumnClass, CellChanger aTableCellChanger) {
        TableImpl.validateValue(aColumnClass, "Column class");
        if (aTableCellChanger != null) {
            this.fDefaultCellChangersByColumnClass.put(aColumnClass, aTableCellChanger);
        } else {
            this.fDefaultCellChangersByColumnClass.remove(aColumnClass);
        }
    }

    public void setDefaultCellChangerByClass(Class aColumnClass, Class aTableCellChangerClass) {
        TableImpl.validateValue(aColumnClass, "Column class");
        if (aTableCellChangerClass != null) {
            this.fDefaultCellChangersByColumnClass.putLazyValue(aColumnClass, aTableCellChangerClass);
        } else {
            this.fDefaultCellChangersByColumnClass.remove(aColumnClass);
        }
    }

    public CellChanger getDefaultCellChangerByClass(Class aColumnClass) {
        TableImpl.validateValue(aColumnClass, "Column class");
        Object changer = this.fDefaultCellChangersByColumnClass.get(aColumnClass);
        if (changer != null) {
            return (CellChanger)changer;
        }
        return this.getDefaultCellChangerByClass(aColumnClass.getSuperclass());
    }

    public CellChanger getCellChanger(int aRowIndex, int aColumnIndex) {
        CellChanger changer;
        Column tableColumn = this.getTableColumnModel().findColumn(aColumnIndex);
        if (tableColumn == null) {
            TableImpl.columnIndexNotSupported();
        }
        if ((changer = tableColumn.getCellChanger()) == null) {
            changer = this.getDefaultCellChangerByClass(this.getCellClass(aRowIndex, aColumnIndex));
        }
        return changer;
    }

    public CellRenderer getCellRenderer(int aRowIndex, int aColumnIndex) {
        CellRenderer renderer;
        Column tableColumn = this.getTableColumnModel().findColumn(aColumnIndex);
        if (tableColumn == null) {
            TableImpl.columnIndexNotSupported();
        }
        if ((renderer = tableColumn.getCellRenderer()) == null) {
            renderer = this.getDefaultRendererByClass(this.getCellClass(aRowIndex, aColumnIndex));
        }
        return renderer;
    }

    public CellRenderer getCellEditor(int aRowIndex, int aColumnIndex) {
        CellRenderer renderer;
        Column tableColumn = this.getTableColumnModel().findColumn(aColumnIndex);
        if (tableColumn == null) {
            TableImpl.columnIndexNotSupported();
        }
        if ((renderer = tableColumn.getCellEditor()) == null) {
            renderer = this.getDefaultEditorByClass(this.getCellClass(aRowIndex, aColumnIndex));
        }
        return renderer;
    }

    public Comparator getDataColumnComparator(int aColumnIndex) {
        Comparator comparator;
        Column tableColumn = this.getTableColumnModel().findColumn(aColumnIndex);
        if (tableColumn == null) {
            TableImpl.columnIndexNotSupported();
        }
        if ((comparator = tableColumn.getDataComparator()) == null) {
            comparator = this.getDefaultComparatorByClass(this.getColumnClass(aColumnIndex));
        }
        return comparator;
    }

    public void setRowSelectionAllowed(boolean aRowSelectionAllowed) {
        this.fRowSelectionAllowed = aRowSelectionAllowed;
    }

    public boolean isRowSelectionAllowed() {
        return this.fRowSelectionAllowed;
    }

    public void setRowSelectionModel(ListSelectionModel aListSelectionModel) {
        TableImpl.validateValue(aListSelectionModel, "ListSelection model");
        this.fRowSelectionModel = aListSelectionModel;
    }

    public ListSelectionModel getRowSelectionModel() {
        return this.fRowSelectionModel;
    }

    public void setRowSelectionType(int aType) {
        if (aType < 1 || aType > 3) {
            throw new IllegalArgumentException("Table: type of selection not supported.");
        }
        this.getRowSelectionModel().setSelectionType(aType);
    }

    public int getRowSelectionType() {
        return this.getRowSelectionModel().getSelectionType();
    }

    public void setRowSelectionInterval(Interval aInterval) {
        TableImpl.validateValue(aInterval, "Selection interval");
        this.getRowSelectionModel().setSelectionInterval(aInterval);
    }

    public void addRowSelectionInterval(Interval aInterval) {
        TableImpl.validateValue(aInterval, "Selection interval");
        this.getRowSelectionModel().addSelectionInterval(aInterval);
    }

    public void removeRowSelectionInterval(Interval aInterval) {
        TableImpl.validateValue(aInterval, "Selection interval");
        this.getRowSelectionModel().removeSelectionInterval(aInterval);
    }

    public Interval[] getRowSelectionIntervals() {
        return this.getRowSelectionModel().getSelectionIntervals();
    }

    public int[] getSelectedRows() {
        return this.getRowSelectionModel().getSelectionIndexes();
    }

    public int getSelectedRowsCount() {
        return this.getRowSelectionModel().getSelectionCount();
    }

    public boolean isRowSelected(int aRowIndex) {
        if (this.isRowSelectionAllowed()) {
            return this.getRowSelectionModel().isSelected(aRowIndex);
        }
        return false;
    }

    public boolean isCellSelected(int aRowIndex, int aColumnIndex) {
        return this.isRowSelected(aRowIndex) || this.isColumnSelected(aColumnIndex);
    }

    public void setColumnSelectionAllowed(boolean aColumnSelectionAllowed) {
        this.getTableColumnModel().setColumnSelectionAllowed(aColumnSelectionAllowed);
    }

    public boolean isColumnSelectionAllowed() {
        return this.getTableColumnModel().isColumnSelectionAllowed();
    }

    public void setColumnSelectionInterval(Interval aInterval) {
        TableImpl.validateValue(aInterval, "Selection interval");
        this.getTableColumnModel().getColumnSelectionModel().setSelectionInterval(aInterval);
    }

    public void addColumnSelectionInterval(Interval aInterval) {
        TableImpl.validateValue(aInterval, "Selection interval");
        this.getTableColumnModel().getColumnSelectionModel().addSelectionInterval(aInterval);
    }

    public void removeColumnSelectionInterval(Interval aInterval) {
        TableImpl.validateValue(aInterval, "Selection interval");
        this.getTableColumnModel().getColumnSelectionModel().removeSelectionInterval(aInterval);
    }

    public Interval[] getColumnSelectionIntervals() {
        return this.getTableColumnModel().getColumnSelectionModel().getSelectionIntervals();
    }

    public int[] getSelectedColumns() {
        return this.getTableColumnModel().getColumnSelectionModel().getSelectionIndexes();
    }

    public int getSelectedColumnsCount() {
        return this.getTableColumnModel().getColumnSelectionModel().getSelectionCount();
    }

    public boolean isColumnSelected(int aColumnIndex) {
        if (this.isColumnSelectionAllowed()) {
            return this.getTableColumnModel().getColumnSelectionModel().isSelected(aColumnIndex);
        }
        return false;
    }

    public void setColumnSelectionModel(ListSelectionModel aListSelectionModel) {
        TableImpl.validateValue(aListSelectionModel, "ListSelection model");
        this.getTableColumnModel().setColumnSelectionModel(aListSelectionModel);
    }

    public ListSelectionModel getColumnSelectionModel() {
        return this.getTableColumnModel().getColumnSelectionModel();
    }

    public void setColumnSelectionType(int aType) {
        if (aType < 1 || aType > 3) {
            throw new IllegalArgumentException("Table: type of selection not supported.");
        }
        this.getTableColumnModel().getColumnSelectionModel().setSelectionType(aType);
    }

    public int getColumnSelectionType() {
        return this.getTableColumnModel().getColumnSelectionModel().getSelectionType();
    }

    public void setCellSelectionEnabled(boolean aCellSelectionEnabled) {
        this.setRowSelectionAllowed(aCellSelectionEnabled);
        this.setColumnSelectionAllowed(aCellSelectionEnabled);
    }

    public boolean isCellSelectionEnabled() {
        return this.isRowSelectionAllowed() && this.isColumnSelectionAllowed();
    }

    public void selectAll() {
        this.setRowSelectionInterval(new Interval(0, this.getRowCount() - 1));
        this.setColumnSelectionInterval(new Interval(0, this.getColumnCount() - 1));
    }

    public void clearSelection() {
        this.getRowSelectionModel().clear();
        this.getTableColumnModel().getColumnSelectionModel().clear();
    }

    protected DataModel createDefaultDataModel() {
        return new DataModelImpl();
    }

    protected ColumnModel createDefaultColumnModel() {
        return this.isAutoColumnCreationMode() && this.getTableDataModel() != null ? this.getTableDataModel().createDefaultColumnModel() : new ColumnModelImpl();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new ListSelectionModelImpl();
    }

    protected Header createDefaultTableHeader() {
        return new HeaderImpl(this.getTableColumnModel());
    }

    protected void createDefaultRenderers() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz10 = class$1) == null) {
            try {
                clazz10 = class$1 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.DefaultCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz11, clazz10);
        Class<?> clazz12 = class$2;
        if (clazz12 == null) {
            try {
                clazz12 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz9 = class$3) == null) {
            try {
                clazz9 = class$3 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.booleans.BooleanCheckBoxTableCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz12, clazz9);
        Class<?> clazz13 = class$4;
        if (clazz13 == null) {
            try {
                clazz13 = class$4 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz8 = class$5) == null) {
            try {
                clazz8 = class$5 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.number.NumberDefaultTableCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz13, clazz8);
        Class<?> clazz14 = class$6;
        if (clazz14 == null) {
            try {
                clazz14 = class$6 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Percent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz7 = class$7) == null) {
            try {
                clazz7 = class$7 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.number.NumberPercentTableCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz14, clazz7);
        Class<?> clazz15 = class$8;
        if (clazz15 == null) {
            try {
                clazz15 = class$8 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Currency");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz6 = class$9) == null) {
            try {
                clazz6 = class$9 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.number.NumberCurrencyTableCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz15, clazz6);
        Class<?> clazz16 = class$10;
        if (clazz16 == null) {
            try {
                clazz16 = class$10 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz5 = class$11) == null) {
            try {
                clazz5 = class$11 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.DateTableCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz16, clazz5);
        Class<?> clazz17 = class$12;
        if (clazz17 == null) {
            try {
                clazz17 = class$12 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz4 = class$11) == null) {
            try {
                clazz4 = class$11 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.DateTableCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz17, clazz4);
        Class<?> clazz18 = class$13;
        if (clazz18 == null) {
            try {
                clazz18 = class$13 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$14) == null) {
            try {
                clazz3 = class$14 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.TimeTableCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz18, clazz3);
        Class<?> clazz19 = class$15;
        if (clazz19 == null) {
            try {
                clazz19 = class$15 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$14) == null) {
            try {
                clazz2 = class$14 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.TimeTableCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz19, clazz2);
        Class<?> clazz20 = class$16;
        if (clazz20 == null) {
            try {
                clazz20 = class$16 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$DateTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$17) == null) {
            try {
                clazz = class$17 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.DateTimeTableCellRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultRenderersByColumnClass.putLazyValue(clazz20, clazz);
    }

    protected void createDefaultEditors() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz10 = class$18) == null) {
            try {
                clazz10 = class$18 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.DefaultCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz11, clazz10);
        Class<?> clazz12 = class$2;
        if (clazz12 == null) {
            try {
                clazz12 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz9 = class$19) == null) {
            try {
                clazz9 = class$19 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.booleans.BooleanCheckBoxTableCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz12, clazz9);
        Class<?> clazz13 = class$4;
        if (clazz13 == null) {
            try {
                clazz13 = class$4 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz8 = class$20) == null) {
            try {
                clazz8 = class$20 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.number.NumberDefaultTableCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz13, clazz8);
        Class<?> clazz14 = class$8;
        if (clazz14 == null) {
            try {
                clazz14 = class$8 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Currency");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz7 = class$21) == null) {
            try {
                clazz7 = class$21 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.number.NumberCurrencyTableCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz14, clazz7);
        Class<?> clazz15 = class$6;
        if (clazz15 == null) {
            try {
                clazz15 = class$6 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Percent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz6 = class$22) == null) {
            try {
                clazz6 = class$22 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.number.NumberPercentTableCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz15, clazz6);
        Class<?> clazz16 = class$10;
        if (clazz16 == null) {
            try {
                clazz16 = class$10 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz5 = class$23) == null) {
            try {
                clazz5 = class$23 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.DateTableCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz16, clazz5);
        Class<?> clazz17 = class$12;
        if (clazz17 == null) {
            try {
                clazz17 = class$12 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz4 = class$23) == null) {
            try {
                clazz4 = class$23 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.DateTableCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz17, clazz4);
        Class<?> clazz18 = class$13;
        if (clazz18 == null) {
            try {
                clazz18 = class$13 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$24) == null) {
            try {
                clazz3 = class$24 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.TimeTableCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz18, clazz3);
        Class<?> clazz19 = class$15;
        if (clazz19 == null) {
            try {
                clazz19 = class$15 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$24) == null) {
            try {
                clazz2 = class$24 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.TimeTableCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz19, clazz2);
        Class<?> clazz20 = class$16;
        if (clazz20 == null) {
            try {
                clazz20 = class$16 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$DateTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$25) == null) {
            try {
                clazz = class$25 = Class.forName("com.softaspects.framework.galileo.renderers.html.table.additions.date.DateTimeTableCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultEditorsByColumnClass.putLazyValue(clazz20, clazz);
    }

    protected void createDefaultComporators() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz4 = class$26) == null) {
            try {
                clazz4 = class$26 = Class.forName("com.softaspects.framework.galileo.components.table.BaseComparator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultComparatorByColumnClass.putLazyValue(clazz5, clazz4);
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$27) == null) {
            try {
                clazz3 = class$27 = Class.forName("com.softaspects.framework.galileo.components.table.additions.comparators.NumberComparator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultComparatorByColumnClass.putLazyValue(clazz6, clazz3);
        Class<?> clazz7 = class$2;
        if (clazz7 == null) {
            try {
                clazz7 = class$2 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$28) == null) {
            try {
                clazz2 = class$28 = Class.forName("com.softaspects.framework.galileo.components.table.additions.comparators.BooleanComparator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultComparatorByColumnClass.putLazyValue(clazz7, clazz2);
        Class<?> clazz8 = class$10;
        if (clazz8 == null) {
            try {
                clazz8 = class$10 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$29) == null) {
            try {
                clazz = class$29 = Class.forName("com.softaspects.framework.galileo.components.table.additions.comparators.DateComparator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultComparatorByColumnClass.putLazyValue(clazz8, clazz);
    }

    protected void createDefaultCellChangers() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz9 = class$30) == null) {
            try {
                clazz9 = class$30 = Class.forName("com.softaspects.framework.galileo.components.table.BaseCellChanger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultCellChangersByColumnClass.putLazyValue(clazz10, clazz9);
        Class<?> clazz11 = class$4;
        if (clazz11 == null) {
            try {
                clazz11 = class$4 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz8 = class$31) == null) {
            try {
                clazz8 = class$31 = Class.forName("com.softaspects.framework.galileo.components.table.additions.changers.NumberChanger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultCellChangersByColumnClass.putLazyValue(clazz11, clazz8);
        Class<?> clazz12 = class$10;
        if (clazz12 == null) {
            try {
                clazz12 = class$10 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz7 = class$32) == null) {
            try {
                clazz7 = class$32 = Class.forName("com.softaspects.framework.galileo.components.table.additions.changers.DateChanger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultCellChangersByColumnClass.putLazyValue(clazz12, clazz7);
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz6 = class$32) == null) {
            try {
                clazz6 = class$32 = Class.forName("com.softaspects.framework.galileo.components.table.additions.changers.DateChanger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultCellChangersByColumnClass.putLazyValue(clazz13, clazz6);
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz5 = class$33) == null) {
            try {
                clazz5 = class$33 = Class.forName("com.softaspects.framework.galileo.components.table.additions.changers.TimeChanger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultCellChangersByColumnClass.putLazyValue(clazz14, clazz5);
        Class<?> clazz15 = class$15;
        if (clazz15 == null) {
            try {
                clazz15 = class$15 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz4 = class$33) == null) {
            try {
                clazz4 = class$33 = Class.forName("com.softaspects.framework.galileo.components.table.additions.changers.TimeChanger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultCellChangersByColumnClass.putLazyValue(clazz15, clazz4);
        Class<?> clazz16 = class$16;
        if (clazz16 == null) {
            try {
                clazz16 = class$16 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$DateTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$34) == null) {
            try {
                clazz3 = class$34 = Class.forName("com.softaspects.framework.galileo.components.table.additions.changers.DateTimeChanger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultCellChangersByColumnClass.putLazyValue(clazz16, clazz3);
        Class<?> clazz17 = class$6;
        if (clazz17 == null) {
            try {
                clazz17 = class$6 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Percent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$35) == null) {
            try {
                clazz2 = class$35 = Class.forName("com.softaspects.framework.galileo.components.table.additions.changers.PercentChanger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultCellChangersByColumnClass.putLazyValue(clazz17, clazz2);
        Class<?> clazz18 = class$8;
        if (clazz18 == null) {
            try {
                clazz18 = class$8 = Class.forName("com.softaspects.framework.galileo.components.table.ColumnsClass$Currency");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$36) == null) {
            try {
                clazz = class$36 = Class.forName("com.softaspects.framework.galileo.components.table.additions.changers.CurrencyChanger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fDefaultCellChangersByColumnClass.putLazyValue(clazz18, clazz);
    }

    public ChangeCommand getTableChangeRequest() {
        return this.fTableChangeRequest;
    }

    public void setChangeRequest(Map aChangesMap) {
        this.getTableChangeRequest().setChangeRequest(aChangesMap);
    }

    public void setChangeRequest(ServletRequest aChangesRequest) {
        this.getTableChangeRequest().setChangeRequest(aChangesRequest);
    }

    public void changeTableByRequest() {
        this.getTableChangeRequest().changeTable();
        this.getTableChangeRequest().clearChangeRequest();
    }

    public ChangeResult getTableChangeResponse() {
        return this.fTableChangeResponse;
    }

    public void addChangeResult(Object aChangeResult) {
        this.getTableChangeResponse().addChangeResult(aChangeResult);
    }

    public int getCountSuccessChanges() {
        return this.getTableChangeResponse().getCountSuccessChanges();
    }

    public int getCountChangeExceptions() {
        return this.getTableChangeResponse().getCountExceptions();
    }

    public Iterator getChangeExceptionsMessages() {
        return this.getTableChangeResponse().getExceptionsMessages();
    }

    public Iterator getSuccessChanges() {
        return this.getTableChangeResponse().getSuccessChanges();
    }

    public void clearAllChangeResponseMeassages() {
        this.getTableChangeResponse().clearAll();
    }

    protected static void validateValue(Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("Table: " + aName + " can't be null.");
        }
    }

    protected static void validateFoundIndex(int aFindIndex) {
        if (aFindIndex < 0) {
            throw new IllegalStateException("Table: Can't find column into model.");
        }
    }

    protected static void validateFoundColumn(Column aTableColumn) {
        if (aTableColumn == null) {
            throw new IllegalStateException("Table: Can't find column into model.");
        }
    }

    protected static void columnIndexNotSupported() {
        throw new IllegalStateException("Table: Column index not supported.");
    }
}

