

/*
 * @(#)AddClientListenerExample.java	
 *
 * Product Of	: MakeLogic
 * URL			: http://www.makelogic.com
 * Author		: R.Venkatesh
 * Date			: 18 June, 2003
 * email		: venkat@makelogicmldb.com
 * 
 * Please feel free to use this Sample Code in your applications.
 */

/*
 * This sample Application Demonstrates how to add 
 * your own Listener to the Application. 
 */

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.awt.BorderLayout;

import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import com.makeLogic.utils.FileMenu;

class AddClientListener extends JFrame implements ActionListener
{
	JDesktopPane desktop;
	JLabel statusLabel;
	JMenuBar menuBar;
	JPanel status;
	static int newIndex=0;
	
	
	AddClientListener(String title)
	{
		//..calls the super class constructor
		super(title);
		//..MenuBar
		menuBar = new JMenuBar();
		//..Container
		desktop=new JDesktopPane();

		//..Panel
		status=new JPanel();
		status.setLayout(new BorderLayout());

		//..JLabel 
		statusLabel=new JLabel();
		//..Set InitialText
		statusLabel.setText("Click on New to Call the Clients Event Listener");
		//..Adds the Label field to the status bar
		status.add("West",statusLabel);

		//..Gets the ContentPane of the JFrame and adds the container to the center
		getContentPane().add("Center",desktop);

		//..Gets the ContentPane of the JFrame and adds the JPanel to the South
		getContentPane().add("South",status);

		//..calls the First constructor of the FileMenu which assigns default KeyStrokes to the MenuItems
		FileMenu fileMenu=new FileMenu(desktop);

		//..add Listeners
		fileMenu.addNewMenuItemActionListener(this);
				
		//..add the fileMenu object to the JMenuBar
		menuBar.add(fileMenu);

		//..adds the MenuBar to the frame
		setJMenuBar(menuBar);

		addWindowListener(fileMenu.getDefaultClosingListener());
				
	}
	public void actionPerformed(ActionEvent evt)
	{
	
		//..Debug
		JOptionPane.showMessageDialog(this,"This is clientEvent : " + evt.getActionCommand());
		
				
		if(evt.getActionCommand().equalsIgnoreCase("New"))
		{
			//..increment the count
			newIndex++;
			//..set the status text
			statusLabel.setText(evt.getActionCommand()+"ClientHandler is called "+newIndex+" times");
		}
		
	}

	
}
public class AddClientListenerExample
{

	public static void main(String args[])
	{
		AddClientListener newMenuItem=new AddClientListener("Add Client Listener Example");
		newMenuItem.show();
		newMenuItem.setSize(500,500);
		newMenuItem.validate();
	}

}