
/*
 * @(#)DisableNewMenuItemExample.java	
 *
 * Product Of	: MakeLogic
 * URL			: http://www.makelogic.com
 * Author		: R.Venkatesh
 * Date			: 18 June, 2003
 * email		: venkat@makelogicmldb.com
 * 
 * Please feel free to use this Sample Code in your applications.
 */

/*
 * This sample Application will Demonstrate how to use the 
 * disableDefaultListener method which disables the Functionality
 * of the NewMenuItem of the FileMenu Object. 
 * 
 * similarly we can disable the Functionality of other MenuItems 
 * using its corresponding disableDefaultListener method.
 * 
 */

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

import com.makeLogic.utils.FileMenu;

class DisableNewMenuItem extends JFrame
{
	JMenuBar menuBar;
	JDesktopPane desktop;
	DisableNewMenuItem(String title)
	{
		//..calls the super class constructor
		super(title);
		//..MenuBar
		menuBar = new JMenuBar();
		//..Container
		desktop=new JDesktopPane();
		
		//..Gets the ContentPane of the JFrame and adds the container to the center
		getContentPane().add("Center",desktop);

		//..calls the First constructor of the FileMenu which assigns default KeyStrokes to the MenuItems
		//..The following two lines of code is sufficient to create complete FileMenu Object
		//..and adds it to the MenuBar
		FileMenu fileMenu=new FileMenu(desktop);

		//..simply add the fileMenu object to the JMenuBar
		menuBar.add(fileMenu);

		//..disable default Listener and you can add your own Listener
		fileMenu.disableDefaultNewMenuItemListener();

		
		//..adds the MenuBar to the frame
		setJMenuBar(menuBar);

		//..Window closing Listener
		addWindowListener(fileMenu.getDefaultClosingListener());
			
						
	}
		
}
public class DisableNewMenuItemExample
{

	public static void main(String args[])
	{
		DisableNewMenuItem newMenuItem=new DisableNewMenuItem("DisableNewMenuItemExample");
		newMenuItem.show();
		newMenuItem.setSize(500,500);
		newMenuItem.validate();
	}

}