/*
 * @(#)SaveAsMenuItem.java	1.1 11/17/2003
 *
 * Copyright 2003 MakeLogic, Inc. All rights reserved.
 * MakeLogic PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


/*
 * @(#)SaveAsMenuItem.java	1.1
 *
 * Author : R.Venkatesh
 * Copyright 2003 MakeLogic. All Rights Reserved.
 *
 * This software is the proprietary information of MakeLogic.
 * Use is subject to license terms.
 * 
 * 
 */

package com.makeLogic.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.File;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import java.util.Hashtable;
import java.util.Vector;


import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import com.makeLogic.utils.MLInternalFrame;

/**
 * SaveAs MenuItem is one of the MenuItems of FileMenu.<br>
 * It opens a FileChooser DialogBox.<br>
 * User can enter a File Name and click on OK to save it into a New File.
 */
public class SaveAsMenuItem extends JMenuItem implements ActionListener
{
	//..Declaration
	Container container;
	MLInternalFrame internalFrame;

	SaveAsMenuItem(Container container)
	{	
		//..calls the super class constructor
		super("SaveAs");

		//.. sets the default keystroke as CTRL+A for thr SaveAsMenuItem
		setAccelerator(KeyStroke.getKeyStroke('A',java.awt.Event.CTRL_MASK,false));

		//..adds the Listener class to the SaveAsMenuItem
		addActionListener(this);

		/*//..firePropertyChange
		JFileChooser fileChooser= new JFileChooser();
		firePropertyChange("FileChooserOpened",fileChooser,null);
		*/

		this.container=container;
	}
	public void setKeyStrokeForSaveAsMenuItem(KeyStroke saveAsMenuItemKeyStroke)
	{
		//..sets the user defined Keystroke for the SaveAsMenuItem
		setAccelerator(saveAsMenuItemKeyStroke);
	}
	public void actionPerformed(ActionEvent evt)
	{
		//.. Default Handler

		//..OpenFiles Hashtable
		Hashtable tempOpenMenuHash = FileMenu.getInternalFramesOpenFileNamesHashTable();

		//..NewFiles Hashtable
		Hashtable tempNewMenuHash =FileMenu.getInternalFramesNewFileNamesHashTable();
		
		//..gets the OpenFileEntries into recentFiles Vector
		Vector recentFileEntries=FileMenu.getRecentFileEntriesVector();

		//.. gets the InternalFrames
		Component componentInternalFrames[]=container.getComponents();

		//.. stores the InternalFrames in a InternalFrames array
		MLInternalFrame internalFrames[]=new MLInternalFrame[componentInternalFrames.length];

		for(int i=0;i<internalFrames.length;i++)
		{

			try
			{
				//..gets the MLInternalFrames from the component array
				internalFrames[i]=(MLInternalFrame)componentInternalFrames[i];
			}
			catch(ClassCastException cce)
			{
				//..Do nothing
				//..Debug
				//System.out.println(cce);
				JOptionPane.showMessageDialog(null,cce.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
			}
			//..searches for the Active InternalFrame
			if(internalFrames[i].isSelected()==true)
			{
				//..gets the Active InternalFrame
				this.internalFrame=internalFrames[i];

				//..gets the EditorPane from the InternalFrame
				Component[] jsp = internalFrame.getContentPane().getComponents();
				JScrollPane jspn = (JScrollPane)internalFrame.getContentPane().getComponent(0);
				JViewport jvp  = (JViewport)jspn.getViewport();
				JEditorPane jep = (JEditorPane)jvp.getView();

				//..Do this if the frame belongs to open hash table
				if(tempOpenMenuHash.containsKey(internalFrame))
				{
					//.. if it is  in Already Opened Ask the User to overwrite

					//..get the FileName of the Opend FileName
					String FileName=(String)tempOpenMenuHash.get(internalFrame);
					

					//..creates a File Object with the FileName and passed to the FileChooser
					File file=new File(FileName);

					//..Open a FileChooser
					JFileChooser fileChooser =new JFileChooser();

					//..Fire the property change event
					firePropertyChange("FileChooserOpened",fileChooser,null);

					//.. set the file path in the FileChooser
					fileChooser.setSelectedFile(file);

					//.. show the FileChooser
					int response=fileChooser.showSaveDialog(container);

					//..Do this if Save Button is Clicked
					if(response==JFileChooser.APPROVE_OPTION)
					{

						//..gets the selected file						
						file=fileChooser.getSelectedFile();

						//.. checks for File Existance
						if(file.exists()==true)
						{
							//..Do this if file exists

							//..Open a confirm dialog to overwrite the selected file
							int result=JOptionPane.showConfirmDialog(internalFrame,"This File Already Exists, Do You want to Replace the Existing File ?","Confirm Dialog",JOptionPane.YES_NO_OPTION);

							if(result==JOptionPane.YES_OPTION)
							{
								//..Overwrite the File
								try
								{
									//.. Open the file in output mode
									DataOutputStream outputStream= new DataOutputStream(new FileOutputStream(file.getAbsolutePath()));

									//.. write the EditorPane contents into a file
									outputStream.writeBytes(jep.getText());

									//..change the flag to saved mode
									internalFrame.setChanged(false);

									//.. removes '*' from the Frame Title 
									if(internalFrame.getTitle().endsWith("*"))
									{
										internalFrame.setTitle(internalFrame.getTitle().substring(0,internalFrame.getTitle().length()-1));
									}
														
								}
								catch(FileNotFoundException fnfe)
								{
									//fnfe.printStackTrace();
									JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
								}
								catch(IOException ioexcep)
								{
									//ioexcep.printStackTrace();
									JOptionPane.showMessageDialog(null,ioexcep.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
								}

							}													
							else if(result==JOptionPane.NO_OPTION)
							{
								return;
							}

						}
						else
						{

							//.. Do this if file does not exists
							try
							{
								//.. Open the file in output mode
								DataOutputStream outputStream= new DataOutputStream(new FileOutputStream(file.getAbsolutePath()));

								//.. write the EditorPane contents into a  file
								outputStream.writeBytes(jep.getText());

								//..change the flag to saved mode
								internalFrame.setChanged(false);

								//.. removes '*' from the Frame Title 
								if(internalFrame.getTitle().endsWith("*"))
								{
									internalFrame.setTitle(internalFrame.getTitle().substring(0,internalFrame.getTitle().length()-1));
								}
								
								//..Debug
								//.. sets the New Title if changed
								internalFrame.setTitle(file.getAbsolutePath());
							}
							catch(FileNotFoundException fnfe)
							{
								//fnfe.printStackTrace();
								JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
							}
							catch(IOException ioexcep)
							{
								//ioexcep.printStackTrace();
								JOptionPane.showMessageDialog(null,ioexcep.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);																
							}

							//..add the file path in OpenHashtable
                            tempOpenMenuHash.put(internalFrame,file.getAbsolutePath());

							//..add the file name to the recentFile vector
							recentFileEntries.add(file.getAbsolutePath());

						}
							
					}//.. END_IF (SAVE OPTION)
	
				}
				else
				{
					//..if it is in New InternalHash
					if(tempNewMenuHash.containsKey(internalFrame))
					{
						//..get the FileName of NewFile
						String newFileName=(String)tempNewMenuHash.get(internalFrame);
						
						//..set the FileName as newFileName+".txt"
						File currentFile=new File(newFileName+".txt");

						//..Open a FileChooser
						JFileChooser fileChooser =new JFileChooser();

						//..Fire the property change event
						firePropertyChange("FileChooserOpened",fileChooser,null);

						//.. set the file path in the FileChooser
						fileChooser.setSelectedFile(currentFile);

						//.. show the FileChooser
						int response=fileChooser.showSaveDialog(container);

						//..if Save Button is clicked save the new Frame in the given path

						if(response==JFileChooser.APPROVE_OPTION)
						{
							//..Do this if Save button is clicked
					
							try
							{
								//.. Open the file in output mode
								DataOutputStream outputStream= new DataOutputStream(new FileOutputStream(fileChooser.getSelectedFile()));

								//.. write the EditorPane contents into a file
								outputStream.writeBytes(jep.getText());

								//..change the flag to saved mode
								internalFrame.setChanged(false);

								//.. removes '*' from the Frame Title 
								if(internalFrame.getTitle().endsWith("*"))
								{
									internalFrame.setTitle(internalFrame.getTitle().substring(0,internalFrame.getTitle().length()-1));
								}

								internalFrame.setTitle(fileChooser.getSelectedFile().getAbsolutePath());

								//..remove the InternalFrame from the New Hashtable
								tempNewMenuHash.remove(internalFrame);

								//..Add the InternalFrame into Open Hashtable
								tempOpenMenuHash.put(internalFrame,fileChooser.getSelectedFile().getAbsolutePath());

                                //.. Add the FilePath to the RecentFileVectot
								recentFileEntries.add(fileChooser.getSelectedFile().getAbsolutePath());
								
								
							}
							catch(FileNotFoundException fnfe)
							{
								//fnfe.printStackTrace();
								JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
							}
							catch(IOException ioexcep)
							{
								//ioexcep.printStackTrace();
								JOptionPane.showMessageDialog(null,ioexcep.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
							}

						}//..end-if


					}

				}
			}//..End-if

		}//.. End-for-loop





	}
}