/*
 * @(#)RecentFilesMenuItem.java	1.1 11/17/2003
 *
 * Copyright 2003 MakeLogic, Inc. All rights reserved.
 * MakeLogic PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)RecentFilesMenuItem.java	1.1
 *
 * Author : R.Venkatesh
 * Copyright 2003 MakeLogic. All Rights Reserved.
 *
 * This software is the proprietary information of MakeLogic.
 * Use is subject to license terms.
 * 
 *
 */

package com.makeLogic.utils;


import java.awt.Container;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.Vector;
import java.util.Hashtable;

import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;


import com.makeLogic.utils.MLInternalFrame;

/** RecentFiles Menu is a Menu of FileMenu.<br>
 *  Its Functionality is to display the recent 8 Filepaths into it.<br>
 *  It opens the file if it is selected from the list.
 */
public class RecentFilesMenuItem extends JMenu implements ActionListener
{
	//..Declarations
	Container container;

	//..temporary Hashtable to store openFiles reference
	Hashtable tempOpenHash;

	//.. temporary vector to store openFiles reference
	Vector tempVector;

	//..Hashtable which stores the OpenFileEntry keys
	Hashtable internalFramesOpenFileNames;

	//..Vector which stores the OpenFileEntries
	Vector recentFileEntries;

	//..Constructor
	RecentFilesMenuItem(Container container)
	{
		//..calls the super class constructor
		super("Recent Files");
		//..sets the Default Mnemonic as 'F' to RecentFiles Menu
		setMnemonic('F') ;

		//..adds the Listener to RecentFilesMenu
		addActionListener(this);

		this.container=container;
	}  

	public void setKeyStrokeForRecentFilesMenuItem(char recentFilesMenuItemKeyStroke)
	{
		//..sets userdefined accelerator to the RecentFiles Menu
		setMnemonic(recentFilesMenuItemKeyStroke);
	}
	public void actionPerformed(ActionEvent evt)
	{
		/*
	  * gets the FileName and Opens the corresponding file in the MLInternalFrame
	  * */
		try
		{
			//..gets the FileName from the  Selected MenuItem
			String filePathString = evt.getActionCommand();
			
			//..creates a File Object
			File selectedFile=new File(filePathString);

			//..Opens a File using DataInputSteam Object
			DataInputStream inputStream=new DataInputStream(new FileInputStream(filePathString));

			//..creates a String Buffer
			StringBuffer stringBuffer=new StringBuffer((int)selectedFile.length());
			
			//..makes the temporary string null
			String tempText="";

			//.. reads the file contents and appends to the StringBuffer
			while(( tempText=inputStream.readLine() )!=null)
			{
				//tempText=inputStream.readLine();
				stringBuffer.append(tempText+"\n");
			}

			//.. Creates a new MLInternalFrame 
			MLInternalFrame internalFrame=new MLInternalFrame(container,selectedFile,stringBuffer);

			//..Gets the JEditorPane from teh INternalFrame
			JViewport jvp=(JViewport)((JScrollPane)internalFrame.getContentPane().getComponent(0)).getComponent(0);
			JEditorPane jep=(JEditorPane)jvp.getComponent(0);

			//..sets the Caret position at 0.
			jep.setCaretPosition(0);

			//..gets the InternalFramesHashtable
			internalFramesOpenFileNames=FileMenu.getInternalFramesOpenFileNamesHashTable();

			//..gets the OpenFiles Vector
			recentFileEntries=FileMenu.getRecentFileEntriesVector();

			//..puts the FilePath into the Hashtable with the InternalFrame as key
			internalFramesOpenFileNames.put(internalFrame,selectedFile.getAbsolutePath());

			//..put the FilePath into the RecentOpenFilesVecor
			recentFileEntries.add(selectedFile.getAbsolutePath());

			//..adds the closingInternalFrameListener to it
			internalFrame.addInternalFrameListener(new InternalFrameClosingHandler(container,internalFramesOpenFileNames,internalFrame));

		}
		catch(FileNotFoundException fnfe)
		{
			//fnfe.printStackTrace();
			JOptionPane.showMessageDialog(null,fnfe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
		}
		catch(IOException ioe)
		{
			//ioe.printStackTrace();
			JOptionPane.showMessageDialog(null,ioe.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
		}

	}

	
		
}