/*
 * @(#)MLInteralFrame.java	1.1 11/17/2003
 *
 * Copyright 2003 MakeLogic, Inc. All rights reserved.
 * MakeLogic PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.makeLogic.utils;


import java.awt.Container;

import java.beans.PropertyVetoException;

import java.io.File;

import java.util.Hashtable;

import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.WindowConstants;


import com.makeLogic.utils.MLEditorListener;

/**
 *  This class will create its own InternalFrame which extends <br>
 * from JInternalFrame.It will act as a container for JEditorPane <br>
 * and JScrollPane.
 * 
 */
public class MLInternalFrame extends JInternalFrame 
{
	//..Variables Declaration
	JScrollPane scrollPane;
	JEditorPane editorPane;
	Container container;
	boolean changed;

	//..constructor
	MLInternalFrame(Container container,File selectedFile,StringBuffer fileContents)
	{
		//.. creates an JInternalFrame with the follwing path and it is resizable,closable,maximizable,iconfiable
		super(selectedFile.getAbsolutePath(),true,true,true,true);  		

		//..Set the default action for the close box click
		this.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

		this.container=container;

		//..initailizes the changed flag to false
		changed = false;
		
		//..Gets the Component of the InternalFrame
		JComponent contentPane=(JComponent)this.getContentPane();
		
		//.. sets the file contents to the editorPane
		//..EditorPane
		editorPane=new JEditorPane();

		//..make the EditorPane to Editable
		editorPane.setEditable(true);
		
		//..add the filecontents to the EditorPane
		editorPane.setText(new String(fileContents));

		// adds the documentListener to the EditorPane
		editorPane.getDocument().addDocumentListener(new MLEditorListener(this));
		
		
		//.. adds the scrollPane to the MLInternalFrame
        scrollPane=new JScrollPane(editorPane);
		contentPane.add(scrollPane);

		//.. makes the size of the MLInternalFrame to the size of the container
		this.reshape(0,0,container.getWidth(),container.getHeight());
		//..makes the internalFrame to Visible
		this.show();

		//.. Adds the MLInternalFrame to the container
		container.add(this);

		container.validate();

	
		//.. makes the currently opened InternalFrame to the front
		try
		{
			//..makes the currentFrame Active
			this.setSelected(true);
		}
		catch(PropertyVetoException pve)
		{
			//pve.printStackTrace();
			JOptionPane.showMessageDialog(null,pve.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
		}
	}


	//..Accessor method for the changed flag
	public boolean getChanged()
	{
		return changed;
	}

	//..Mutator method for the changed flag
	public void setChanged(boolean changed)
	{
		this.changed = changed;
	}


}

