/*
 * @(#)ExitMenuItem.java	1.1 11/17/2003
 *
 * Copyright 2003 MakeLogic, Inc. All rights reserved.
 * MakeLogic PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)ExitMenuItem.java	1.1
 *
 * Author : R.Venkatesh
 * Copyright 2003 MakeLogic. All Rights Reserved.
 *
 * This software is the proprietary information of MakeLogic.
 * Use is subject to license terms.
 * 
 */

package com.makeLogic.utils;

import java.awt.Component;
import java.awt.Container;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.beans.PropertyVetoException;

import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import com.makeLogic.utils.MLInternalFrame;

/** 
 *  Exit MenuItem is One of the MenuItems of FileMenu.<br>
 *  It closes all the windows if any<br>
 *  Closes the Application whenever it is clicked
 */

public class ExitMenuItem extends JMenuItem implements ActionListener
{
	//..Declarations
	Container container;
	ExitMenuItem(Container container)
	{	
		//..calls the superclass constructor for ExitMenuItem
		super("Exit");

		//..sets the DefaultAccelerator as CTRL+X for the ExitMenuItem
		setAccelerator(KeyStroke.getKeyStroke('X',java.awt.Event.CTRL_MASK,false));

		//.. adds the Listener class to the ExitMenuItem
		addActionListener(this);

		this.container=container;
	}  

    public void setKeyStrokeForExitMenuItem(KeyStroke exitMenuItemKeyStroke)
	{
		//..sets user defined acceslerator to the ExitMenuItem
		setAccelerator(exitMenuItemKeyStroke);
	}
	public void actionPerformed(ActionEvent evt)
	{
		/*
		 * First checks for the Opend Files. If it finds any Opend Files closes it.
		 * */

		//..Intialize the MLInternalFrame to null
		MLInternalFrame tempFrame=null;

		//..gets the components array of OpendFiles
		Component[] components=container.getComponents();
		int k=0;

		//..searches for the OpendFrames
		while(components.length>0&&k<components.length)
		{
			//..if the File is Opend
			if(components[k]instanceof MLInternalFrame)
			{
				//..gets the OpendFrame
				tempFrame=(MLInternalFrame)components[k];

				k++;

				try
				{
					//..fires the closing Event
					tempFrame.setClosed(true);
				}
				catch(java.beans.PropertyVetoException pve)
				{
					JOptionPane.showMessageDialog(null,pve.getMessage(),"MakeLogic:FileMenu",JOptionPane.ERROR_MESSAGE);
				}
			}

		}
		//..Exits from the program
		System.exit(0);

	}
}