/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.xrpcc;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ConfigurationException;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.config.parser.ConfigurationParser;
import com.sun.xml.rpc.processor.generator.CustomClassGenerator;
import com.sun.xml.rpc.processor.generator.CustomExceptionGenerator;
import com.sun.xml.rpc.processor.generator.EnumerationEncoderGenerator;
import com.sun.xml.rpc.processor.generator.EnumerationGenerator;
import com.sun.xml.rpc.processor.generator.FaultExceptionBuilderGenerator;
import com.sun.xml.rpc.processor.generator.HolderGenerator;
import com.sun.xml.rpc.processor.generator.InterfaceSerializerGenerator;
import com.sun.xml.rpc.processor.generator.LiteralObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.RemoteInterfaceGenerator;
import com.sun.xml.rpc.processor.generator.RemoteInterfaceImplGenerator;
import com.sun.xml.rpc.processor.generator.SOAPFaultSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SOAPObjectBuilderGenerator;
import com.sun.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SerializerRegistryGenerator;
import com.sun.xml.rpc.processor.generator.ServiceGenerator;
import com.sun.xml.rpc.processor.generator.ServiceInterfaceGenerator;
import com.sun.xml.rpc.processor.generator.ServletConfigGenerator;
import com.sun.xml.rpc.processor.generator.StubGenerator;
import com.sun.xml.rpc.processor.generator.TieGenerator;
import com.sun.xml.rpc.processor.generator.WSDLGenerator;
import com.sun.xml.rpc.processor.util.ClientProcessorEnvironment;
import com.sun.xml.rpc.processor.util.ModelWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.XMLModelWriter;
import com.sun.xml.rpc.tools.xrpcc.ActionConstants;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import sun.tools.javac.Main;

public class XrpccCompile
implements ActionConstants,
ProcessorNotificationListener {
    String classPathString;
    File destDir;
    File sourceDir;
    File nonclassDestDir;
    File configFile;
    long tm;
    String modelOutputFilename;
    String modelOutputFilenameXML;
    boolean compilerDebug;
    boolean compilerOptimize;
    boolean nocompile;
    boolean keepGenerated;
    boolean status;
    boolean genInterface;
    boolean genStub;
    boolean genTie;
    boolean genServletConfig;
    boolean genService;
    boolean genServiceInterface;
    boolean noEncodedTypes;
    boolean noMultiRefEncoding;
    boolean noValidation;
    boolean noWarn = false;
    boolean explicitServiceContext;
    boolean genWsdl;
    boolean showModel;
    boolean showModelXML;
    boolean printStackTrace;
    boolean noDataBinding;
    boolean doClient;
    boolean doServer;
    boolean importOnly;
    boolean serializeInterfaces;
    boolean searchSchemaForSubtypes;
    boolean useDataHandlerOnly;
    boolean verbose;
    HashMap actions;
    File actionsFile;
    Localizer localizer;
    String sourcePathArg;
    String serializerNameInfix;
    String program;
    OutputStream out;
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;

    public XrpccCompile(OutputStream out, String program) {
        this.out = out;
        this.program = program;
        this.localizer = new Localizer();
        this.actions = new HashMap();
        this.actions.put("remote.interface.generator", new RemoteInterfaceGenerator());
        this.actions.put("remote.interface.impl.generator", new RemoteInterfaceImplGenerator());
        this.actions.put("custom.class.generator", new CustomClassGenerator());
        this.actions.put("soap.object.serializer.generator", new SOAPObjectSerializerGenerator());
        this.actions.put("interface.serializer.generator", new InterfaceSerializerGenerator());
        this.actions.put("soap.object.builder.generator", new SOAPObjectBuilderGenerator());
        this.actions.put("literal.object.serializer.generator", new LiteralObjectSerializerGenerator());
        this.actions.put("stub.generator", new StubGenerator());
        this.actions.put("tie.generator", new TieGenerator());
        this.actions.put("servlet.config.generator", new ServletConfigGenerator());
        this.actions.put("wsdl.generator", new WSDLGenerator());
        this.actions.put("holder.generator", new HolderGenerator());
        this.actions.put("service.interface.generator", new ServiceInterfaceGenerator());
        this.actions.put("service.generator", new ServiceGenerator());
        this.actions.put("serializer.registry.generator", new SerializerRegistryGenerator());
        this.actions.put("custom.exception.generator", new CustomExceptionGenerator());
        this.actions.put("soap.fault.serializer.generator", new SOAPFaultSerializerGenerator());
        this.actions.put("enumeration.generator", new EnumerationGenerator());
        this.actions.put("enumeration.encoder.generator", new EnumerationEncoderGenerator());
        this.actions.put("fault.exception.builder.generator", new FaultExceptionBuilderGenerator());
    }

    public void output(String msg) {
        PrintStream out = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        out.println(msg);
    }

    public void error(String msg) {
        this.output(XrpccCompile.getText(msg));
    }

    public void error(String msg, String arg1) {
        this.output(XrpccCompile.getText(msg, arg1));
    }

    public void error(String msg, String arg1, String arg2) {
        this.output(XrpccCompile.getText(msg, arg1, arg2));
    }

    public void error(String msg, String arg1, String arg2, String arg3) {
        this.output(XrpccCompile.getText(msg, arg1, arg2, arg3));
    }

    public void usage() {
        this.error("xrpcc.usage", this.program);
    }

    public synchronized boolean compile(String[] argv) {
        if (!this.parseArgs(argv)) {
            return false;
        }
        return this.doCompile();
    }

    public File getDestinationDir() {
        return this.destDir;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parseArgs(String[] argv) {
        this.sourcePathArg = null;
        this.classPathString = null;
        this.destDir = null;
        this.sourceDir = null;
        this.configFile = null;
        this.tm = System.currentTimeMillis();
        this.compilerOptimize = false;
        this.compilerDebug = false;
        this.nocompile = false;
        this.keepGenerated = false;
        this.genStub = false;
        this.genService = false;
        this.genTie = false;
        this.genServletConfig = false;
        this.noEncodedTypes = false;
        this.noMultiRefEncoding = false;
        this.actionsFile = null;
        this.serializerNameInfix = null;
        this.serializeInterfaces = false;
        this.verbose = false;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("")) {
                argv[i] = null;
            } else if (argv[i].equals("-g")) {
                this.compilerDebug = true;
                argv[i] = null;
            } else if (argv[i].equals("-nowarn")) {
                argv[i] = null;
                this.noWarn = true;
            } else if (argv[i].equals("-debug")) {
                this.compilerDebug = true;
                argv[i] = null;
            } else if (argv[i].equals("-verbose")) {
                this.verbose = true;
                argv[i] = null;
            } else {
                if (argv[i].equals("-version")) {
                    this.error("xrpcc.version", "JAX-RPC Reference Implementation", "1.0.1", "R3");
                    return false;
                }
                if (argv[i].equals("-Xnocompile")) {
                    this.nocompile = true;
                    this.keepGenerated = true;
                    argv[i] = null;
                } else if (argv[i].equals("-Xprintstacktrace")) {
                    this.printStackTrace = true;
                    argv[i] = null;
                } else if (argv[i].equals("-Xnodatabinding")) {
                    this.noDataBinding = true;
                    argv[i] = null;
                } else if (argv[i].equals("-Xdatahandleronly")) {
                    this.useDataHandlerOnly = true;
                    argv[i] = null;
                } else if (argv[i].equals("-Xsearchschema")) {
                    this.searchSchemaForSubtypes = true;
                    argv[i] = null;
                } else if (argv[i].equals("-keep") || argv[i].equals("-keepgenerated")) {
                    this.keepGenerated = true;
                    argv[i] = null;
                } else {
                    int index;
                    if (argv[i].equals("-show")) {
                        this.error("xrpcc.option.unsupported", "-show");
                        this.usage();
                        return false;
                    }
                    if (argv[i].equals("-classpath")) {
                        if (i + 1 < argv.length) {
                            if (this.classPathString != null) {
                                this.error("xrpcc.option.already.seen", "-classpath");
                                this.usage();
                                return false;
                            }
                            argv[i] = null;
                            this.classPathString = argv[++i];
                            argv[i] = null;
                        }
                    } else if (argv[i].equals("-d")) {
                        if (i + 1 >= argv.length) {
                            this.error("xrpcc.option.requires.argument", "-d");
                            this.usage();
                            return false;
                        }
                        if (this.destDir != null) {
                            this.error("xrpcc.option.already.seen", "-d");
                            this.usage();
                            return false;
                        }
                        argv[i] = null;
                        this.destDir = new File(argv[++i]);
                        argv[i] = null;
                        if (!this.destDir.exists()) {
                            this.error("xrpcc.no.such.directory", this.destDir.getPath());
                            this.usage();
                            return false;
                        }
                    } else if (argv[i].equals("-s")) {
                        if (i + 1 >= argv.length) {
                            this.error("xrpcc.option.requires.argument", "-s");
                            this.usage();
                            return false;
                        }
                        if (this.sourceDir != null) {
                            this.error("xrpcc.option.already.seen", "-s");
                            this.usage();
                            return false;
                        }
                        argv[i] = null;
                        this.sourceDir = new File(argv[++i]);
                        argv[i] = null;
                        if (!this.sourceDir.exists()) {
                            this.error("xrpcc.no.such.directory", this.sourceDir.getPath());
                            this.usage();
                            return false;
                        }
                    } else if (argv[i].equalsIgnoreCase("-client")) {
                        if (this.doServer) {
                            this.error("xrpcc.option.incompatible", argv[i]);
                            this.usage();
                            return false;
                        }
                        argv[i] = null;
                        this.doClient = true;
                    } else if (argv[i].equalsIgnoreCase("-server")) {
                        if (this.doClient) {
                            this.error("xrpcc.option.incompatible", argv[i]);
                            this.usage();
                            return false;
                        }
                        argv[i] = null;
                        this.doServer = true;
                    } else if (argv[i].equalsIgnoreCase("-both")) {
                        if (this.doClient || this.doServer) {
                            this.error("xrpcc.option.incompatible", argv[i]);
                            this.usage();
                            return false;
                        }
                        argv[i] = null;
                        this.doClient = true;
                        this.doServer = true;
                    } else if (argv[i].equalsIgnoreCase("-Ximport")) {
                        argv[i] = null;
                        this.importOnly = true;
                    } else if (argv[i].startsWith("-Xmodel")) {
                        index = argv[i].indexOf(58);
                        if (index != -1) {
                            this.modelOutputFilename = argv[i].substring(index + 1);
                        }
                        argv[i] = null;
                        this.showModel = true;
                    } else if (argv[i].startsWith("-Xxmodel")) {
                        index = argv[i].indexOf(58);
                        if (index != -1) {
                            this.modelOutputFilenameXML = argv[i].substring(index + 1);
                            this.showModelXML = true;
                        }
                        argv[i] = null;
                    } else if (argv[i].equals("-Xnomultirefs")) {
                        argv[i] = null;
                        this.noMultiRefEncoding = true;
                    } else if (argv[i].equals("-Xnoencodedtypes")) {
                        argv[i] = null;
                        this.noEncodedTypes = true;
                    } else if (argv[i].equals("-Xnovalidation")) {
                        argv[i] = null;
                        this.noValidation = true;
                    } else if (argv[i].equals("-Xexplicitcontext")) {
                        argv[i] = null;
                        this.explicitServiceContext = true;
                    } else if (argv[i].startsWith("-Xactions")) {
                        if (this.actionsFile != null) {
                            this.error("xrpcc.option.already.seen", "-Xactions");
                            this.usage();
                            return false;
                        }
                        index = argv[i].indexOf(58);
                        if (index == -1) {
                            this.error("xrpcc.option.requires.argument", "-Xactions");
                            this.usage();
                            return false;
                        }
                        this.actionsFile = new File(argv[i].substring(index + 1));
                        argv[i] = null;
                        if (!this.actionsFile.exists()) {
                            this.error("xrpcc.no.such.file", this.actionsFile.getPath());
                            this.usage();
                            return false;
                        }
                    } else if (argv[i].startsWith("-Xserializerinfix")) {
                        if (this.serializerNameInfix != null) {
                            this.error("xrpcc.option.already.seen", "-Xserializerinfix");
                            this.usage();
                            return false;
                        }
                        index = argv[i].indexOf(58);
                        if (index == -1) {
                            this.error("xrpcc.option.requires.argument", "-Xserializerinfix");
                            this.usage();
                            return false;
                        }
                        this.serializerNameInfix = argv[i].substring(index + 1);
                        argv[i] = null;
                    } else if (argv[i].startsWith("-Xhttpproxy")) {
                        int index1 = argv[i].indexOf(58);
                        if (index1 == -1) {
                            this.error("xrpcc.option.requires.argument", "-Xhttpproxy");
                            this.usage();
                            return false;
                        }
                        int index2 = argv[i].indexOf(58, index1 + 1);
                        if (index2 == -1) {
                            System.setProperty("proxySet", "true");
                            System.setProperty("proxyHost", argv[i].substring(index1 + 1));
                            System.setProperty("proxyPort", "8080");
                        } else {
                            System.setProperty("proxySet", "true");
                            System.setProperty("proxyHost", argv[i].substring(index1 + 1, index2));
                            System.setProperty("proxyPort", argv[i].substring(index2 + 1));
                        }
                        argv[i] = null;
                    } else if (argv[i].equalsIgnoreCase("-XserializeInterfaces")) {
                        argv[i] = null;
                        this.serializeInterfaces = true;
                    }
                }
            }
            ++i;
        }
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        int i2 = 0;
        while (i2 < argv.length) {
            if (argv[i2] != null) {
                if (argv[i2].startsWith("-")) {
                    this.error("xrpcc.no.such.option", argv[i2]);
                    this.usage();
                    return false;
                }
                if (this.configFile != null) {
                    this.error("xrpcc.only.one.configuration.file", argv[i2]);
                    this.usage();
                    return false;
                }
                this.configFile = new File(argv[i2]);
                argv[i2] = null;
                if (!this.configFile.exists()) {
                    this.error("xrpcc.no.such.file", this.configFile.getPath());
                    this.usage();
                    return false;
                }
            }
            ++i2;
        }
        if (!this.doClient && !this.doServer) {
            this.error("xrpcc.option.mustSpecifyClientOrServer");
            this.usage();
            return false;
        }
        if (this.doClient) {
            this.genStub = true;
            this.genService = true;
            this.genServiceInterface = true;
            this.genInterface = true;
        }
        if (this.doServer) {
            this.genTie = true;
            this.genServletConfig = true;
            this.genWsdl = true;
            this.genInterface = true;
        }
        if (this.importOnly) {
            this.genStub = false;
            this.genTie = false;
            this.genService = false;
            this.genWsdl = false;
            this.genServletConfig = false;
        }
        return true;
    }

    public ProcessorEnvironment getEnv() {
        String cpath = this.classPathString + File.pathSeparator + System.getProperty("java.class.path");
        ClientProcessorEnvironment result = new ClientProcessorEnvironment(System.out, cpath, this);
        int resultFlags = result.getFlags();
        if (!this.noWarn) {
            resultFlags |= 2;
        }
        if (this.verbose) {
            resultFlags |= 1;
        }
        result.setFlags(resultFlags);
        return result;
    }

    public boolean doCompile() {
        ProcessorEnvironment env;
        block44: {
            Properties properties = new Properties();
            env = this.getEnv();
            if (this.sourceDir == null) {
                this.sourceDir = this.destDir;
            }
            if (this.nonclassDestDir == null) {
                this.nonclassDestDir = this.destDir;
            }
            properties.setProperty("sourceDirectory", this.sourceDir.getAbsolutePath());
            properties.setProperty("destinationDirectory", this.destDir.getAbsolutePath());
            properties.setProperty("nonclassDestinationDirectory", this.nonclassDestDir.getAbsolutePath());
            properties.setProperty("encodeTypes", this.noEncodedTypes ? "false" : "true");
            properties.setProperty("multiRefEncoding", this.noMultiRefEncoding ? "false" : "true");
            properties.setProperty("validationWSDL", this.noValidation ? "false" : "true");
            properties.setProperty("explicitServiceContext", this.explicitServiceContext ? "true" : "false");
            properties.setProperty("printStackTrace", this.printStackTrace ? "true" : "false");
            properties.setProperty("noDataBinding", this.noDataBinding ? "true" : "false");
            properties.setProperty("serializerInterfaces", this.serializeInterfaces ? "true" : "false");
            properties.setProperty("useDataHandlerOnly", this.useDataHandlerOnly ? "true" : "false");
            properties.setProperty("searchSchemaForSubtypes", this.searchSchemaForSubtypes ? "true" : "false");
            if (this.serializerNameInfix != null) {
                env.getNames().setSerializerNameInfix(this.serializerNameInfix);
            }
            if (this.configFile == null) {
                this.error("xrpcc.configuration.file.not.found");
                this.usage();
                return false;
            }
            String noMemoryErrorString = XrpccCompile.getText("xrpcc.no.memory");
            String stackOverflowErrorString = XrpccCompile.getText("xrpcc.stack.overflow");
            try {
                ConfigurationParser parser = new ConfigurationParser(env);
                Configuration config = parser.parse(new FileInputStream(this.configFile));
                Processor processor = new Processor(config, properties);
                if (this.actionsFile != null) {
                    Properties props = new Properties();
                    props.load(new FileInputStream(this.actionsFile));
                    Enumeration<?> enumeration = props.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        Class<?> processorClass;
                        String propName = (String)enumeration.nextElement();
                        String className = props.getProperty(propName);
                        try {
                            processorClass = Class.forName(className);
                        }
                        catch (ClassNotFoundException e) {
                            this.error("xrpcc.invalid.processoraction.class", className);
                            return false;
                        }
                        Object processorAction = processorClass.newInstance();
                        if (!(processorAction instanceof ProcessorAction)) {
                            this.error("xrpcc.invalid.processoraction.class", className);
                            return false;
                        }
                        this.output(XrpccCompile.getText("xrpcc.replacing.action.class", this.actions.get(propName.toLowerCase()).getClass().toString(), processorAction.getClass().toString()));
                        this.actions.put(propName.toLowerCase(), processorAction);
                    }
                }
                if (this.importOnly && !(config.getModelInfo() instanceof WSDLModelInfo)) {
                    this.error("xrpcc.option.import.requiresWSDL");
                }
                processor.runModeler();
                if (this.showModel) {
                    if (this.modelOutputFilename == null) {
                        processor.add(new ModelWriter(System.out));
                    } else {
                        File outputFile = new File(this.modelOutputFilename);
                        if (!outputFile.isAbsolute()) {
                            outputFile = new File(this.destDir, this.modelOutputFilename);
                        }
                        processor.add(new ModelWriter(new FileOutputStream(outputFile)));
                    }
                }
                if (this.showModelXML) {
                    File outputFileXML = new File(this.modelOutputFilenameXML);
                    if (!outputFileXML.isAbsolute()) {
                        outputFileXML = new File(this.destDir, this.modelOutputFilenameXML);
                    }
                    processor.add(new XMLModelWriter(outputFileXML));
                }
                if (this.genServiceInterface) {
                    processor.add((ProcessorAction)this.actions.get("service.interface.generator"));
                }
                if (this.genService) {
                    processor.add((ProcessorAction)this.actions.get("service.generator"));
                    processor.add((ProcessorAction)this.actions.get("serializer.registry.generator"));
                }
                if (this.genInterface && !(config.getModelInfo() instanceof RmiModelInfo)) {
                    processor.add((ProcessorAction)this.actions.get("remote.interface.generator"));
                    processor.add((ProcessorAction)this.actions.get("remote.interface.impl.generator"));
                }
                if (this.genStub || this.genTie) {
                    processor.add((ProcessorAction)this.actions.get("enumeration.generator"));
                    processor.add((ProcessorAction)this.actions.get("enumeration.encoder.generator"));
                    processor.add((ProcessorAction)this.actions.get("holder.generator"));
                    processor.add((ProcessorAction)this.actions.get("custom.class.generator"));
                    processor.add((ProcessorAction)this.actions.get("soap.object.serializer.generator"));
                    processor.add((ProcessorAction)this.actions.get("interface.serializer.generator"));
                    processor.add((ProcessorAction)this.actions.get("soap.object.builder.generator"));
                    processor.add((ProcessorAction)this.actions.get("literal.object.serializer.generator"));
                    processor.add((ProcessorAction)this.actions.get("custom.exception.generator"));
                    processor.add((ProcessorAction)this.actions.get("soap.fault.serializer.generator"));
                    processor.add((ProcessorAction)this.actions.get("fault.exception.builder.generator"));
                } else if (this.importOnly) {
                    processor.add((ProcessorAction)this.actions.get("enumeration.generator"));
                    processor.add((ProcessorAction)this.actions.get("holder.generator"));
                    processor.add((ProcessorAction)this.actions.get("custom.class.generator"));
                    processor.add((ProcessorAction)this.actions.get("custom.exception.generator"));
                }
                if (this.genStub) {
                    processor.add((ProcessorAction)this.actions.get("stub.generator"));
                }
                if (this.genTie && !this.genService) {
                    processor.add((ProcessorAction)this.actions.get("serializer.registry.generator"));
                }
                if (this.genTie) {
                    processor.add((ProcessorAction)this.actions.get("tie.generator"));
                }
                if (this.genServletConfig) {
                    processor.add((ProcessorAction)this.actions.get("servlet.config.generator"));
                }
                if (this.genWsdl && !(config.getModelInfo() instanceof WSDLModelInfo)) {
                    processor.add((ProcessorAction)this.actions.get("wsdl.generator"));
                }
                processor.runActions();
                if (!this.nocompile && env.getErrorCount() == 0) {
                    this.compileGeneratedClasses(env);
                }
            }
            catch (ConfigurationException e) {
                this.onError(e);
                return false;
            }
            catch (OutOfMemoryError ee) {
                this.output(noMemoryErrorString);
                return false;
            }
            catch (StackOverflowError ee) {
                if (this.printStackTrace) {
                    env.printStackTrace(ee);
                }
                this.output(stackOverflowErrorString);
                return false;
            }
            catch (Error ee) {
                if (env.getErrorCount() == 0) {
                    env.printStackTrace(ee);
                    this.error("xrpcc.error", ee.getMessage());
                }
            }
            catch (Exception ee) {
                if (env.getErrorCount() != 0) break block44;
                this.output(ee.getMessage());
                env.printStackTrace(ee);
                this.error("xrpcc.error", ee.getMessage());
            }
        }
        boolean status = true;
        if (env.getErrorCount() > 0) {
            String msg = "";
            msg = env.getErrorCount() > 1 ? XrpccCompile.getText("xrpcc.errors", env.getErrorCount()) : XrpccCompile.getText("xrpcc.1error");
            if (env.getWarningCount() > 0) {
                msg = env.getWarningCount() > 1 ? msg + ", " + XrpccCompile.getText("xrpcc.warnings", env.getWarningCount()) : msg + ", " + XrpccCompile.getText("xrpcc.1warning");
            }
            this.output(msg);
            status = false;
        } else if (env.getErrorCount() > 0) {
            if (env.getErrorCount() > 1) {
                this.output(XrpccCompile.getText("xrpcc.warnings", env.getErrorCount()));
            } else {
                this.output(XrpccCompile.getText("xrpcc.1warning"));
            }
        }
        if (!this.keepGenerated) {
            env.deleteGeneratedFiles();
        }
        if (env.verbose()) {
            this.tm = System.currentTimeMillis() - this.tm;
            this.output(XrpccCompile.getText("xrpcc.done_in", Long.toString(this.tm)));
        }
        env.shutdown();
        return status;
    }

    protected String createClasspathString() {
        if (this.classPathString == null) {
            this.classPathString = "";
        }
        return this.classPathString + File.pathSeparator + System.getProperty("java.class.path");
    }

    protected void compileGeneratedClasses(ProcessorEnvironment environment) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        Iterator iter = environment.getGeneratedFiles();
        while (iter.hasNext()) {
            File f = (File)iter.next();
            if (!f.exists() || !f.getName().endsWith(".java")) continue;
            sourceFiles.add(f.getAbsolutePath());
        }
        if (sourceFiles.size() > 0) {
            String classDir = this.destDir.getAbsolutePath();
            String classpathString = this.createClasspathString();
            String[] args = new String[4 + (this.compilerDebug ? 1 : 0) + (this.compilerOptimize ? 1 : 0) + sourceFiles.size()];
            args[0] = "-d";
            args[1] = classDir;
            args[2] = "-classpath";
            args[3] = classpathString;
            int baseIndex = 4;
            if (this.compilerDebug) {
                args[baseIndex++] = "-g";
            }
            if (this.compilerOptimize) {
                args[baseIndex++] = "-O";
            }
            int i = 0;
            while (i < sourceFiles.size()) {
                args[baseIndex + i] = (String)sourceFiles.get(i);
                ++i;
            }
            Main javacMain = new Main(this.out, "wscompile-javac");
            boolean result = javacMain.compile(args);
            if (javacMain.compilationReportedErrors()) {
                this.error("xrpcc.compilationFailed");
            }
        }
    }

    public void onError(Localizable msg) {
        this.output(XrpccCompile.getText("xrpcc.error", this.localizer.localize(msg)));
    }

    public void onWarning(Localizable msg) {
        if (!this.noWarn) {
            this.output(XrpccCompile.getText("xrpcc.warning", this.localizer.localize(msg)));
        }
    }

    public void onInfo(Localizable msg) {
        this.output(XrpccCompile.getText("xrpcc.info", this.localizer.localize(msg)));
    }

    public static String getString(String key) {
        if (!resourcesInitialized) {
            XrpccCompile.initResources();
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("com.sun.xml.rpc.resources.xrpcc");
            resourcesInitialized = true;
        }
        catch (MissingResourceException e) {
            throw new Error("fatal: missing resource bundle: " + e.getClassName());
        }
    }

    public static String getText(String key) {
        String message = XrpccCompile.getString(key);
        if (message == null) {
            message = "no text found: \"" + key + "\"";
        }
        return message;
    }

    public static String getText(String key, int num) {
        return XrpccCompile.getText(key, Integer.toString(num), null, null);
    }

    public static String getText(String key, String arg0) {
        return XrpccCompile.getText(key, arg0, null, null);
    }

    public static String getText(String key, String arg0, String arg1) {
        return XrpccCompile.getText(key, arg0, arg1, null);
    }

    public static String getText(String key, String arg0, String arg1, String arg2) {
        String format = XrpccCompile.getString(key);
        if (format == null) {
            format = "no text found: key = \"" + key + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        Object[] args = new String[]{arg0 != null ? arg0.toString() : "null", arg1 != null ? arg1.toString() : "null", arg2 != null ? arg2.toString() : "null"};
        return MessageFormat.format(format, args);
    }
}

