/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import java.util.HashMap;
import java.util.Map;

public class RmiUtils
implements RmiConstants {
    private static final Map typeClassMap = new HashMap();

    public static String getTypeSig(String typeName) {
        String sig = "";
        int idx = typeName.lastIndexOf("[]");
        if (idx > 0) {
            return "[" + RmiUtils.getTypeSig(typeName.substring(0, idx));
        }
        if (typeName.equals(ModelerConstants.BOOLEAN_CLASSNAME)) {
            return "Z";
        }
        if (typeName.equals(ModelerConstants.BYTE_CLASSNAME)) {
            return "B";
        }
        if (typeName.equals(ModelerConstants.CHAR_CLASSNAME)) {
            return "C";
        }
        if (typeName.equals(ModelerConstants.SHORT_CLASSNAME)) {
            return "S";
        }
        if (typeName.equals(ModelerConstants.INT_CLASSNAME)) {
            return "I";
        }
        if (typeName.equals(ModelerConstants.LONG_CLASSNAME)) {
            return "J";
        }
        if (typeName.equals(ModelerConstants.FLOAT_CLASSNAME)) {
            return "F";
        }
        if (typeName.equals(ModelerConstants.DOUBLE_CLASSNAME)) {
            return "D";
        }
        if (typeName.equals(ModelerConstants.VOID_CLASSNAME)) {
            return "V";
        }
        return "L" + typeName.replace('.', '/') + ";";
    }

    public static String getRealName(String name, ClassLoader loader) throws ClassNotFoundException {
        String tmpName = name;
        if (name.lastIndexOf("[]") > 0) {
            tmpName = RmiUtils.getTypeSig(name).replace('/', '.');
        }
        tmpName = RmiUtils.getLoadableClassName(tmpName, loader);
        return tmpName;
    }

    public static Class getClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> tmpClass = (Class<?>)typeClassMap.get(name);
        if (tmpClass != null) {
            return tmpClass;
        }
        String tmpName = name;
        if (name.lastIndexOf("[]") > 0) {
            tmpName = RmiUtils.getTypeSig(name).replace('/', '.');
        }
        tmpName = RmiUtils.getLoadableClassName(tmpName, classLoader);
        tmpClass = Class.forName(tmpName, true, classLoader);
        return tmpClass;
    }

    public static String getLoadableClassName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> seiClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            int idx = className.lastIndexOf(46);
            if (idx > -1) {
                String tmp = className.substring(0, idx) + "$";
                tmp = tmp + className.substring(idx + 1);
                return RmiUtils.getLoadableClassName(tmp, classLoader);
            }
            throw e;
        }
        return className;
    }

    static {
        typeClassMap.put(ModelerConstants.BOOLEAN_CLASSNAME, Boolean.TYPE);
        typeClassMap.put(ModelerConstants.BYTE_CLASSNAME, Byte.TYPE);
        typeClassMap.put(ModelerConstants.CHAR_CLASSNAME, Character.TYPE);
        typeClassMap.put(ModelerConstants.DOUBLE_CLASSNAME, Double.TYPE);
        typeClassMap.put(ModelerConstants.FLOAT_CLASSNAME, Float.TYPE);
        typeClassMap.put(ModelerConstants.INT_CLASSNAME, Integer.TYPE);
        typeClassMap.put(ModelerConstants.LONG_CLASSNAME, Long.TYPE);
        typeClassMap.put(ModelerConstants.SHORT_CLASSNAME, Short.TYPE);
        typeClassMap.put(ModelerConstants.VOID_CLASSNAME, Void.TYPE);
    }
}

