/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class JavaBean
implements RmiConstants {
    private HashMap members;
    private Class remoteBean;
    ProcessorEnvironment env;

    private static JavaBean forType(ProcessorEnvironment env, RmiType type) {
        JavaBean bean = null;
        try {
            String implClassName = type.getClassName();
            URLClassLoader classLoader = env.getClassLoader();
            Class<?> beanClass = classLoader.loadClass(implClassName);
            bean = new JavaBean(env, beanClass);
            bean.initialize();
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
        return bean;
    }

    public static Map modelTypeSOAP(ProcessorEnvironment env, RmiType type) {
        JavaBean bean = JavaBean.forType(env, type);
        if (bean == null) {
            return null;
        }
        return bean.getMembers();
    }

    private HashMap getMembers() {
        return (HashMap)this.members.clone();
    }

    private JavaBean(ProcessorEnvironment env, Class remoteBean) {
        this.env = env;
        this.remoteBean = remoteBean;
    }

    private void initialize() {
        BeanInfo beanInfo;
        this.members = new HashMap();
        try {
            beanInfo = Introspector.getBeanInfo(this.remoteBean);
        }
        catch (IntrospectionException e) {
            throw new ModelerException("rmimodeler.invalid.rmi.type:", this.remoteBean.getName().toString());
        }
        PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < properties.length) {
            Class<?> propertyType = properties[i].getPropertyType();
            Method readMethod = properties[i].getReadMethod();
            Method writeMethod = properties[i].getWriteMethod();
            if (propertyType != null && readMethod != null && writeMethod != null && readMethod.getParameterTypes().length == 0 && writeMethod.getParameterTypes().length == 1) {
                String propertyName = StringUtils.decapitalize(writeMethod.getName().substring(3));
                RmiType type = RmiType.getRmiType(readMethod.getReturnType());
                if (type == null) {
                    throw new ModelerException("rmimodeler.could.not.resolve.property.type", this.remoteBean.getName() + ":" + propertyName);
                }
                MemberInfo memInfo = new MemberInfo(propertyName, type, false);
                memInfo.setReadMethod(readMethod.getName());
                memInfo.setWriteMethod(writeMethod.getName());
                if (!writeMethod.getDeclaringClass().equals(this.remoteBean)) {
                    memInfo.setDeclaringClass(writeMethod.getDeclaringClass());
                }
                this.members.put(propertyName, memInfo);
            }
            ++i;
        }
    }

    private RmiType findType(Class cDef, String readMethod) {
        RmiType type = null;
        Method[] methods = cDef.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            int modifier = method.getModifiers();
            if (readMethod.equals(method.getName())) {
                type = RmiType.getRmiType(method.getReturnType());
                return type;
            }
            ++i;
        }
        Class superClass = cDef.getSuperclass();
        if (superClass != null && (type = this.findType(superClass, readMethod)) != null) {
            return type;
        }
        Class<?>[] superDefs = cDef.getInterfaces();
        int i2 = 0;
        while (i2 < superDefs.length) {
            type = this.findType(superDefs[i2], readMethod);
            if (type != null) {
                return type;
            }
            ++i2;
        }
        return null;
    }

    private static void log(ProcessorEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[JavaBean: " + msg + "]");
        }
    }
}

