/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;
import javax.xml.namespace.QName;

public abstract class SerializerWriterBase
implements SerializerWriter {
    AbstractType type;

    public SerializerWriterBase(AbstractType type, Names names) {
        this.type = type;
    }

    public void registerSerializer(IndentingWriter p, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        StringBuffer typeName = new StringBuffer(40);
        typeName.append("type");
        this.createSerializer(p, typeName, "serializer", encodeTypes, multiRefEncoding, typeMapping);
        this.writeRegisterFactories(p, typeName.toString(), "serializer", typeMapping);
    }

    public void initializeSerializer(IndentingWriter p, String typeName, String registry) throws IOException {
        p.pln(this.serializerMemberName() + " = (CombinedSerializer)registry.getSerializer(" + this.getEncodingStyleString() + ", " + this.type.getJavaType().getRealName() + ".class, " + typeName + ");");
    }

    public String serializerName() {
        return GeneratorConstants.BASE_SERIALIZER_NAME;
    }

    public String deserializerName() {
        return this.serializerName();
    }

    public static boolean handlesType(AbstractType type) {
        return false;
    }

    protected String getEncodingStyleString() {
        return "SOAPConstants.NS_SOAP_ENCODING";
    }

    protected void declareType(IndentingWriter p, StringBuffer member, QName type, boolean isStatic, boolean isFinal) throws IOException {
        String qnameConstant = GeneratorUtil.getQNameConstant(type);
        if (qnameConstant != null) {
            member.delete(0, member.length());
            member.append(qnameConstant);
        } else {
            String modifier = this.getModifier(isStatic, isFinal);
            p.p(modifier + "QName " + member + " = ");
            GeneratorUtil.writeNewQName(p, type);
            p.pln(";");
        }
    }

    protected void writeRegisterFactories(IndentingWriter p, String typeName, String memberName, String mapping) throws IOException {
        p.pln("registerSerializer(" + mapping + "," + this.type.getJavaType().getRealName() + ".class, " + typeName + ", " + memberName + ");");
    }

    protected String getModifier(boolean isStatic, boolean isFinal) {
        String modifier = "";
        if (isStatic) {
            modifier = modifier + "static ";
        }
        if (isFinal) {
            modifier = modifier + "final ";
        }
        return modifier;
    }

    public abstract String deserializerMemberName();

    public abstract String serializerMemberName();

    public abstract void declareSerializer(IndentingWriter var1, boolean var2, boolean var3) throws IOException;

    public abstract void createSerializer(IndentingWriter var1, StringBuffer var2, String var3, boolean var4, boolean var5, String var6) throws IOException;
}

