/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.StubTieGeneratorBase;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class StubGenerator
extends StubTieGeneratorBase {
    private static final String prefix = "_";

    public StubGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new StubGenerator(model, config, properties);
    }

    private StubGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected String getClassName() {
        return this.env.getNames().stubFor(this.port.getJavaInterface());
    }

    protected String getPrefix() {
        return prefix;
    }

    protected String getStateType() {
        return "StreamingSenderState";
    }

    protected Message getMessageToDeserialize(Operation operation) {
        return operation.getResponse();
    }

    protected String getStateGetRequestResponseString() {
        return "getResponse";
    }

    protected String getInitializeAccess() {
        return "public";
    }

    protected boolean superClassHasInitialize() {
        return true;
    }

    protected void writeImports(IndentingWriter p) throws IOException {
        super.writeImports(p);
        p.pln("import com.sun.xml.rpc.client.SenderException;");
        p.pln("import com.sun.xml.rpc.client.*;");
        p.pln("import com.sun.xml.rpc.client.http.*;");
        p.pln("import javax.xml.rpc.handler.*;");
        p.pln("import javax.xml.rpc.JAXRPCException;");
        p.pln("import javax.xml.rpc.soap.SOAPFaultException;");
    }

    protected void writeClassDecl(IndentingWriter p, String stubClassName) throws IOException {
        JavaInterface javaInterface = this.port.getJavaInterface();
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(stubClassName)).toString());
        p.pln("extends com.sun.xml.rpc.client.StubBase");
        p.p("implements " + javaInterface.getName());
        Iterator remoteInterfaces = javaInterface.getInterfaces();
        if (remoteInterfaces.hasNext()) {
            while (remoteInterfaces.hasNext()) {
                p.p(", ");
                p.p((String)remoteInterfaces.next());
            }
        }
        p.pln(" {");
        p.pln();
    }

    protected void writeConstructor(IndentingWriter p, String stubClassName) throws IOException {
        p.pln("/*");
        p.pln(" *  public constructor");
        p.pln(" */");
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(stubClassName)).append("(HandlerChain handlerChain) {").toString());
        p.pln("super(handlerChain);");
        String address = this.port.getAddress();
        if (address != null && address.length() > 0) {
            p.pln("_setProperty(ENDPOINT_ADDRESS_PROPERTY, \"" + address + "\");");
        }
        p.pOln("}");
    }

    protected void writeRpcOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
        JavaStructureMember javaMember;
        Block paramBlock;
        Parameter parameter;
        JavaParameter javaParameter;
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        this.declareOperationMethod(p, operation);
        Iterator iterator = javaMethod.getParameters();
        int i = 0;
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.isHolder()) {
                p.plnI("if (" + javaParameter.getName() + " == null) {");
                p.pln("throw new IllegalArgumentException(\"" + javaParameter.getName() + " cannot be null\");");
                p.pOln("}");
            }
            ++i;
        }
        p.plnI("try {");
        Message message = operation.getRequest();
        Block block = null;
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block = (Block)iterator.next();
        }
        SOAPType type = (SOAPType)block.getType();
        String objType = type.getJavaType().getRealName();
        String objName = prefix + this.env.getNames().getTypeMemberName(type.getJavaType());
        p.pln();
        QName name = this.port.getName();
        p.pln("StreamingSenderState _state = _start(_handlerChain);");
        p.pln();
        p.pln("InternalSOAPMessage _request = _state.getRequest();");
        p.pln("_request.setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
        p.plnI(objType + " " + objName + " =");
        p.pln("new " + objType + "();");
        p.pO();
        p.pln();
        iterator = message.getParameters();
        boolean declaredHeaderBlockInfo = false;
        while (iterator.hasNext()) {
            String memberName;
            parameter = (Parameter)iterator.next();
            paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() == 1) {
                javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                memberName = parameter.getJavaParameter() != null && parameter.getJavaParameter().isHolder() ? parameter.getName() + ".value" : parameter.getName();
                if (javaMember.isPublic()) {
                    p.pln(objName + "." + javaMember.getName() + " = " + memberName + ";");
                    continue;
                }
                p.pln(objName + "." + javaMember.getWriteMethod() + "(" + memberName + ");");
                continue;
            }
            if (!declaredHeaderBlockInfo) {
                p.pln("SOAPHeaderBlockInfo _headerInfo;");
                declaredHeaderBlockInfo = true;
            }
            javaParameter = parameter.getJavaParameter();
            String qname = this.env.getNames().getBlockQNameName(null, paramBlock);
            memberName = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + ".value" : parameter.getName();
            String serializer = this.writerFactory.createWriter((SOAPType)paramBlock.getType()).serializerMemberName();
            p.pln("_headerInfo = new SOAPHeaderBlockInfo(" + qname + ", null, false);");
            p.pln("_headerInfo.setValue(" + memberName + ");");
            p.pln("_headerInfo.setSerializer(" + serializer + ");");
            p.pln("_request.add(_headerInfo);");
        }
        p.pln();
        p.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block) + ");");
        p.pln("_bodyBlock.setValue(" + objName + ");");
        p.pln("_bodyBlock.setSerializer(" + this.writerFactory.createWriter(type).serializerMemberName() + ");");
        p.pln("_request.setBody(_bodyBlock);");
        p.pln();
        p.pln("_state.getMessageContext().setProperty(HttpClientTransport.HTTP_SOAPACTION_PROPERTY, \"" + operation.getSOAPAction() + "\");");
        p.pln();
        p.pln("_send((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        p.pln();
        message = operation.getResponse();
        iterator = message.getBodyBlocks();
        objName = null;
        objType = null;
        block = null;
        while (iterator.hasNext()) {
            block = (Block)iterator.next();
            if (!block.getName().getLocalPart().equals(this.env.getNames().getResponseName(operation.getName().getLocalPart()))) continue;
            type = (SOAPType)block.getType();
            objType = type.getJavaType().getRealName();
            objName = prefix + this.env.getNames().getTypeMemberName(type.getJavaType());
            break;
        }
        p.pln(objType + " " + objName + " = null;");
        String objMemberName = "_responseObj";
        p.pln("Object " + objMemberName + " = _state.getResponse().getBody().getValue();");
        p.plnI("if (" + objMemberName + " instanceof SOAPDeserializationState) {");
        p.plnI(objName + " =");
        p.pln("(" + objType + ")((SOAPDeserializationState)" + objMemberName + ").getInstance();");
        p.pO();
        p.pOlnI("} else {");
        p.plnI(objName + " =");
        p.pln("(" + objType + ")" + objMemberName + ";");
        p.pO();
        p.pOln("}");
        p.pln();
        iterator = message.getParameters();
        boolean hasReturn = resultType != null && !resultType.getName().equals(ModelerConstants.VOID_CLASSNAME);
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            javaParameter = parameter.getJavaParameter();
            paramBlock = parameter.getBlock();
            if (javaParameter == null || !javaParameter.isHolder() || paramBlock.getLocation() != 1) continue;
            javaMember = StubTieGeneratorBase.getJavaMember(parameter);
            p.plnI(javaParameter.getName() + ".value =");
            if (javaMember.isPublic()) {
                p.pln(objName + "." + javaMember.getName() + ";");
            } else {
                p.pln(objName + "." + javaMember.getReadMethod() + "();");
            }
            p.pO();
        }
        boolean hasResponseHeaders = false;
        iterator = operation.getResponse().getHeaderBlocks();
        hasResponseHeaders = iterator.hasNext();
        iterator = operation.getResponse().getParameters();
        if (hasResponseHeaders && iterator.hasNext()) {
            p.pln("Iterator _headers = _state.getResponse().headers();");
            p.pln("SOAPHeaderBlockInfo _curHeader;");
            p.pln("Object _headerObj;");
            p.plnI("while (_headers.hasNext()) {");
            p.pln("_curHeader = (SOAPHeaderBlockInfo)_headers.next();");
            boolean startedHeaders = false;
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (parameter.getBlock().getLocation() != 2) continue;
                if (startedHeaders) {
                    p.p(" else ");
                }
                startedHeaders = true;
                String paramName = parameter.getName();
                String paramType = parameter.getType().getJavaType().getRealName();
                String qname = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
                String varName = parameter.getType().getJavaType().isHolder() ? paramName + ".value" : paramName;
                p.plnI("if (_curHeader.getName().equals(" + qname + ")) {");
                p.pln("_headerObj = _curHeader.getValue();");
                p.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
                p.pln(paramName + ".value = (" + paramType + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
                p.pOlnI("} else {");
                p.pln(varName + " = (" + paramType + ")_headerObj;");
                p.pOln("}");
                p.pO("}");
            }
            if (startedHeaders) {
                p.pln();
            }
            p.pOln("}");
        }
        if (hasReturn && (parameter = (Parameter)(iterator = message.getParameters()).next()).getBlock() == block) {
            javaMember = StubTieGeneratorBase.getJavaMember(parameter);
            if (javaMember.isPublic()) {
                p.pln("return " + parameter.getName() + ";");
            } else {
                p.pln("return " + objName + "." + javaMember.getReadMethod() + "();");
            }
        }
        p.pO();
        TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
        faultSet.addAll(operation.getFaultsSet());
        Iterator faults = faultSet.iterator();
        this.writeOperationCatchBlock(p, faults);
        p.pOln("}");
    }

    private void declareOperationMethod(IndentingWriter p, Operation operation) throws IOException {
        JavaMethod javaMethod = operation.getJavaMethod();
        String methodName = javaMethod.getName();
        JavaType resultType = javaMethod.getReturnType();
        p.pln("/*");
        p.pln(" *  implementation of " + methodName);
        p.pln(" */");
        p.p("public " + (resultType != null ? resultType.getName() : "void") + " " + methodName + "(");
        Iterator iterator = javaMethod.getParameters();
        int i = 0;
        while (iterator.hasNext()) {
            JavaParameter javaParameter;
            if (i > 0) {
                p.p(", ");
            }
            if ((javaParameter = (JavaParameter)iterator.next()).isHolder()) {
                p.p(this.env.getNames().holderClassName(this.port, javaParameter.getType()) + " " + javaParameter.getName());
            } else {
                p.p(javaParameter.getType().getRealName() + " " + javaParameter.getName());
            }
            ++i;
        }
        p.plnI(")");
        iterator = javaMethod.getExceptions();
        if (iterator.hasNext()) {
            p.p("throws ");
            int i2 = 0;
            while (iterator.hasNext()) {
                if (i2 > 0) {
                    p.p(", ");
                }
                p.p((String)iterator.next());
                ++i2;
            }
            p.p(", ");
        } else {
            p.p("throws ");
        }
        p.p("java.rmi.RemoteException");
        p.pln(" {");
        p.pln();
    }

    private void writeOperationCatchBlock(IndentingWriter p, Iterator faults) throws IOException {
        boolean hasIOException = false;
        if (faults != null) {
            while (faults.hasNext()) {
                Fault fault = (Fault)faults.next();
                if (this.env.getNames().customExceptionClassName(fault).equals(ModelerConstants.IOEXCEPTION_CLASSNAME)) {
                    hasIOException = true;
                    continue;
                }
                p.plnI("} catch (" + this.env.getNames().customExceptionClassName(fault) + " e) {");
                p.pln("throw e;");
                p.pO();
            }
        }
        p.plnI("} catch (RemoteException e) {");
        p.pln("// let this one through unchanged");
        p.pln("throw e;");
        if (hasIOException) {
            p.pOlnI("} catch (java.io.IOException e) {");
            p.pln("throw e;");
        }
        p.pOlnI("} catch (JAXRPCException e) {");
        p.pln("throw new RemoteException(e.getMessage(), e);");
        p.pOlnI("} catch (Exception e) {");
        p.plnI("if (e instanceof RuntimeException) {");
        p.pln("throw (RuntimeException)e;");
        p.pOlnI("} else {");
        p.pln("throw new RemoteException(e.getMessage(), e);");
        p.pOln("}");
        p.pOln("}");
    }

    protected void writeDocumentOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
        JavaStructureMember javaMember;
        String serializer;
        String memberName;
        Block paramBlock;
        Parameter parameter;
        JavaParameter javaParameter;
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        this.declareOperationMethod(p, operation);
        Iterator iterator = javaMethod.getParameters();
        int i = 0;
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.isHolder()) {
                p.plnI("if (" + javaParameter.getName() + " == null) {");
                p.pln("throw new IllegalArgumentException(\"" + javaParameter.getName() + " cannot be null\");");
                p.pOln("}");
            }
            ++i;
        }
        p.plnI("try {");
        Message message = operation.getRequest();
        Block block = null;
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block = (Block)iterator.next();
        }
        p.pln();
        p.pln("StreamingSenderState _state = _start(_handlerChain);");
        p.pln();
        p.pln("InternalSOAPMessage _request = _state.getRequest();");
        p.pln("_request.setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
        p.pln();
        LiteralType type = block == null ? null : (LiteralType)block.getType();
        String objType = type == null ? null : type.getJavaType().getRealName();
        String objName = type == null ? null : prefix + this.env.getNames().getTypeMemberName(type.getJavaType());
        int embeddedParameterCount = 0;
        int nonEmbeddedParameterCount = 0;
        boolean declaredHeaderBlockInfo = false;
        iterator = message.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() == 1) {
                if (parameter.isEmbedded()) {
                    ++embeddedParameterCount;
                    continue;
                }
                objName = parameter.getJavaParameter().getName();
                ++nonEmbeddedParameterCount;
                continue;
            }
            if (!declaredHeaderBlockInfo) {
                p.pln("SOAPHeaderBlockInfo _headerInfo;");
                declaredHeaderBlockInfo = true;
            }
            javaParameter = parameter.getJavaParameter();
            String qname = this.env.getNames().getBlockQNameName(null, paramBlock);
            memberName = parameter.getName();
            serializer = this.writerFactory.createWriter((LiteralType)paramBlock.getType()).serializerMemberName();
            p.pln("_headerInfo = new SOAPHeaderBlockInfo(" + qname + ", null, false);");
            p.pln("_headerInfo.setValue(" + memberName + ");");
            p.pln("_headerInfo.setSerializer(" + serializer + ");");
            p.pln("_request.add(_headerInfo);");
        }
        if (nonEmbeddedParameterCount > 1 || nonEmbeddedParameterCount > 0 && embeddedParameterCount > 0) {
            throw new GeneratorException("generator.internal.error.should.not.happen", "stub.generator.002");
        }
        if ((embeddedParameterCount > 0 || embeddedParameterCount == 0 && nonEmbeddedParameterCount == 0) && objName != null && objType != null) {
            p.pln(objType + " " + objName + " = new " + objType + "();");
        }
        iterator = message.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() != 1 || !parameter.isEmbedded()) continue;
            javaMember = StubTieGeneratorBase.getJavaMember(parameter);
            if (parameter.getJavaParameter() == null) continue;
            memberName = parameter.getName();
            if (javaMember.isPublic()) {
                p.pln(objName + "." + javaMember.getName() + " = " + memberName + ";");
                continue;
            }
            p.pln(objName + "." + javaMember.getWriteMethod() + "(" + memberName + ");");
        }
        p.pln();
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            paramBlock = (Block)iterator.next();
            p.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block) + ");");
            p.pln("_bodyBlock.setValue(" + objName + ");");
            serializer = this.writerFactory.createWriter((LiteralType)paramBlock.getType()).serializerMemberName();
            p.pln("_bodyBlock.setSerializer(" + serializer + ");");
            p.pln("_request.setBody(_bodyBlock);");
            p.pln();
        } else {
            p.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(null);");
            p.pln("_bodyBlock.setSerializer(DummySerializer.getInstance());");
            p.pln("_request.setBody(_bodyBlock);");
            p.pln();
        }
        p.pln("_state.getMessageContext().setProperty(HttpClientTransport.HTTP_SOAPACTION_PROPERTY, \"" + operation.getSOAPAction() + "\");");
        p.pln();
        p.pln("_send((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        p.pln();
        message = operation.getResponse();
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block = (Block)iterator.next();
        }
        type = block == null ? null : (LiteralType)block.getType();
        boolean hasResponseHeaders = false;
        iterator = operation.getResponse().getHeaderBlocks();
        hasResponseHeaders = iterator.hasNext();
        iterator = operation.getResponse().getParameters();
        if (hasResponseHeaders && iterator.hasNext()) {
            p.pln("Iterator _headers = _state.getResponse().headers();");
            p.pln("SOAPHeaderBlockInfo _curHeader;");
            p.pln("Object _headerObj;");
            p.plnI("while (_headers.hasNext()) {");
            p.pln("_curHeader = (SOAPHeaderBlockInfo)_headers.next();");
            boolean startedHeaders = false;
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (parameter.getBlock().getLocation() != 2) continue;
                if (startedHeaders) {
                    p.p(" else ");
                }
                startedHeaders = true;
                String paramName = parameter.getName();
                String paramType = parameter.getType().getJavaType().getRealName();
                String qname = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
                String varName = parameter.getType().getJavaType().isHolder() ? paramName + ".value" : paramName;
                p.plnI("if (_curHeader.getName().equals(" + qname + ")) {");
                p.pln("_headerObj = _curHeader.getValue();");
                p.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
                p.pln(paramName + ".value = (" + paramType + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
                p.pOlnI("} else {");
                p.pln(varName + " = (" + paramType + ")_headerObj;");
                p.pOln("}");
                p.pO("}");
            }
            if (startedHeaders) {
                p.pln();
            }
            p.pOln("}");
        }
        if ((iterator = message.getParameters()).hasNext()) {
            parameter = (Parameter)iterator.next();
            if (parameter.isEmbedded()) {
                objName = "_result";
                objType = type.getJavaType().getRealName();
            } else {
                objName = "_result";
                objType = parameter.getType().getJavaType().getRealName();
            }
            p.pln(objType + " " + objName + " = null;");
            p.pln("Object _responseObj = _state.getResponse().getBody().getValue();");
            p.plnI("if (_responseObj instanceof SOAPDeserializationState) {");
            p.p(objName + " =");
            p.pln("(" + objType + ")((SOAPDeserializationState) _responseObj).getInstance();");
            p.pOlnI("} else {");
            p.p(objName + " =");
            p.pln("(" + objType + ") _responseObj;");
            p.pOln("}");
            p.pln();
            if (parameter.isEmbedded()) {
                javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                if (javaMember.isPublic()) {
                    p.pln("return " + objName + "." + parameter.getName() + ";");
                } else {
                    p.pln("return " + objName + "." + javaMember.getReadMethod() + "();");
                }
            } else {
                p.pln("return " + objName + ";");
            }
        }
        p.pln();
        p.pO();
        this.writeOperationCatchBlock(p, null);
        p.pOln("}");
    }

    protected void writeReadBodyFaultElement(IndentingWriter p) throws IOException {
        Operation operation;
        boolean hasFaults = false;
        Iterator operationsIter = this.operations.iterator();
        while (!hasFaults && operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            hasFaults = operation.getFaults().hasNext();
        }
        if (!hasFaults) {
            return;
        }
        p.pln("/*");
        p.pln(" *  this method deserializes fault responses");
        p.pln(" */");
        p.plnI("protected Object _readBodyFaultElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {");
        p.pln("Object faultInfo = null;");
        p.pln("int opcode = state.getRequest().getOperationCode();");
        p.plnI("switch (opcode) {");
        operationsIter = this.operations.iterator();
        while (operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            if (!operation.getFaults().hasNext()) continue;
            p.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            p.pln("faultInfo = " + this.env.getNames().getClassMemberName(this.env.getNames().faultSerializerClassName(this.port, operation)) + ".deserialize(null, bodyReader, deserializationContext);");
            p.pln("break;");
            p.pO();
        }
        p.plnI("default:");
        p.pln("return super._readBodyFaultElement(bodyReader, deserializationContext, state);");
        p.pO();
        p.pOln("}");
        p.pln("return faultInfo;");
        p.pOln("}");
    }

    protected void writeReadFirstBodyElementDefault(IndentingWriter p, String opCode) throws IOException {
        p.pln("throw new SenderException(\"sender.response.unrecognizedOperation\", Integer.toString(" + opCode + "));");
    }

    protected void writeHandleEmptyBody(IndentingWriter p, Operation operation) throws IOException {
        p.pln("/*");
        p.pln(" * This method handles the case of an empty SOAP body.");
        p.pln(" */");
        p.plnI("protected void _handleEmptyBody(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {");
        p.pOln("}");
    }

    public void writeGenericMethods(IndentingWriter p) throws IOException {
        p.pln();
        p.plnI("public String _getEncodingStyle() {");
        p.pln("return SOAPNamespaceConstants.ENCODING;");
        p.pOln("}");
        p.pln();
        p.plnI("public void _setEncodingStyle(String encodingStyle) {");
        p.pln("throw new UnsupportedOperationException(\"cannot set encoding style\");");
        p.pOln("}");
    }

    protected void writeUnderstoodHeadersMember(IndentingWriter p, Map headerMap) throws IOException {
        p.p("private static final QName[] understoodHeaderNames = new QName[] { ");
        boolean first = true;
        Iterator operationsIter = this.operations.iterator();
        int i = 0;
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            Iterator blocks = operation.getResponse().getHeaderBlocks();
            while (blocks.hasNext()) {
                Block block = (Block)blocks.next();
                String qname = this.env.getNames().getBlockQNameName(operation, block);
                if (!first) {
                    p.p(", ");
                }
                p.p(qname);
                first = false;
            }
            ++i;
        }
        p.pln(" };");
    }
}

