/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.writer.SOAPObjectSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class InterfaceSerializerGenerator
extends GeneratorBase {
    private Set visitedTypes;
    private static final String OBJECT_SERIALIZER_BASE = "ObjectSerializerBase";
    private static final String INTERFACE_SERIALIZER_BASE = "InterfaceSerializerBase";

    public InterfaceSerializerGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new InterfaceSerializerGenerator(model, config, properties);
    }

    private InterfaceSerializerGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.visitedTypes = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        Iterator types = model.getExtraTypes();
        while (types.hasNext()) {
            AbstractType type = (AbstractType)types.next();
            if (!type.isSOAPType()) continue;
            ((SOAPType)type).accept(this);
        }
        this.visitedTypes = null;
    }

    protected void preVisitFault(Fault fault) throws Exception {
        if (fault.getBlock().getType().isSOAPType()) {
            ((SOAPType)fault.getBlock().getType()).accept(this);
        }
    }

    protected void preVisitSOAPSimpleType(SOAPSimpleType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitSOAPAnyType(SOAPAnyType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    protected void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        try {
            this.writeObjectSerializerForType(type);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", type.getName().getLocalPart());
        }
    }

    private boolean haveVisited(SOAPType type) {
        return this.visitedTypes.contains(type);
    }

    private void typeVisited(SOAPType type) {
        this.visitedTypes.add(type);
    }

    private void writeObjectSerializerForType(SOAPStructureType type) throws IOException {
        boolean isInterface;
        boolean bl = isInterface = ((JavaStructureType)type.getJavaType()).getAllSubclasses() != null;
        if (!isInterface) {
            return;
        }
        JavaType javaType = type.getJavaType();
        String className = this.env.getNames().typeInterfaceSerializerClassName(type);
        File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
        try {
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writeObjectSerializerCode(out, type);
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", classFile.toString());
        }
    }

    private void writeObjectSerializerCode(IndentingWriter p, SOAPStructureType type) throws IOException {
        this.log("writing  serializer/deserializer for: " + type.getName().getLocalPart());
        String className = this.env.getNames().typeInterfaceSerializerClassName(type);
        GeneratorBase.writePackage(p, className);
        this.writeImports(p);
        p.pln();
        this.writeClassDecl(p, className);
        this.writeMembers(p, type);
        p.pln();
        this.writeConstructor(p, className);
        p.pln();
        this.writeInitialize(p, type);
        p.pln();
        this.writeDoDeserializeMethod(p, type);
        p.pln();
        this.writeDoSerializeInstanceMethod(p, type);
        if (type instanceof RPCResponseStructureType) {
            this.writeVerifyNameOverrideMethod(p, type);
        }
        p.pOln("}");
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.literal.DetailFragmentDeserializer;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        p.pln("import com.sun.xml.rpc.streaming.*;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        String baseClass = INTERFACE_SERIALIZER_BASE;
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(className)).append(" extends ").append(baseClass).append(" implements Initializable {").toString());
    }

    private void writeMembers(IndentingWriter p, SOAPStructureType type) throws IOException {
        HashSet processedTypes = new HashSet();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        TreeSet subclassSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        subclassSet.addAll(javaStructure.getAllSubclassesSet());
        Iterator iterator = subclassSet.iterator();
        while (iterator != null && iterator.hasNext()) {
            SOAPEncoding.writeStaticSerializer(p, (SOAPType)((JavaStructureType)iterator.next()).getOwner(), processedTypes, this.writerFactory, this.env.getNames());
        }
        SOAPObjectSerializerWriter writer = new SOAPObjectSerializerWriter(type, this.env.getNames());
        p.pln("private CombinedSerializer " + writer.serializerMemberName() + ";");
    }

    private void writeConstructor(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(className)).append("(QName type, boolean encodeType, ").append("boolean isNullable, String encodingStyle) {").toString());
        p.pln("super(type, encodeType, isNullable, encodingStyle);");
        p.pOln("}");
    }

    private void writeInitialize(IndentingWriter p, SOAPStructureType type) throws IOException {
        SerializerWriter writer;
        p.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        HashSet processedTypes = new HashSet();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        TreeSet subclassSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        subclassSet.addAll(javaStructure.getAllSubclassesSet());
        Iterator iterator = subclassSet.iterator();
        while (iterator != null && iterator.hasNext()) {
            SOAPType soapType = (SOAPType)((JavaStructureType)iterator.next()).getOwner();
            writer = this.writerFactory.createWriter(soapType);
            writer.initializeSerializer(p, this.env.getNames().getTypeQName(soapType.getName()), "registry");
            p.pln(writer.serializerMemberName() + " = " + writer.serializerMemberName() + ".getInnermostSerializer();");
        }
        writer = new SOAPObjectSerializerWriter(type, this.env.getNames());
        StringBuffer typeName = new StringBuffer(40);
        typeName.append("type");
        writer.createSerializer(p, typeName, "interfaceSerializer", this.encodeTypes, false, null);
        p.pln(writer.serializerMemberName() + " = interfaceSerializer.getInnermostSerializer();");
        p.plnI("if (" + writer.serializerMemberName() + " instanceof Initializable) {");
        p.pln("((Initializable)" + writer.serializerMemberName() + ").initialize(registry);");
        p.pOln("}");
        p.pOln("}");
    }

    private void writeDoDeserializeMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        String serializer;
        SerializerWriter writer;
        p.plnI("public Object doDeserialize(QName name, XMLReader reader,");
        p.pln("SOAPDeserializationContext context) throws Exception {");
        JavaStructureType javaType = (JavaStructureType)type.getJavaType();
        TreeSet subclassSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        subclassSet.addAll(javaType.getAllSubclassesSet());
        Iterator subclasses = subclassSet.iterator();
        p.pln("QName elementType = getType(reader);");
        int i = 0;
        while (subclasses != null && subclasses.hasNext()) {
            JavaStructureType subclass = (JavaStructureType)subclasses.next();
            SOAPStructureType soapType = (SOAPStructureType)subclass.getOwner();
            writer = this.writerFactory.createWriter(soapType);
            serializer = writer.deserializerMemberName();
            if (i > 0) {
                p.p(" else ");
            }
            p.plnI("if (elementType.equals(" + serializer + ".getXmlType())) {");
            p.pln("return " + serializer + ".deserialize(name, reader, context);");
            p.pO("}");
            ++i;
        }
        if (i > 0) {
            p.p(" else ");
        }
        writer = new SOAPObjectSerializerWriter(type, this.env.getNames());
        serializer = writer.deserializerMemberName();
        p.plnI("if (elementType.equals(" + serializer + ".getXmlType())) {");
        p.pln("return " + serializer + ".deserialize(name, reader, context);");
        p.pO("}");
        p.pln();
        p.pln("throw new DeserializationException(\"soap.unexpectedElementType\", new Object[] {\"\", elementType.toString()});");
        p.pOln("}");
    }

    private void writeDoSerializeInstanceMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        String serializer;
        SerializerWriter writer;
        p.plnI("public void doSerializeInstance(Object obj, QName name, SerializerCallback callback,");
        p.pln("XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        p.pln(type.getJavaType().getRealName() + " instance = (" + type.getJavaType().getRealName() + ")obj;");
        p.pln();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        TreeSet subclassSet = new TreeSet(new GeneratorUtil.SubclassComparator());
        subclassSet.addAll(javaStructure.getAllSubclassesSet());
        Iterator subclasses = subclassSet.iterator();
        Iterator iterator = javaStructure.getMembers();
        if (subclasses != null) {
            int i = 0;
            while (subclasses.hasNext()) {
                JavaStructureType subclass = (JavaStructureType)subclasses.next();
                SOAPStructureType soapType = (SOAPStructureType)subclass.getOwner();
                writer = this.writerFactory.createWriter(soapType);
                serializer = writer.deserializerMemberName();
                if (i > 0) {
                    p.p(" else ");
                }
                p.plnI("if (obj instanceof " + subclass.getRealName() + ") {");
                p.pln(serializer + ".serialize(obj, name, callback, writer, context);");
                p.pO("}");
                ++i;
            }
            p.plnI(" else {");
        }
        writer = new SOAPObjectSerializerWriter(type, this.env.getNames());
        serializer = writer.deserializerMemberName();
        p.pln(serializer + ".serialize(obj, name, callback, writer, context);");
        p.pOln("}");
        p.pOln("}");
    }

    private void writeVerifyNameOverrideMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        p.plnI("protected void verifyName(XMLReader reader, QName expectedName) throws Exception {");
        p.pOln("}");
    }
}

