/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectSerializerBase;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.soap.SOAPRequestSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPResponseStructure;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class SOAPResponseSerializer
extends SOAPRequestSerializer
implements Initializable {
    private static final QName RETURN_VALUE_QNAME = new QName("return");
    private static final QName[] EMPTY_QNAME_ARRAY = new QName[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    protected QName returnXmlType;
    protected Class returnClass;
    protected JAXRPCSerializer returnSerializer;
    protected JAXRPCDeserializer returnDeserializer;

    public SOAPResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnClass) {
        super(type, encodeType, isNullable, encodingStyle, parameterNames, parameterXmlTypes, parameterClasses);
        this.returnXmlType = returnXmlType;
        this.returnClass = returnClass;
    }

    public SOAPResponseSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName returnXmlType, Class returnClass) {
        this(type, encodeType, isNullable, encodingStyle, EMPTY_QNAME_ARRAY, EMPTY_QNAME_ARRAY, EMPTY_CLASS_ARRAY, returnXmlType, returnClass);
    }

    public SOAPResponseSerializer(QName type, QName[] parameterNames, QName[] parameterXmlTypes, Class[] parameterClasses, QName returnXmlType, Class returnClass) {
        this(type, false, true, "http://schemas.xmlsoap.org/soap/encoding/", parameterNames, parameterXmlTypes, parameterClasses, returnXmlType, returnClass);
    }

    public SOAPResponseSerializer(QName type, QName returnXmlType, Class returnClass) {
        this(type, EMPTY_QNAME_ARRAY, EMPTY_QNAME_ARRAY, EMPTY_CLASS_ARRAY, returnXmlType, returnClass);
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        if (this.typeRegistry != null) {
            return;
        }
        super.initialize(registry);
        if (this.returnClass != null || this.returnXmlType != null) {
            this.returnSerializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, this.returnClass, this.returnXmlType);
            this.returnDeserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, this.returnClass, this.returnXmlType);
        }
    }

    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    protected Object doDeserialize(SOAPDeserializationState existingState, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Object returnedObject;
        SOAPResponseStructure instance = new SOAPResponseStructure();
        SOAPResponseStructureBuilder builder = null;
        boolean isComplete = true;
        SOAPDeserializationState state = existingState;
        reader.nextElementContent();
        int responseMemberIndex = 0;
        JAXRPCDeserializer returnDeserializer = this.getReturnDeserializer(reader);
        if (returnDeserializer != null) {
            returnedObject = returnDeserializer.deserialize(null, reader, context);
            if (returnedObject instanceof SOAPDeserializationState) {
                if (builder == null) {
                    builder = new SOAPResponseStructureBuilder(instance);
                }
                state = ObjectSerializerBase.registerWithMemberState(instance, state, returnedObject, responseMemberIndex, builder);
                isComplete = false;
            } else {
                instance.returnValue = returnedObject;
            }
            if (this.parameterTypes.length > 0) {
                reader.nextElementContent();
            }
        }
        int i = 0;
        while (i < this.parameterTypes.length) {
            QName parameterName = this.parameterNames[i];
            if (reader.getName().equals(parameterName)) {
                returnedObject = this.getParameterDeserializer(i, reader).deserialize(parameterName, reader, context);
                if (returnedObject instanceof SOAPDeserializationState) {
                    if (builder == null) {
                        builder = new SOAPResponseStructureBuilder(instance);
                    }
                    responseMemberIndex = i + 1;
                    builder.setOutParameterName(responseMemberIndex, parameterName);
                    state = ObjectSerializerBase.registerWithMemberState(instance, state, returnedObject, responseMemberIndex, builder);
                    isComplete = false;
                } else {
                    instance.outParameters.put(parameterName, returnedObject);
                }
            } else {
                throw new DeserializationException("soap.unexpectedElementName", new Object[]{parameterName, reader.getName()});
            }
            ++i;
        }
        reader.nextElementContent();
        return isComplete ? instance : state;
    }

    protected JAXRPCSerializer getReturnSerializer(Object returnValue) throws Exception {
        JAXRPCSerializer serializer = this.returnSerializer;
        if (serializer == null) {
            serializer = (JAXRPCSerializer)this.typeRegistry.getSerializer(this.encodingStyle, returnValue.getClass(), this.returnXmlType);
        }
        return serializer;
    }

    protected JAXRPCDeserializer getReturnDeserializer(XMLReader reader) throws Exception {
        JAXRPCDeserializer deserializer = this.returnDeserializer;
        if (deserializer == null && (this.returnXmlType != null || this.returnClass != null)) {
            deserializer = (JAXRPCDeserializer)this.typeRegistry.getDeserializer(this.encodingStyle, this.returnClass, this.returnXmlType);
        }
        return deserializer;
    }

    protected static class SOAPResponseStructureBuilder
    implements SOAPInstanceBuilder {
        SOAPResponseStructure instance = null;
        List outParameterNames = new ArrayList();

        public void setOutParameterName(int index, QName name) {
            this.outParameterNames.set(index, name);
        }

        SOAPResponseStructureBuilder(SOAPResponseStructure instance) {
            this.instance = instance;
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int index, Object memberValue) {
            try {
                if (index == 0) {
                    this.instance.returnValue = memberValue;
                } else {
                    this.instance.outParameters.put(this.outParameterNames.get(index), memberValue);
                }
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object instance) {
            instance = (SOAPResponseStructure)instance;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

