/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeConstants;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.xml.namespace.QName;

public class LiteralSimpleTypeSerializer
extends SerializerBase
implements SimpleTypeConstants {
    protected SimpleTypeEncoder encoder;

    public LiteralSimpleTypeSerializer(QName type, String encodingStyle, SimpleTypeEncoder encoder) {
        super(type, false, true, encodingStyle);
        this.encoder = encoder;
    }

    public void serialize(Object obj, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) throws SerializationException {
        boolean pushedEncodingStyle = false;
        try {
            try {
                writer.startElement(name != null ? name : this.type);
                if (callback != null) {
                    callback.onStartTag(obj, name, writer, context);
                }
                pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
                if (obj == null) {
                    if (!this.isNullable) {
                        throw new SerializationException("xsd.unexpectedNull");
                    }
                    writer.writeAttributeUnquoted(SimpleTypeConstants.QNAME_XSI_NIL, "1");
                } else {
                    this.encoder.writeAdditionalNamespaceDeclarations(obj, writer);
                    this.encoder.writeValue(obj, writer);
                }
                writer.endElement();
            }
            catch (JAXRPCExceptionBase e) {
                throw new SerializationException(e);
            }
            catch (Exception e) {
                throw new SerializationException(new LocalizableExceptionAdapter(e));
            }
            Object var10_7 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) throws DeserializationException {
        boolean pushedEncodingStyle = false;
        try {
            Object object;
            try {
                QName actualName;
                pushedEncodingStyle = context.processEncodingStyle(reader);
                context.verifyEncodingStyle(this.encodingStyle);
                if (name != null && !(actualName = reader.getName()).equals(name)) {
                    throw new DeserializationException("xsd.unexpectedElementName", new Object[]{name.toString(), actualName.toString()});
                }
                Attributes attrs = reader.getAttributes();
                String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
                boolean isNull = nullVal != null && (nullVal.equals("true") || nullVal.equals("1"));
                reader.next();
                Object obj = null;
                if (isNull) {
                    if (!this.isNullable) {
                        throw new DeserializationException("xsd.unexpectedNull");
                    }
                } else {
                    String val = null;
                    switch (reader.getState()) {
                        case 3: {
                            val = reader.getValue();
                            reader.next();
                            break;
                        }
                        case 2: {
                            val = "";
                        }
                    }
                    obj = this.encoder.stringToObject(val, reader);
                }
                XMLReaderUtil.verifyReaderState(reader, 2);
                object = obj;
                Object var11_12 = null;
                if (!pushedEncodingStyle) return object;
            }
            catch (JAXRPCExceptionBase e) {
                throw new DeserializationException(e);
            }
            catch (Exception e) {
                throw new DeserializationException(new LocalizableExceptionAdapter(e));
            }
            context.popEncodingStyle();
            return object;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!pushedEncodingStyle) throw throwable;
            context.popEncodingStyle();
            throw throwable;
        }
    }
}

