/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

public class OperationInfo {
    String namespace;
    String localName;
    QName qualifiedName;
    ArrayList parameterNames;
    ArrayList parameterXmlTypes;
    ArrayList parameterJavaTypes;
    ArrayList parameterModes;
    String endPointAddress;
    QName returnXmlType;
    Class returnJavaType;
    Map properties;
    boolean isDocumentOperationFlag;

    public OperationInfo(String localName) {
        this.init();
        this.localName = localName;
    }

    protected void init() {
        this.namespace = "";
        this.localName = "";
        this.qualifiedName = null;
        this.parameterNames = new ArrayList();
        this.parameterXmlTypes = new ArrayList();
        this.parameterJavaTypes = new ArrayList();
        this.parameterModes = new ArrayList();
        this.endPointAddress = "";
        this.returnXmlType = null;
        this.returnJavaType = null;
        this.properties = new HashMap();
        this.isDocumentOperationFlag = false;
        this.setProperty("javax.xml.rpc.soap.operation.style", "rpc");
        this.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", "http://schemas.xmlsoap.org/soap/encoding/");
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.qualifiedName = null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public QName getName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = new QName(this.namespace, this.localName);
        }
        return this.qualifiedName;
    }

    public void addParameter(String parameterName, QName parameterXmlType) {
        this.addParameter(parameterName, parameterXmlType, null, ParameterMode.IN);
    }

    public void addParameter(String parameterName, QName parameterXmlType, Class javaType, ParameterMode mode) {
        this.parameterNames.add(parameterName);
        this.parameterXmlTypes.add(parameterXmlType);
        this.parameterJavaTypes.add(javaType);
        this.parameterModes.add(mode);
    }

    public void setReturnType(QName returnXmlType) {
        this.setReturnType(returnXmlType, null);
    }

    public void setReturnType(QName returnXmlType, Class returnJavaType) {
        this.returnXmlType = returnXmlType;
        this.returnJavaType = returnJavaType;
    }

    public QName getReturnXmlType() {
        return this.returnXmlType;
    }

    public String[] getParameterNames() {
        return this.parameterNames.toArray(new String[this.parameterNames.size()]);
    }

    public int getParameterCount() {
        return this.parameterNames.size();
    }

    public QName[] getParameterXmlTypes() {
        return this.parameterXmlTypes.toArray(new QName[this.parameterXmlTypes.size()]);
    }

    public ParameterMode[] getParameterModes() {
        return this.parameterModes.toArray(new ParameterMode[this.parameterModes.size()]);
    }

    public void setEndPointAddress(String address) {
        this.endPointAddress = address;
    }

    public String getEndPointAddress() {
        return this.endPointAddress;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Iterator getPropertyKeys() {
        return this.properties.keySet().iterator();
    }

    public void beDocumentOperation() {
        this.isDocumentOperationFlag = true;
    }

    public boolean isDocumentOperation() {
        return this.isDocumentOperationFlag;
    }
}

