/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.dom4j;

import com.sun.xml.messaging.saaj.soap.dom4j.BodyName;
import com.sun.xml.messaging.saaj.soap.dom4j.DetailName;
import com.sun.xml.messaging.saaj.soap.dom4j.ElementFactory;
import com.sun.xml.messaging.saaj.soap.dom4j.EnvelopeName;
import com.sun.xml.messaging.saaj.soap.dom4j.FaultName;
import com.sun.xml.messaging.saaj.soap.dom4j.HeaderName;
import javax.xml.soap.Name;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class NameImpl
extends QName
implements Name {
    public static final Namespace soapNamespace = Namespace.get((String)"soap-env", (String)"http://schemas.xmlsoap.org/soap/envelope/");

    protected NameImpl(String name) {
        super(name);
        this.setDocumentFactory(ElementFactory.getInstance());
    }

    protected NameImpl(String name, Namespace namespace) {
        super(name, namespace);
        this.setDocumentFactory(ElementFactory.getInstance());
    }

    public static NameImpl create(String name) {
        return new NameImpl(name);
    }

    public static NameImpl create(String name, String prefix, String uri) {
        Namespace ns = Namespace.get((String)prefix, (String)uri);
        return NameImpl.create(name, ns);
    }

    public static NameImpl create(String name, Namespace ns) {
        if (ns != null) {
            if (ns.equals((Object)soapNamespace)) {
                if (name.equalsIgnoreCase("Envelope")) {
                    return NameImpl.createEnvelopeName();
                }
                if (name.equalsIgnoreCase("Header")) {
                    return NameImpl.createHeaderName();
                }
                if (name.equalsIgnoreCase("Body")) {
                    return NameImpl.createBodyName();
                }
                if (name.equalsIgnoreCase("Fault")) {
                    return NameImpl.createFaultName();
                }
            }
            return new NameImpl(name, ns);
        }
        return NameImpl.create(name);
    }

    public static NameImpl create(String name, Namespace ns, String qualifiedName) {
        return NameImpl.create(name, ns);
    }

    public String getLocalName() {
        return this.getName();
    }

    public String getPrefix() {
        return this.getNamespacePrefix();
    }

    public String getURI() {
        return this.getNamespaceURI();
    }

    public static NameImpl createEnvelopeName() {
        return new EnvelopeName();
    }

    public static NameImpl createHeaderName() {
        return new HeaderName();
    }

    public static NameImpl createBodyName() {
        return new BodyName();
    }

    public static NameImpl createFaultName() {
        return new FaultName();
    }

    public static NameImpl createDetailName() {
        return new DetailName();
    }
}

