/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.client.p2p.http.handler;

import com.sun.xml.messaging.saaj.client.p2p.http.handler.AuthenticationInfo;
import com.sun.xml.messaging.saaj.client.p2p.http.handler.BasicAuthentication;
import com.sun.xml.messaging.saaj.client.p2p.http.handler.DigestAuthentication;
import com.sun.xml.messaging.saaj.client.p2p.http.handler.EmptyInputStream;
import com.sun.xml.messaging.saaj.client.p2p.http.handler.Handler;
import com.sun.xml.messaging.saaj.client.p2p.http.handler.HttpAuthenticator;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    static final String version = AccessController.doPrivileged(new GetPropertyAction("java.version"));
    public static final String userAgent = AccessController.doPrivileged(new GetPropertyAction("http.agent", "Java" + version));
    static final String httpVersion = "HTTP/1.1";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    static final int maxRedirects = 5;
    protected HttpClient http;
    protected Handler handler;
    protected PrintStream ps = null;
    private static HttpAuthenticator defaultAuth;
    private MessageHeader requests = new MessageHeader();
    protected ProgressEntry pe;
    private MessageHeader responses = new MessageHeader();
    private InputStream inputStream = null;
    private ByteArrayOutputStream poster = null;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    private Exception rememberedException = null;
    static /* synthetic */ Class class$sun$net$www$MessageHeader;
    static /* synthetic */ Class class$sun$net$www$http$HttpClient;
    static /* synthetic */ Class class$java$io$ByteArrayOutputStream;

    private static PasswordAuthentication privilegedRequestPasswordAuthentication(final InetAddress addr, final int port, final String protocol, final String prompt, final String scheme) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Authenticator.requestPasswordAuthentication(addr, port, protocol, prompt, scheme);
            }
        });
    }

    private void checkMessageHeader(String key, String value) {
        int LF = 10;
        int index = key.indexOf(LF);
        if (index != -1) {
            throw new IllegalArgumentException("Illegal character(s) in message header field: " + key);
        }
        index = value.indexOf(LF);
        while (index != -1) {
            char c;
            if (++index < value.length() && ((c = value.charAt(index)) == ' ' || c == '\t')) {
                index = value.indexOf(LF, index);
                continue;
            }
            throw new IllegalArgumentException("Illegal character(s) in message header value: " + value);
        }
    }

    private void writeRequests() throws IOException {
        if (!this.setRequests) {
            AuthenticationInfo sauth;
            long modTime;
            AuthenticationInfo pauth;
            if (!this.failedOnce) {
                this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            }
            this.requests.setIfNotSet("User-Agent", userAgent);
            int port = this.url.getPort();
            String host = this.url.getHost();
            if (port != -1 && port != 80) {
                host = host + ":" + String.valueOf(port);
            }
            this.requests.setIfNotSet("Host", host);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy && !this.method.equals("POST") && !this.method.equals("PUT")) {
                    this.requests.setIfNotSet("Proxy-Connection", "keep-alive");
                } else if (!this.http.usingProxy) {
                    this.requests.setIfNotSet("Connection", "keep-alive");
                }
            } else {
                this.requests.set("Connection", "close");
            }
            if (this.http.usingProxy && (pauth = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed())) != null && pauth.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(pauth.getHeaderName(), pauth.getHeaderValue());
            }
            if ((modTime = this.getIfModifiedSince()) != 0L) {
                Date date = new Date(modTime);
                SimpleDateFormat fo = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'");
                fo.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.requests.setIfNotSet("If-Modified-Since", fo.format(date));
            }
            if ((sauth = AuthenticationInfo.getServerAuth(this.url)) != null && sauth.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(sauth.getHeaderName(), sauth.getHeaderValue());
            }
            if (this.poster != null) {
                ByteArrayOutputStream byteArrayOutputStream = this.poster;
                synchronized (byteArrayOutputStream) {
                    if (!this.method.equals("PUT")) {
                        String type = "application/x-www-form-urlencoded";
                        this.requests.setIfNotSet("Content-type", type);
                    }
                    this.requests.set("Content-length", String.valueOf(this.poster.size()));
                }
            }
            this.setRequests = true;
        }
        try {
            try {
                Method method = (class$sun$net$www$http$HttpClient == null ? (class$sun$net$www$http$HttpClient = HttpURLConnection.class$("sun.net.www.http.HttpClient")) : class$sun$net$www$http$HttpClient).getMethod("writeRequests", class$sun$net$www$MessageHeader == null ? (class$sun$net$www$MessageHeader = HttpURLConnection.class$("sun.net.www.MessageHeader")) : class$sun$net$www$MessageHeader);
                method.invoke((Object)this.http, this.requests);
                if (this.poster != null) {
                    this.poster.writeTo(this.ps);
                    this.ps.flush();
                }
            }
            catch (NoSuchMethodException e) {
                try {
                    Method method = (class$sun$net$www$http$HttpClient == null ? (class$sun$net$www$http$HttpClient = HttpURLConnection.class$("sun.net.www.http.HttpClient")) : class$sun$net$www$http$HttpClient).getMethod("writeRequests", class$sun$net$www$MessageHeader == null ? (class$sun$net$www$MessageHeader = HttpURLConnection.class$("sun.net.www.MessageHeader")) : class$sun$net$www$MessageHeader, class$java$io$ByteArrayOutputStream == null ? (class$java$io$ByteArrayOutputStream = HttpURLConnection.class$("java.io.ByteArrayOutputStream")) : class$java$io$ByteArrayOutputStream);
                    method.invoke((Object)this.http, this.requests, this.poster);
                }
                catch (NoSuchMethodException e2) {
                    throw new UnsupportedOperationException("HttpURLConnection.writeRequests(1)");
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("HttpURLConnection.writeRequests(2)");
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("HttpURLConnection.writeRequests(3)");
        }
        if (this.ps.checkError()) {
            this.disconnect();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            this.http = this.getNewClient(this.url);
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    protected HttpClient getNewClient(URL url) throws IOException {
        return new HttpClient(url, null, -1);
    }

    protected HttpClient getProxiedClient(URL url, String proxyHost, int proxyPort) throws IOException {
        return new HttpClient(url, proxyHost, proxyPort);
    }

    protected HttpURLConnection(URL u, Handler handler) throws IOException {
        super(u);
        this.handler = handler;
    }

    public HttpURLConnection(URL u, String host, int port) throws IOException {
        this(u, new Handler(host, port));
    }

    public static void setDefaultAuthenticator(HttpAuthenticator a) {
        defaultAuth = a;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 305 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !base.getProtocol().equals(target.getProtocol()) || base.getPort() != target.getPort() || !HttpURLConnection.hostsEqual(base, target) || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    private static boolean hostsEqual(URL u1, URL u2) {
        final String h1 = u1.getHost();
        final String h2 = u2.getHost();
        if (h1 == null) {
            return h2 == null;
        }
        if (h2 == null) {
            return false;
        }
        if (h1.equalsIgnoreCase(h2)) {
            return true;
        }
        final boolean[] result = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InetAddress a1 = InetAddress.getByName(h1);
                    InetAddress a2 = InetAddress.getByName(h2);
                    result[0] = a1.equals(a2);
                }
                catch (UnknownHostException e) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return null;
            }
        });
        return result[0];
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url) : new HttpClient(this.url, this.handler.proxy, this.handler.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.setRequestMethod("POST");
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            this.connect();
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.poster == null) {
                this.poster = new ByteArrayOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.inputStream != null && !this.connected && this.rememberedException != null) {
            if (this.rememberedException instanceof RuntimeException) {
                throw (RuntimeException)this.rememberedException;
            }
            throw (IOException)this.rememberedException;
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        int redirects = 0;
        AuthenticationInfo serverAuthentication = null;
        AuthenticationInfo proxyAuthentication = null;
        try {
            do {
                this.pe = new ProgressEntry(this.url.getFile(), null);
                ProgressData.pdata.register(this.pe);
                this.connect();
                this.ps = (PrintStream)this.http.getOutputStream();
                this.writeRequests();
                this.http.parseHTTP(this.responses, this.pe);
                this.inputStream = this.http.getInputStream();
                int respCode = this.getResponseCode();
                if (respCode == 407) {
                    if (proxyAuthentication != null) {
                        proxyAuthentication.removeFromCache();
                    }
                    if ((proxyAuthentication = this.getHttpProxyAuthentication()) != null) {
                        this.disconnect();
                        ++redirects;
                        continue;
                    }
                }
                if (respCode == 401) {
                    if (serverAuthentication != null) {
                        serverAuthentication.removeFromCache();
                    }
                    if ((serverAuthentication = this.getServerAuthentication()) != null) {
                        this.disconnect();
                        ++redirects;
                        continue;
                    }
                }
                if (respCode == 200 || respCode >= 300 && respCode <= 305) {
                    if (proxyAuthentication != null) {
                        proxyAuthentication.addToCache();
                    }
                    if (serverAuthentication != null) {
                        serverAuthentication.addToCache();
                    }
                }
                if (this.followRedirect()) {
                    ++redirects;
                    continue;
                }
                if (this.method.equals("HEAD") || this.method.equals("TRACE")) {
                    this.disconnect();
                    this.inputStream = new EmptyInputStream();
                    return this.inputStream;
                }
                String fname = this.url.getFile();
                if (respCode >= 400) {
                    if (respCode == 404 || respCode == 410) {
                        throw new FileNotFoundException(this.url.toString());
                    }
                    throw new IOException("Server returned HTTP code >= 400");
                }
                return this.inputStream;
            } while (redirects < 5);
            throw new ProtocolException("Server redirected too many times (" + redirects + ")");
        }
        catch (RuntimeException e) {
            this.disconnect();
            this.rememberedException = e;
            throw e;
        }
        catch (IOException e) {
            this.rememberedException = e;
            throw e;
        }
    }

    public InputStream getErrorStream() {
        if (this.connected && this.responseCode >= 400 && this.inputStream != null) {
            return this.inputStream;
        }
        return null;
    }

    private AuthenticationInfo getHttpProxyAuthentication() {
        AuthenticationInfo ret = null;
        String raw = this.getHeaderField("Proxy-authenticate");
        String host = this.http.getProxyHostUsed();
        int port = this.http.getProxyPortUsed();
        if (host != null && raw != null) {
            Object a;
            HeaderParser p = new HeaderParser(raw);
            String realm = p.findValue("realm");
            String scheme = p.findKey(0);
            ret = AuthenticationInfo.getProxyAuth(host, port, realm);
            if (ret == null && "basic".equalsIgnoreCase(scheme)) {
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByName(host);
                }
                catch (UnknownHostException ignored) {
                    // empty catch block
                }
                a = HttpURLConnection.privilegedRequestPasswordAuthentication(addr, port, "http", realm, scheme);
                if (a != null) {
                    ret = new BasicAuthentication(true, host, port, realm, (PasswordAuthentication)a);
                }
            }
            if (ret == null && defaultAuth != null && defaultAuth.schemeSupported(scheme)) {
                try {
                    URL u = new URL("http", host, port, "/");
                    a = defaultAuth.authString(u, scheme, realm);
                    if (a != null) {
                        ret = new BasicAuthentication(true, host, port, realm, (String)a);
                    }
                }
                catch (MalformedURLException ignored) {
                    // empty catch block
                }
            }
            if (ret != null && !ret.setHeaders(this, p)) {
                ret = null;
            }
        }
        return ret;
    }

    private AuthenticationInfo getServerAuthentication() {
        AuthenticationInfo ret = null;
        String raw = this.getHeaderField("WWW-Authenticate");
        if (raw != null) {
            Object a;
            HeaderParser p = new HeaderParser(raw);
            String realm = p.findValue("realm");
            String scheme = p.findKey(0);
            ret = AuthenticationInfo.getServerAuth(this.url, realm);
            InetAddress addr = null;
            if (ret == null) {
                try {
                    addr = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException ignored) {
                    // empty catch block
                }
            }
            if (ret == null && "basic".equalsIgnoreCase(scheme) && (a = HttpURLConnection.privilegedRequestPasswordAuthentication(addr, this.url.getPort(), this.url.getProtocol(), realm, scheme)) != null) {
                ret = new BasicAuthentication(false, this.url, realm, (PasswordAuthentication)a);
            }
            if (ret == null && "digest".equalsIgnoreCase(scheme) && (a = HttpURLConnection.privilegedRequestPasswordAuthentication(addr, this.url.getPort(), this.url.getProtocol(), realm, scheme)) != null) {
                ret = new DigestAuthentication(this.url, realm, scheme, (PasswordAuthentication)a);
            }
            if (ret == null && defaultAuth != null && defaultAuth.schemeSupported(scheme) && (a = defaultAuth.authString(this.url, scheme, realm)) != null) {
                ret = new BasicAuthentication(false, this.url, realm, (String)a);
            }
            if (ret != null && !ret.setHeaders(this, p)) {
                ret = null;
            }
        }
        return ret;
    }

    private boolean followRedirect() throws IOException {
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int stat = this.getResponseCode();
        if (stat < 300 || stat > 305 || stat == 304) {
            return false;
        }
        String loc = this.getHeaderField("Location");
        if (loc == null) {
            return false;
        }
        this.disconnect();
        this.responses = new MessageHeader();
        if (stat == 305) {
            URL urlp = new URL(loc);
            this.http = this.getProxiedClient(this.url, urlp.getHost(), urlp.getPort());
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
        } else {
            this.url = new URL(this.url, loc);
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect")) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                this.connect();
            } else {
                this.connect();
                this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
                this.requests.set("Host", this.url.getHost() + (this.url.getPort() == -1 || this.url.getPort() == 80 ? "" : ":" + String.valueOf(this.url.getPort())));
            }
        }
        return true;
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pe != null) {
            ProgressData.pdata.unregister(this.pe);
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.usingProxy;
        }
        return false;
    }

    public String getHeaderField(String name) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.findValue(name);
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getValue(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.responses.getKey(n);
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        String resp = this.getHeaderField(0);
        try {
            int ind = resp.indexOf(32);
            while (resp.charAt(ind) == ' ') {
                ++ind;
            }
            this.responseCode = Integer.parseInt(resp.substring(ind, ind + 3));
            this.responseMessage = resp.substring(ind + 4).trim();
            return this.responseCode;
        }
        catch (Exception e) {
            this.getInputStream();
            return this.responseCode;
        }
    }

    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        this.checkMessageHeader(key, value);
        this.requests.set(key, value);
    }

    void setAuthenticationProperty(String key, String value) {
        this.checkMessageHeader(key, value);
        this.requests.set(key, value);
    }

    public String getRequestProperty(String key) {
        return this.requests.findValue(key);
    }

    public void finalize() {
    }

    String getMethod() {
        return this.method;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

