/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.client.p2p.http.handler;

import com.sun.xml.messaging.saaj.client.p2p.http.handler.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;
import sun.net.www.HeaderParser;

abstract class AuthenticationInfo {
    static final char SERVER_AUTHENTICATION = 's';
    static final char PROXY_AUTHENTICATION = 'p';
    private static Hashtable cache = new Hashtable();
    char type;
    String host;
    int port;
    String realm;
    String path;

    AuthenticationInfo(char type, String host, int port, String realm) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.realm = realm;
        this.path = null;
    }

    AuthenticationInfo(char type, URL url, String realm) {
        this.type = type;
        this.host = url.getHost();
        this.port = url.getPort();
        this.realm = realm;
        String urlPath = url.getPath();
        if (urlPath.length() == 0) {
            this.path = urlPath;
        } else {
            int sepIndex = urlPath.lastIndexOf(47);
            int targetSuffixIndex = urlPath.lastIndexOf(46);
            this.path = sepIndex != -1 ? (sepIndex < targetSuffixIndex ? urlPath.substring(0, sepIndex + 1) : urlPath) : null;
        }
    }

    static AuthenticationInfo getServerAuth(URL url) {
        String key = "s:" + url.getHost() + ":" + url.getPort();
        return AuthenticationInfo.getAuth(key, url);
    }

    static AuthenticationInfo getServerAuth(URL url, String realm) {
        String key = "s:" + url.getHost() + ":" + url.getPort() + ":" + realm;
        return AuthenticationInfo.getAuth(key, url);
    }

    private static AuthenticationInfo getAuth(String key, URL url) {
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key);
        if (result != null) {
            String p = url.getPath();
            if (result.path != null && !p.startsWith(result.path)) {
                result = null;
            }
        }
        return result;
    }

    static AuthenticationInfo getProxyAuth(String host, int port) {
        String key = "p:" + host + ":" + port;
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key);
        return result;
    }

    static AuthenticationInfo getProxyAuth(String host, int port, String realm) {
        String key = "p:" + host + ":" + port + ":" + realm;
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key);
        return result;
    }

    void addToCache() {
        cache.put(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.put(this.cacheKey(false), this);
        }
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true));
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false));
        }
    }

    abstract boolean supportsPreemptiveAuthorization();

    abstract String getHeaderName();

    abstract String getHeaderValue();

    boolean setHeaders(HttpURLConnection conn, HeaderParser p) {
        conn.setAuthenticationProperty(this.getHeaderName(), this.getHeaderValue());
        return true;
    }

    String cacheKey(boolean includeRealm) {
        if (includeRealm) {
            return this.type + ":" + this.host + ":" + this.port + ":" + this.realm;
        }
        return this.type + ":" + this.host + ":" + this.port;
    }
}

