/*
 * Decompiled with CFR 0.152.
 */
package com.makeLogic.utils;

import com.makeLogic.utils.FileMenu;
import com.makeLogic.utils.InternalFrameClosingHandler;
import com.makeLogic.utils.MLInternalFrame;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;

public class OpenMenuItem
extends JMenuItem
implements ActionListener {
    Container container;
    Hashtable internalFramesOpenFileNames;
    Vector recentFileEntries;

    OpenMenuItem(Container container) {
        super("Open");
        this.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this.addActionListener(this);
        this.container = container;
    }

    public void setKeyStrokeForOpenMenuItem(KeyStroke openMenuItemKeyStroke) {
        this.setAccelerator(openMenuItemKeyStroke);
    }

    public void actionPerformed(ActionEvent evt) {
        File dir = new File("e:\\windowing-venkat\\");
        JFileChooser fileChooser = new JFileChooser(dir);
        this.firePropertyChange("FileChooserOpened", fileChooser, null);
        int response = fileChooser.showOpenDialog(this.container);
        if (response == 0) {
            try {
                File selectedFile = fileChooser.getSelectedFile();
                DataInputStream inputStream = new DataInputStream(new FileInputStream(selectedFile.getAbsolutePath()));
                StringBuffer stringBuffer = new StringBuffer((int)selectedFile.length());
                String tempText = "";
                while ((tempText = inputStream.readLine()) != null) {
                    stringBuffer.append(tempText + "\n");
                }
                MLInternalFrame internalFrame = new MLInternalFrame(this.container, selectedFile, stringBuffer);
                JViewport jvp = (JViewport)((JScrollPane)internalFrame.getContentPane().getComponent(0)).getComponent(0);
                JEditorPane jep = (JEditorPane)jvp.getComponent(0);
                jep.setCaretPosition(0);
                this.internalFramesOpenFileNames = FileMenu.getInternalFramesOpenFileNamesHashTable();
                this.recentFileEntries = FileMenu.getRecentFileEntriesVector();
                this.internalFramesOpenFileNames.put(internalFrame, selectedFile.getAbsolutePath());
                this.recentFileEntries.add(selectedFile.getAbsolutePath());
                internalFrame.addInternalFrameListener(new InternalFrameClosingHandler(this.container, this.internalFramesOpenFileNames, internalFrame));
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(null, fnfe.getMessage(), "MakeLogic:FileMenu", 0);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, ioe.getMessage(), "MakeLogic:FileMenu", 0);
            }
        }
    }
}

