/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.formula.node;

import com.japisoft.formula.FunctionResolverException;
import com.japisoft.formula.ListOfArgument;
import com.japisoft.formula.Variant;
import com.japisoft.formula.node.AbstractNode;
import com.japisoft.formula.node.EvaluateException;
import com.japisoft.formula.node.NodeContext;
import java.math.BigDecimal;
import java.util.Vector;

public class FunctionNode
extends AbstractNode {
    private boolean c = false;

    public String getFunctionName() {
        return this.getContent();
    }

    public void setFunctionName(String string) {
        this.setContent(string);
    }

    public void setRootMode(boolean bl) {
        this.c = bl;
    }

    public Object evaluate(NodeContext nodeContext) throws EvaluateException {
        if (this.c) {
            if (this.getChildCount() == 0) {
                return null;
            }
            AbstractNode abstractNode = this.getChildAt(0);
            return abstractNode.evaluate(nodeContext);
        }
        if (nodeContext.getFunctionResolver() == null) {
            throw new EvaluateException(this.getPos(), "Bad resolver for function '" + this.getFunctionName() + "'");
        }
        Vector<Variant> vector = null;
        Object object = this.getChildAt(0).evaluate(nodeContext);
        if (object instanceof Vector) {
            vector = (Vector<Variant>)object;
        } else {
            vector = new Vector<Variant>();
            vector.addElement(new Variant(object));
        }
        try {
            Variant variant = nodeContext.getFunctionResolver().getValue(this.getFunctionName(), new ListOfArgument(vector));
            if (variant != null) {
                if (variant.isList()) {
                    Vector vector2 = variant.getListValue();
                    int n = 0;
                    while (n < vector2.size()) {
                        Object e = vector2.get(n);
                        if (!(e instanceof Variant)) {
                            vector2.set(n, new Variant(e));
                        }
                        ++n;
                    }
                }
                if (variant.isDouble()) {
                    if (nodeContext.isHighPrecisionMode()) {
                        return new BigDecimal(variant.getDoubleValue());
                    }
                    return new Double(variant.getDoubleValue());
                }
                if (variant.isString()) {
                    return variant.getStringValue();
                }
                if (variant.isBoolean()) {
                    return new Boolean(variant.getBooleanValue());
                }
                if (variant.isBigDecimal()) {
                    return variant.getBigDecimalValue();
                }
                if (variant.isList()) {
                    return variant.getListValue();
                }
            }
            return null;
        }
        catch (FunctionResolverException functionResolverException) {
            throw new EvaluateException(this.getPos(), functionResolverException.getMessage());
        }
    }
}

