{******************************************}
{                                          }
{             FastReport v2.5              }
{           Images export filter           }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit frexpimg;

interface

{$I fr.inc}

uses
  SysUtils, Types, Classes, QGraphics, QForms, QStdCtrls,
  fr_class, QControls;

type
  PDirEntry = ^TDirEntry;
  TDirEntry = record
    _Tag: Word;
    _Type: Word;
    _Count: LongInt;
    _Value: LongInt;
  end;

type
  TfrImgFltSet = class(TForm)
    OK: TButton;
    Cancel: TButton;
    GroupPageRange: TGroupBox;
    Label7: TLabel;
    E_Range: TEdit;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    CropPage: TCheckBox;
    Label2: TLabel;
    Quality: TEdit;
    Mono: TCheckBox;
    procedure FormCreate(Sender: TObject);
  private
    procedure Localize;
  end;

  TfrImgFltExport = class(TfrExportFilter)
  private
    CurrentPage: integer;
    Canvas: TBitmap;
    MaxX, MaxY: Integer;
    MinX, MinY: Integer;
    frExportSet: TfrImgFltSet;
    pgList: TStringList;
    JPGQuality: integer;
    Crop: Boolean;
    FMono: Boolean;
    procedure AfterExport(const FileName: string);
    procedure Save; virtual; abstract;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function ShowModal: Word; override;
    procedure OnBeginDoc; override;
    procedure OnEndPage; override;
    procedure OnBeginPage; override;
    procedure OnData(x, y: Integer; View: TfrView); override;
  published
    property Quality: integer read JPGQuality write JPGQuality default 90;
    property CropImages: Boolean read Crop write Crop default True;
    property Monochrome: Boolean read FMono write FMono default False;
  end;

  TfrBMPExport = class(TfrImgFltExport)
  private
    procedure Save; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property CropImages;
    property Monochrome;
  end;

{$IFDEF JPEG}
  TfrJPEGExport = class(TfrImgFltExport)
  private
    procedure Save; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Quality;
    property CropImages;
    property Monochrome;
  end;
{$ENDIF}

implementation

uses FR_Const, FR_Utils;

{$R *.xfm}

constructor TfrImgFltExport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  pgList := TStringList.Create;
  JPGQuality := 90;
  ShowDialog := True;
  Crop := True;
  Monochrome := False;
end;

constructor TfrBMPExport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  frRegisterExportFilter(Self, (S54875), '*.bmp');
end;

destructor TfrImgFltExport.Destroy;
begin
  pgList.Destroy;
  inherited;
end;

destructor TfrBMPExport.Destroy;
begin
  frUnRegisterExportFilter(Self);
  inherited;
end;

{$IFDEF JPEG}
constructor TfrJPEGExport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  frRegisterExportFilter(Self, (S54877), '*.jpg');
end;

destructor TfrJPEGExport.Destroy;
begin
  frUnRegisterExportFilter(Self);
  inherited;
end;

procedure TfrJPEGExport.Save;
var
  Image: TBitmap;
  Stream: TFileStream;
begin
  Stream := TFileStream.Create(ChangeFileExt(FileName, '_' +
    IntToStr(CurrentPage) + '.jpg'), fmCreate);
  Image := TBitmap.Create;
  Image.Format := SVJpegs;
//  Image.CompressionQuality := JPGQuality;
  Image.Assign(Canvas);
  Image.SaveToStream(Stream);
  Image.Free;
  Stream.Free;
end;
{$ENDIF}

function TfrImgFltExport.ShowModal: Word;
var
  PageNumbers: string;
  Res: integer;

  procedure ParsePageNumbers;
  var
    i, j, n1, n2: Integer;
    s: string;
    IsRange: Boolean;
  begin
    s := PageNumbers;
    while Pos(' ', s) <> 0 do
      Delete(s, Pos(' ', s), 1);
    if s = '' then
      Exit;
    s := s + ',';
    i := 1;
    j := 1;
    n1 := 1;
    IsRange := False;
    while i <= Length(s) do
    begin
      if s[i] = ',' then
      begin
        n2 := StrToInt(Copy(s, j, i - j));
        j := i + 1;
        if IsRange then
          while n1 <= n2 do
          begin
            pgList.Add(IntToStr(n1));
            Inc(n1);
          end
        else
          pgList.Add(IntToStr(n2));
        IsRange := False;
      end
      else if s[i] = '-' then
      begin
        IsRange := True;
        n1 := StrToInt(Copy(s, j, i - j));
        j := i + 1;
      end;
      Inc(i);
    end;
  end;

begin
  Res := mrOk;
  if ShowDialog then
  begin
    frExportSet := TfrImgFltSet.Create(nil);
    frExportSet.Quality.Text := IntToStr(JPGQuality);
    frExportSet.CropPage.Checked := Crop;
    frExportSet.Mono.Checked := Monochrome;
{$IFDEF JPEG}
    if Self is TfrJPEGExport then
      frExportSet.Quality.Enabled := true
    else
{$ENDIF}
      frExportSet.Quality.Enabled := false;
    Res := frExportSet.ShowModal;
    JPGQuality := StrToInt(frExportSet.Quality.Text);
    Crop := frExportSet.CropPage.Checked;
    PageNumbers := frExportSet.E_Range.Text;
    Monochrome := frExportSet.Mono.Checked;
    frExportSet.Destroy;
  end;
  pgList.Clear;
  ParsePageNumbers;
  Result := Res;
end;

procedure TfrImgFltExport.OnBeginDoc;
begin
  OnAfterExport := AfterExport;
  CurrentPage := 0;
end;

procedure TfrImgFltExport.OnBeginPage;
begin
  Inc(CurrentPage);
  Canvas := TBitmap.Create;
  Canvas.Canvas.Brush.Color := clWhite;
  if Monochrome then
    Canvas.Monochrome := true
  else
    Canvas.Monochrome := false;
  if not Crop then
  begin
    Canvas.Width := CurReport.EMFPages[CurrentPage - 1].PrnInfo.Pgw;
    Canvas.Height := CurReport.EMFPages[CurrentPage - 1].PrnInfo.Pgh;
  end;
  MaxX := 0;
  MaxY := 0;
  MinX := CurReport.EMFPages[CurrentPage - 1].PrnInfo.Pgw;
  MinY := CurReport.EMFPages[CurrentPage - 1].PrnInfo.Pgh;
end;

procedure TfrImgFltExport.OnData(x, y: Integer; View: TfrView);
var
  ind: integer;
begin
  ind := 0;
  if (pgList.Find(IntToStr(CurrentPage), ind)) or (pgList.Count = 0) then
  begin
    if View.x < MinX then
      MinX := View.x;
    if View.y < MinY then
      MinY := View.Y;
    if (View.x + View.dx) > MaxX then
      MaxX := View.x + View.dx + 1;
    if (View.y + View.dy) > MaxY then
      MaxY := View.y + View.dY + 1;
    if Crop then
    begin
      Canvas.Canvas.Brush.Color := clWhite;
      Canvas.Width := MaxX;
      Canvas.Height := MaxY
    end;
    View.Draw(Canvas.Canvas);
  end;
end;

procedure TfrImgFltExport.OnEndPage;
var
  ind: integer;
  RFrom, RTo: TRect;
begin
  ind := 0;
  if (pgList.Find(IntToStr(CurrentPage), ind)) or (pgList.Count = 0) then
  begin
    if Crop then
    begin
      RFrom := Rect(MinX, MinY, MaxX, MaxY);
      RTo := Rect(0, 0, MaxX - MinX, MaxY - MinY);
      Canvas.Canvas.CopyMode := cmSrcCopy;
      Canvas.Canvas.CopyRect(RTo, Canvas.Canvas, RFrom);
      Canvas.Width := MaxX - MinX;
      Canvas.Height := MaxY - MinY;
    end;
    Save;
  end;
  Canvas.Free;
end;

procedure TfrBMPExport.Save;
begin
  Canvas.SaveToFile(ChangeFileExt(FileName, '_' + IntToStr(CurrentPage) +
    '.bmp'));
end;

procedure TfrImgFltExport.AfterExport(const FileName: string);
begin
  frProgressForm.Close;
  DeleteFile(FileName);
end;

procedure TfrImgFltSet.Localize;
begin
  Ok.Caption := (SOk);
  Cancel.Caption := (SCancel);
  Caption := (S54878);
  GroupPageRange.Caption := (S53044);
  Label7.Caption := (S53047);
  label1.Caption := (S53048);
  GroupBox1.Caption := (S54879);
  Label2.Caption := (S54880);
  CropPage.Caption := (S54881);
  Mono.Caption := (S54882);
end;

procedure TfrImgFltSet.FormCreate(Sender: TObject);
begin
   Localize;
end;


end.

