
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{            Registration unit             }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}


unit fr_reg;

interface

{$I fr.inc}

procedure Register;

implementation

uses
  Classes,
  DesignIntf, DesignEditors,
  QDialogs, fr_class, fr_dset, fr_dbset,
  fr_chbox, fr_shape
{$IFNDEF KYLIXBUG}
, fr_barc
{$ENDIF}
, fr_rrect,
  fr_desgn, fr_view, fr_dock, fr_ctrls, fr_utils, fr_ptabl,
  fr_e_txt, fr_e_rtf, fr_e_csv, fr_e_htm, fr_const, fr_dctrl, fr_cross,
  frexpimg, fr_e_html2_editors, fr_e_html2;

{-----------------------------------------------------------------------}
type
  TfrRepEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): String; override;
    function GetVerbCount: Integer; override;
    procedure DoDesign;
  end;


procedure TfrRepEditor.ExecuteVerb(Index: Integer);
begin
  DoDesign;
end;

function TfrRepEditor.GetVerb(Index: Integer): String;
begin
  Result := (SDesignReport);
end;

function TfrRepEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

procedure TfrRepEditor.DoDesign;
begin
  TfrReport(Component).DesignReport;
  if TfrReport(Component).StoreInDFM then
    if TfrReport(Component).ComponentModified then
      Designer.Modified;
end;


//--------------------------------------------------------------------------
procedure Register;
begin
  RegisterComponents('FastReport',
    [TfrReport, TfrCompositeReport, TfrDBDataSet, TfrUserDataset,
     TfrCheckBoxObject, TfrShapeObject
{$IFNDEF KYLIXBUG}
   , TfrbarcodeObject
{$ENDIF}
   , TfrRoundRectObject, TfrCrossObject,
     TfrTextExport, TfrDesigner, TfrPreview, TfrDialogControls, 
     TfrPrintTable, TfrPrintGrid]);
  RegisterComponents('FastReport Exports',
    [TfrRTFExport, TfrCSVExport, TfrHTMExport, TfrHTML2Export, TfrBMPExport
{$IFDEF JPEG}
     , TfrJPEGExport
{$ENDIF}
    ]);
  RegisterComponents('FastReport Tools',
    [TfrSpeedButton, TfrDock, TfrToolBar, TfrTBToolBar,
     TfrTBButton, TfrTBSeparator, TfrTBPanel,
     TfrComboEdit, TfrComboBox, TfrFontComboBox]);
  RegisterComponentEditor(TfrReport, TfrRepEditor);

  RegisterPropertyEditor(TypeInfo(THNavigator), TfrHTML2Export, 'Navigator',
    THNavigatorProperty);

end;

end.
