
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{              Print dialog                }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_prdlg;

interface

{$I fr.inc}

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, fr_ctrls, QExtCtrls, QButtons;

type
  TfrPrintForm = class(TForm)
    GroupBox2: TGroupBox;
    RB1: TRadioButton;
    RB2: TRadioButton;
    RB3: TRadioButton;
    E2: TEdit;
    Label2: TLabel;
    Button1: TButton;
    Button2: TButton;
    GroupBox1: TGroupBox;
    CB1: TComboBox;
    PropButton: TButton;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    E1: TEdit;
    Panel1: TPanel;
    frSpeedButton1: TfrSpeedButton;
    frSpeedButton2: TfrSpeedButton;
    CollateCB: TCheckBox;
    CollateImg: TImage;
    NonCollateImg: TImage;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Image1: TImage;
    CB2: TComboBox;
    PB1: TPaintBox;
    procedure FormCreate(Sender: TObject);
    procedure PropButtonClick(Sender: TObject);
    procedure E2Click(Sender: TObject);
    procedure frSpeedButton1Click(Sender: TObject);
    procedure frSpeedButton2Click(Sender: TObject);
    procedure RB3Click(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure Label3Click(Sender: TObject);
    procedure CollateCBClick(Sender: TObject);
    procedure PB1Paint(Sender: TObject);
    procedure CB1DrawItem(Sender: TObject; Index: Integer; ARect: TRect;
      State: TOwnerDrawState; var Handled: Boolean);
    procedure CB1Change(Sender: TObject);
  private
    { Private declarations }
    OldIndex: Integer;
    procedure Localize;
  public
    { Public declarations }
  end;


implementation

{$R *.xfm}

uses fr_class, fr_const, fr_prntr, QPrinters, fr_utils;


procedure TfrPrintForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53040;
  GroupBox1.Caption := S53041;
  PropButton.Caption := S53042;
  GroupBox3.Caption := S53043;
  GroupBox2.Caption := S53044;
  RB1.Caption := S53045;
  RB2.Caption := S53046;
  RB3.Caption := S53047;
  Label2.Caption := S53048;
  Label4.Caption := S53049;
  Label1.Caption := S53050;
  Label3.Caption := S53051;
  Label5.Caption := S53052;
  Button1.Caption := SOk;
  Button2.Caption := SCancel;

  CB2.Items.Add(S53053);
  CB2.Items.Add(S53054);
  CB2.Items.Add(S53055);
end;

procedure TfrPrintForm.FormCreate(Sender: TObject);
begin
  CB1.Items.Assign(Printer.Printers);
  CB1.ItemIndex := Prn.PrinterIndex;
  OldIndex := Prn.PrinterIndex;
  CollateCBClick(nil);
  Localize;
  CB2.ItemIndex := 0;
  CB2.Left := Label5.Left + Label5.Width + 11;
end;

procedure TfrPrintForm.FormDeactivate(Sender: TObject);
begin
  if ModalResult <> mrOk then
    Prn.PrinterIndex := OldIndex;
end;

procedure TfrPrintForm.CB1DrawItem(Sender: TObject; Index: Integer;
  ARect: TRect; State: TOwnerDrawState; var Handled: Boolean);
var
  r: TRect;
begin
  r := ARect;
  r.Right := r.Left + 18;
  r.Bottom := r.Top + 16;
  OffsetRect(r, 2, 0);
  with CB1.Canvas do
  begin
    FillRect(ARect);
    frDrawTransparent(CB1.Canvas, r.Left, r.Top, Image1.Picture.Bitmap);
//    BrushCopy(r, Image1.Picture.Bitmap, Rect(0, 0, 18, 16), clOlive);
    TextOut(ARect.Left + 24, ARect.Top + 1, CB1.Items[Index]);
  end;
end;

procedure TfrPrintForm.PropButtonClick(Sender: TObject);
begin
  Prn.PropertiesDlg;
end;

procedure TfrPrintForm.E2Click(Sender: TObject);
begin
  RB3.Checked := True;
end;

procedure TfrPrintForm.frSpeedButton1Click(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(E1.Text);
  Inc(i);
  E1.Text := IntToStr(i);
end;

procedure TfrPrintForm.frSpeedButton2Click(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(E1.Text);
  Dec(i);
  if i <= 0 then i := 1;
  E1.Text := IntToStr(i);
end;

procedure TfrPrintForm.RB3Click(Sender: TObject);
begin
  E2.SetFocus;
end;

procedure TfrPrintForm.Label3Click(Sender: TObject);
begin
  CollateCB.Checked := not CollateCB.Checked;
end;

procedure TfrPrintForm.CollateCBClick(Sender: TObject);
begin
  PB1Paint(nil);
end;

procedure TfrPrintForm.PB1Paint(Sender: TObject);
begin
  with PB1.Canvas do
  begin
    Brush.Color := clBtnFace;
    FillRect(Rect(0, 0, PB1.Width, PB1.Height));
    if CollateCB.Checked then
      frDrawTransparent(PB1.Canvas, 8, 0, CollateImg.Picture.Bitmap) else
      frDrawTransparent(PB1.Canvas, 0, 8, NonCollateImg.Picture.Bitmap)
  end;
end;


procedure TfrPrintForm.CB1Change(Sender: TObject);
begin
  Prn.PrinterIndex := CB1.ItemIndex;
end;

end.
