
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{            Group band editor             }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_grped;

interface

{$I fr.inc}

uses
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, fr_class, fr_ctrls, fr_const, QExtCtrls;

type
  TfrGroupEditorForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    GB1: TGroupBox;
    Edit1: TfrComboEdit;
    procedure frSpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
    procedure ShowEditor(t: TfrView);
  end;


implementation

uses fr_utils;

{$R *.xfm}

procedure TfrGroupEditorForm.ShowEditor(t: TfrView);
begin
  Edit1.Text := (t as TfrBandView).GroupCondition;
  if ShowModal = mrOk then
  begin
    frDesigner.BeforeChange;
    (t as TfrBandView).GroupCondition := Edit1.Text;
  end;
end;

procedure TfrGroupEditorForm.frSpeedButton1Click(Sender: TObject);
var
  s: String;
begin
  s := frDesigner.InsertExpression;
  if s <> '' then
    Edit1.Text := s;
end;

procedure TfrGroupEditorForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := (S53490);
  GB1.Caption := (S53491);
  Edit1.ButtonHint := (S53492);
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrGroupEditorForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

end.

