
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{               Memo editor                }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_edit;

interface

{$I fr.inc}

uses
  SysUtils, Types, Classes, QGraphics, QControls,
  QForms, QDialogs, QStdCtrls, QButtons, fr_class, QExtCtrls,
  fr_ctrls, QComCtrls, QImgList
{$IFDEF MWEDIT}
, mwHighlighter, mwPasSyn, mwCustomEdit
{$ENDIF};

type
  TfrEditorForm = class(TfrObjEditorForm)
    ScriptPanel: TPanel;
    MemoPanel: TPanel;
    M1: TMemo;
    Splitter: TPanel;
    Panel1: TToolBar;
    OkBtn: TToolButton;
    CancelBtn: TToolButton;
    Bevel2: TBevel;
    InsExprBtn: TToolButton;
    InsDBBtn: TToolButton;
    WordWrapBtn: TToolButton;
    ScriptBtn: TToolButton;
    Panel2: TPanel;
    ErrorPanel: TPanel;
    CutBtn: TToolButton;
    CopyBtn: TToolButton;
    PasteBtn: TToolButton;
    ImageList1: TImageList;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolBar1: TToolBar;
    procedure M1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure M1Enter(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SplitterMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SplitterMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SplitterMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure InsExprBtnClick(Sender: TObject);
    procedure InsDBBtnClick(Sender: TObject);
    procedure WordWrapBtnClick(Sender: TObject);
    procedure ScriptBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure CutBtnClick(Sender: TObject);
    procedure CopyBtnClick(Sender: TObject);
    procedure PasteBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
{$IFDEF MWEDIT}
    M2: TmwCustomEdit;
{$ELSE}
    M2: TMemo;
{$ENDIF}
    FActiveMemo: TWinControl;
    FDown: Boolean;
    FLastY: Integer;
    FView: TfrView;
    FShowScript: Boolean;
    FSplitterPos: Integer;
    procedure SetSelText(s: String);
    procedure Localize;
  public
    { Public declarations }
    function ShowEditor(View: TfrView): TModalResult; override;
  end;


implementation

{$R *.xfm}

uses
  fr_dock, fr_desgn, fr_expr, fr_fmted, fr_flds, fr_const, fr_utils, Qt;

var
  SplitterPos: Integer;
  ShowScript: Boolean = True;
  Wrap: Boolean;
  FormSize: TRect;


function TfrEditorForm.ShowEditor(View: TfrView): TModalResult;
var
  EmptyScript: Boolean;
  ScriptText: String;
  Nm: String;
  isMemoEditor: Boolean;
begin
  Nm := rsForm + frDesigner.ClassName;
  FView := View;
  isMemoEditor := not ((View is TfrControl) or (View is TfrBandView));

  ErrorPanel.Hide;
  WordWrapBtnClick(nil);
  M1.Lines.Assign(FView.Memo);
  M2.Lines.Assign(FView.Script);
  if FView.Script.Text = '' then
    M2.Text := 'begin' + #13#10 + '  ' + #13#10 + 'end';

  M1.Font.Name := frIni.ReadString(Nm, 'TextFontName', frDefaultFont);
{$IFDEF LINUX}
  M2.Font.Name := frIni.ReadString(Nm, 'ScriptFontName', 'adobe-courier');
{$ELSE}
  M2.Font.Name := frIni.ReadString(Nm, 'ScriptFontName', 'Courier New');
{$ENDIF}
  M1.Font.Size := frIni.ReadInteger(Nm, 'TextFontSize', 12);
  M2.Font.Size := frIni.ReadInteger(Nm, 'ScriptFontSize', 12);

  if (FView is TfrMemoView) and frIni.ReadBool(Nm, 'UseDefaultFont', True) then
  begin
    M1.Font.Name := TfrMemoView(FView).Font.Name;
    M1.Font.Size := 10;
  end;
  if View is TfrMemoView then
    M1.Font.Charset := TfrMemoView(View).Font.Charset else
    M1.Font.Charset := TFontCharset(frCharset);
  M2.Font.Charset := TFontCharset(frCharset);
  M1.ReadOnly := (FView.Restrictions and frrfDontEditMemo) <> 0;
  M2.ReadOnly := (FView.Restrictions and frrfDontEditScript) <> 0;

  MemoPanel.Align := alNone;
  MemoPanel.SetBounds(0, 0, 10, 10);
  Splitter.Align := alNone;
  Splitter.SetBounds(0, 20, 10, 2);
  ScriptPanel.Align := alNone;
  ScriptPanel.SetBounds(0, 40, 10, 10);

  ScriptBtn.Down := True;
  if isMemoEditor then
  begin
    MemoPanel.Show;
    Splitter.Visible := FShowScript;
    ScriptPanel.Visible := FShowScript;
    ScriptBtn.Down := FShowScript;
    ScriptPanel.Align := alBottom;
    Splitter.Align := alBottom;
    MemoPanel.Align := alClient;
    ScriptPanel.Height := ClientHeight - FSplitterPos - 2;
  end
  else
  begin
    MemoPanel.Hide;
    Splitter.Hide;
    ScriptPanel.Show;
    ScriptPanel.Align := alClient;
  end;

  if MemoPanel.Visible then
    FActiveMemo := M1 else
    FActiveMemo := M2;

  Result := ShowModal;

  if Result = mrOk then
  begin
    frDesigner.BeforeChange;
    M1.WordWrap := False;
    FView.Memo.Text := M1.Text;
    EmptyScript := (M2.Lines.Count = 3) and
      (Trim(M2.Lines[0]) = 'begin') and
      (Trim(M2.Lines[1]) = '') and
      (Trim(M2.Lines[2]) = 'end');
    if EmptyScript then
      ScriptText := '' else
      ScriptText := M2.Text;
    if not EmptyScript or (FView.Script.Text <> '') then
      FView.Script.Text := ScriptText;
  end;
  if isMemoEditor then
    FShowScript := ScriptBtn.Down;
end;

procedure TfrEditorForm.FormShow(Sender: TObject);
begin
  if MemoPanel.Visible then
    M1.SetFocus else
    M2.SetFocus;
end;

procedure TfrEditorForm.SetSelText(s: String);
begin
  if FActiveMemo = M1 then
    M1.SelText := s else
    M2.SelText := s;
end;

procedure TfrEditorForm.InsExprBtnClick(Sender: TObject);
var
  s: String;
begin
  s := frDesigner.InsertExpression;
  if s <> '' then
    SetSelText(s);
end;

procedure TfrEditorForm.InsDBBtnClick(Sender: TObject);
var
  s: String;
begin
  s := frDesigner.InsertDBField;
  if s <> '' then
    SetSelText(s);
end;

procedure TfrEditorForm.M1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ErrorPanel.Hide;
  if (Key = key_Insert) and (Shift = []) then InsDBBtnClick(Self);
  if Key = key_Escape then ModalResult := mrCancel;
end;

procedure TfrEditorForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #10 then
  begin
    Key := #0;
    OkBtnClick(nil);
  end;
end;

procedure TfrEditorForm.M1Enter(Sender: TObject);
begin
  FActiveMemo := Sender as TWinControl;
end;

procedure TfrEditorForm.WordWrapBtnClick(Sender: TObject);
begin
  M1.WordWrap := WordWrapBtn.Down;
end;

procedure TfrEditorForm.ScriptBtnClick(Sender: TObject);
begin
  if (FView is TfrControl) or (FView is TfrBandView) then
  begin
    ScriptBtn.Down := True;
    Exit;
  end;
  if ScriptBtn.Down then
    ScriptPanel.Top := MemoPanel.Top + 1;
  ScriptPanel.Visible := ScriptBtn.Down;
  Splitter.Visible := ScriptBtn.Down;
  Splitter.Top := MemoPanel.Top + 1;
  if ScriptPanel.Visible then
    Splitter.Cursor := crVSplit else
    Splitter.Cursor := crDefault;
end;

procedure TfrEditorForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53060;
  InsExprBtn.Hint := S53061;
  InsDBBtn.Hint := S53062;
  CutBtn.Hint := S53091;
  CopyBtn.Hint := S53092;
  PasteBtn.Hint := S53093;
  WordWrapBtn.Hint := S53063;
  ScriptBtn.Hint := S53064;
  OkBtn.Hint := (SOk);
  CancelBtn.Hint := (SCancel);
end;

procedure TfrEditorForm.FormCreate(Sender: TObject);
{$IFDEF MWEDIT}
var
  SynParser: TmwPasSyn;
{$ENDIF}
begin
  Localize;
  FShowScript := True;
  FSplitterPos := Height div 2;

{$IFDEF MWEDIT}
  M2 := TmwCustomEdit.Create(Self);
  SynParser := TmwPasSyn.Create(Self);
  {$I *.inc}
{$ELSE}
  M2 := TMemo.Create(Self);
  M2.WordWrap := False;
{$ENDIF}
  M2.Parent := ScriptPanel;
  M2.Align := alClient;
  M2.HelpContext := 20;
  M2.ScrollBars := ssBoth;
{$IFDEF LINUX}
  M2.Font.Name := 'adobe-courier';
{$ELSE}
  M2.Font.Name := 'Courier New';
{$ENDIF}
  M2.Font.Size := 10;
  M2.OnEnter := M1Enter;
  M2.OnKeyDown := M1KeyDown;
{$IFDEF MWEDIT}
  M2.Highlighter := SynParser;
  M2.Gutter.Visible := False;
{$ENDIF}
  if SplitterPos <> 0 then
    FSplitterPos := SplitterPos;
  FShowScript := ShowScript;
  if FormSize.Right <> 0 then
  begin
    Position := poDesigned;
    SetBounds(FormSize.Left, FormSize.Top,
      FormSize.Right - FormSize.Left, FormSize.Bottom - FormSize.Top);
  end;
  WordWrapBtn.Down := Wrap;
end;

procedure TfrEditorForm.FormDestroy(Sender: TObject);
begin
  SplitterPos := FSplitterPos;
  ShowScript := FShowScript;
  FormSize := BoundsRect;
  Wrap := WordWrapBtn.Down;
  ImageList1.Clear;
end;

procedure TfrEditorForm.SplitterMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  FDown := True;
  FLastY := Y;
end;

procedure TfrEditorForm.SplitterMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if FDown then
  begin
    ScriptPanel.Height := ScriptPanel.Height - (Y - FLastY);
    Splitter.Top := Splitter.Top + Y - FLastY;
    FSplitterPos := Splitter.Top;
  end;
end;

procedure TfrEditorForm.SplitterMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  FDown := False;
end;

procedure TfrEditorForm.CancelBtnClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

{$HINTS OFF}
procedure TfrEditorForm.OkBtnClick(Sender: TObject);
var
  sl1, sl2: TStringList;

  procedure ErrorPosition;
  var
    s: String;
    i, n, n1, n2: Integer;
  begin
    s := sl2.Text;
    n := 0;
    n1 := 1;
    if Pos('/', s) <> 0 then
    begin
      n := StrToInt(Copy(s, 6, Pos('/', s) - 6));
      n1 := StrToInt(Copy(s, Pos('/', s) + 1, Pos(':', s) - Pos('/', s) - 1));
    end;

    n2 := 0;
    for i := 0 to n - 2 do
      Inc(n2, Length(M2.Lines[i]) + 2);
    Inc(n2, n1 - 1);
    M2.SetFocus;
{$IFDEF MWEDIT}
    M2.CaretXY := Point(n1, n);
{$ELSE}
//    M2.Perform(EM_SETSEL, n2, n2); M2.Perform(EM_SCROLLCARET, 0, 0);
{$ENDIF}
  end;

begin
  sl1 := TStringList.Create;
  sl2 := TStringList.Create;
  frInterpretator.PrepareScript(M2.Lines, sl1, sl2);
  if sl2.Count > 0 then
  begin
    ErrorPanel.Caption := ' ' + sl2.Text;
    ErrorPanel.Show;
    ErrorPosition;
  end
  else
    ModalResult := mrOk;
  sl1.Free;
  sl2.Free;
end;
{$HINTS ON}

procedure TfrEditorForm.FormResize(Sender: TObject);
begin
  ErrorPanel.Hide;
  if MemoPanel.Visible then
    if ScriptPanel.Height > ClientHeight - 40 then
      ScriptPanel.Height := ClientHeight div 2;
end;

procedure TfrEditorForm.CutBtnClick(Sender: TObject);
begin
  if FActiveMemo = M1 then
    M1.CutToClipboard else
    M2.CutToClipboard;
end;

procedure TfrEditorForm.CopyBtnClick(Sender: TObject);
begin
  if FActiveMemo = M1 then
    M1.CopyToClipboard else
    M2.CopyToClipboard;
end;

procedure TfrEditorForm.PasteBtnClick(Sender: TObject);
begin
  if FActiveMemo = M1 then
    M1.PasteFromClipboard else
    M2.PasteFromClipboard;
end;


end.

