
{******************************************}
{                                          }
{   FastReport CLX v2.4 - DB components    }
{           Available fields list          }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_dbfldlist;

interface

{$I fr.inc}

uses
  Types, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, DB;

type
  TfrDBFieldsListForm = class(TForm)
    FieldsL: TListBox;
    Button1: TButton;
    Button2: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    function FieldExists(FName: String): Boolean;
    procedure Localize;
  public
    { Public declarations }
    DataSet: TDataSet;
  end;


implementation

uses fr_class, fr_const, fr_dbutils, fr_utils;

{$R *.xfm}

function TfrDBFieldsListForm.FieldExists(FName: String): Boolean;
var
  i: Integer;
begin
  Result := False;
  with DataSet do
  for i := 0 to FieldCount - 1 do
    if AnsiCompareText(Fields[i].FieldName, FName) = 0 then
    begin
      Result := True;
      break;
    end;
end;

procedure TfrDBFieldsListForm.FormShow(Sender: TObject);
var
  i: Integer;
begin
  FieldsL.Clear;
  with DataSet do
  begin
    FieldDefs.Update;
    for i := 0 to FieldDefs.Count - 1 do
      if not FieldExists(FieldDefs.Items[i].Name) then
        FieldsL.Items.Add(FieldDefs.Items[i].Name);
  end;
  for i := 0 to FieldsL.Items.Count - 1 do
    FieldsL.Selected[i] := True;
end;

procedure TfrDBFieldsListForm.FormHide(Sender: TObject);
var
  i: Integer;
begin
  if ModalResult = mrOk then
    for i := 0 to FieldsL.Items.Count - 1 do
      if FieldsL.Selected[i] then
        frFindFieldDef(DataSet, FieldsL.Items[i]).CreateField(DataSet);
end;

procedure TfrDBFieldsListForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S56060;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrDBFieldsListForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

end.

