
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{     Select Band datasource dialog        }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_bnded;

interface

{$I fr.inc}

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QExtCtrls, QStdCtrls, fr_class;

type
  TfrBandEditorForm = class(TfrObjEditorForm)
    Button1: TButton;
    Button2: TButton;
    GB1: TGroupBox;
    Label2: TLabel;
    Edit1: TEdit;
    LB1: TListBox;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
    procedure LB1Click(Sender: TObject);
    procedure LB1DblClick(Sender: TObject);
    procedure LB1DrawItem(Sender: TObject; Index: Integer; ARect: TRect;
      State: TOwnerDrawState; var Handled: Boolean);
  private
    { Private declarations }
    procedure FillCombo;
    procedure Localize;
  public
    { Public declarations }
    function ShowEditor(View: TfrView): TModalResult; override;
  end;


implementation

{$R *.xfm}

uses fr_dset, fr_const, fr_utils, fr_ctrls;

function TfrBandEditorForm.ShowEditor(View: TfrView): TModalResult;
var
  i: Integer;
  s: String;
begin
  FillCombo;
  s := (View as TfrBandView).DataSet;
  if (s <> '') and (s[1] in ['1'..'9']) then
  begin
    i := 1;
    Edit1.Text := s;
  end
  else
  begin
    i := LB1.Items.IndexOf(CurReport.Dictionary.AliasName[s]);
    if i = -1 then
      i := LB1.Items.IndexOf((SNotAssigned));
  end;
  LB1.ItemIndex := i;
  LB1Click(nil);
  Result := ShowModal;
  if Result = mrOk then
  begin
    frDesigner.BeforeChange;
    if LB1.ItemIndex = 1 then
      (View as TfrBandView).DataSet := Edit1.Text else
      (View as TfrBandView).DataSet :=
        CurReport.Dictionary.RealDataSourceName[LB1.Items[LB1.ItemIndex]];
  end;
end;

procedure TfrBandEditorForm.FillCombo;
begin
  CurReport.Dictionary.GetBandDatasourceList(LB1.Items);
  LB1.Items.Insert(0, (SVirtualDataset));
  LB1.Items.Insert(0, (SNotAssigned));
end;

procedure TfrBandEditorForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53480;
  Label2.Caption := S53482;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrBandEditorForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

procedure TfrBandEditorForm.LB1Click(Sender: TObject);
begin
  frEnableControls([Label2, Edit1], LB1.ItemIndex = 1);
end;

procedure TfrBandEditorForm.LB1DrawItem(Sender: TObject; Index: Integer;
  ARect: TRect; State: TOwnerDrawState; var Handled: Boolean);
var
  r: TRect;
begin
  r := ARect;
  r.Right := r.Left + 18;
  r.Bottom := r.Top + 16;
  OffsetRect(r, 2, 0);
  with TListBox(Sender) do
  begin
    Canvas.FillRect(ARect);
    if Index <> 0 then
      frDrawTransparent(Canvas, r.Left, r.Top, Image1.Picture.Bitmap);
    Canvas.TextOut(ARect.Left + 20, ARect.Top + 1, Items[Index]);
  end;
end;

procedure TfrBandEditorForm.LB1DblClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;


end.

