
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{            Function arguments            }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_arg;

interface

{$I fr.inc}

uses
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  fr_ctrls, QExtCtrls, QStdCtrls, QButtons;

type
  TfrFuncArgForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ArgEdit1: TfrComboEdit;
    Bevel2: TBevel;
    ArgEdit2: TfrComboEdit;
    ArgEdit3: TfrComboEdit;
    Bevel1: TBevel;
    DescrLabel: TLabel;
    FuncLabel: TLabel;
    procedure ExprBtn1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
    Func: String;
  end;


implementation

uses fr_class, fr_expr, fr_utils, fr_const;

{$R *.xfm}

procedure TfrFuncArgForm.ExprBtn1Click(Sender: TObject);
begin
  with TfrExprForm.Create(nil) do
  begin
    if ShowModal = mrOk then
      TEdit(Sender).Text := ExprMemo.Text;
    Free;
  end;
end;

procedure TfrFuncArgForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53730;
  Label1.Caption := S53731 + ' &1';
  Label2.Caption := S53731 + ' &2';
  Label3.Caption := S53731 + ' &3';
  ArgEdit1.ButtonHint := S53575;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrFuncArgForm.FormShow(Sender: TObject);
var
  i: Integer;
  sSyntax: String;

  procedure EnableControls(ATag: Integer; AEnabled: Boolean);
  begin
    case ATag of
      2: frEnableControls([Label2, ArgEdit2], AEnabled);
      3: frEnableControls([Label3, ArgEdit3], AEnabled);
    end;
  end;

begin
  Localize;
  EnableControls(2, False);
  EnableControls(3, False);
  sSyntax := FuncLabel.Caption;
  i := 2;
  while Pos(',', sSyntax) <> 0 do
  begin
    sSyntax[Pos(',', sSyntax)] := ' ';
    EnableControls(i, True);
    Inc(i);
  end;
end;

procedure TfrFuncArgForm.FormHide(Sender: TObject);
begin
  Func := Func + '(' + ArgEdit1.Text;
  if ArgEdit2.Text <> '' then
    Func := Func + ', ' + ArgEdit2.Text;
  if ArgEdit3.Text <> '' then
    Func := Func + ', ' + ArgEdit3.Text;
  Func := Func + ')';
end;

end.
