// FastReport 2.4 demo
//
// Main demo

unit unit1;

interface

uses
  SysUtils, Classes, QImgList, QStdCtrls, QComCtrls, QControls, QForms,
  QGraphics, QExtCtrls, fr_class;

type
  TForm1 = class(TForm)
    Tree1: TTreeView;
    ImageList1: TImageList;
    Image1: TImage;
    Label4: TLabel;
    GroupBox1: TGroupBox;
    RB1: TRadioButton;
    RB2: TRadioButton;
    DesignBtn: TButton;
    PreviewBtn: TButton;
    Memo1: TMemo;
    procedure FormShow(Sender: TObject);
    procedure Tree1Change(Sender: TObject; Node: TTreeNode);
    procedure DesignBtnClick(Sender: TObject);
    procedure PreviewBtnClick(Sender: TObject);
  private
    { Private declarations }
    WPath: String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;


implementation

uses unit2, unit3, datasets;

{$R *.xfm}


function NodeIndex(Node: TTreeNode): Integer;
begin
  Result := -1;
  if Pos('.', Node.Text) <> 0 then
    Result := StrToInt(Copy(Node.Text, 1, Pos('.', Node.Text) - 1));
end;


procedure TForm1.FormShow(Sender: TObject);
begin
{$IFDEF LINUX}
  Font.Name := frDefaultFont;
{$ENDIF}
  WPath := ExtractFilePath(ParamStr(0));
  Tree1.Items[0].Expand(True);
  Tree1.Selected := Tree1.Items[0].Item[0].Item[0];
  Tree1.TopItem := Tree1.Items[0];
// shows how to disable particular dataset or entire datamodule
//  Form2.frReport1.Dictionary.DisabledDatasets.Add('CustomerData.Bio');
//  Form2.frReport1.Dictionary.DisabledDatasets.Add('CustomerData*');
end;

procedure TForm1.Tree1Change(Sender: TObject; Node: TTreeNode);
var
  n: Integer;
begin
  n := NodeIndex(Node);
  if n = -1 then
  begin
    Memo1.Text := '';
    DesignBtn.Enabled := False;
    PreviewBtn.Enabled := False;
    Exit;
  end
  else if n = 11 then
  begin
    Memo1.Text := 'Demonstrates now to join several reports into one. To do this, fill ' +
       'TfrCompositeReport.Reports property by references to the other ' +
       'reports and call its ShowReport method. Reports can have different ' +
       'page sizes and orientation.';
    DesignBtn.Enabled := False;
    PreviewBtn.Enabled := True;
    Exit;
  end;
  with Form2.frReport1 do
  begin
    LoadFromFile(WPath + IntToStr(n) + '.frf');
    if Dictionary.Variables.IndexOf('Description') <> - 1 then
      Memo1.Text := Dictionary.Variables['Description'] else
      Memo1.Text := '';
    DesignBtn.Enabled := True;
    PreviewBtn.Enabled := True;
  end;
end;

procedure TForm1.DesignBtnClick(Sender: TObject);
var
  Node: TTreeNode;
begin
  Node := Tree1.Selected;
  if (Node = nil) or (NodeIndex(Node) = -1) then Exit;
  Form2.frReport1.DesignReport;
end;

procedure TForm1.PreviewBtnClick(Sender: TObject);
var
  n: Integer;
  Node: TTreeNode;
  Report: TfrReport;
begin
  Node := Tree1.Selected;
  if (Node = nil) or (NodeIndex(Node) = -1) then Exit;
  n := NodeIndex(Node);
  with Form2 do
  if n = 11 then { Composite report }
  begin
    Report := frCompositeReport1;
    frReport1.LoadFromFile(WPath + '1.frf');
    frReport2.LoadFromFile(WPath + '2.frf');
    frCompositeReport1.DoublePass := True;
    frCompositeReport1.Reports.Clear;
    frCompositeReport1.Reports.Add(frReport1);
    frCompositeReport1.Reports.Add(frReport2);
  end
  else
  begin
    Report := frReport1;
    Report.LoadFromFile(WPath + IntToStr(n) + '.frf');
    if n = 10 then { "Live" report }
    begin
      Report.OnObjectClick := frReport1ObjectClick;
      Report.OnMouseOverObject := frReport1MouseOverObject;
    end
    else
    begin
      Report.OnObjectClick := nil;
      Report.OnMouseOverObject := nil;
    end;
  end;
  if RB1.Checked then
    Report.Preview := nil else
    Report.Preview := Form3.frPreview1;
  Report.ShowReport;
  if RB2.Checked then
    Form3.ShowModal;
end;

end.
