/*
   DynAPI Distribution
   Browser Class

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.
*/
function Browser() {
	var b=navigator.appName;		
	if (b.indexOf('Netscape')!=-1) this.b="ns";
	else if ((b=="Opera") || (navigator.userAgent.indexOf("Opera")>0)) this.b = "opera";
	else if (b=="Microsoft Internet Explorer") this.b="ie";
	if (!b) alert('Unidentified browser.\nThis browser is not supported,');
	this.version=navigator.appVersion;
	this.v=parseInt(this.version);
	this.ns=(this.b=="ns" && this.v>=4);
	this.ns4=(this.b=="ns" && this.v==4);
	this.ns6=(this.b=="ns" && this.v==5);
	this.ie=(this.b=="ie" && this.v>=4);
	this.ie4=(this.version.indexOf('MSIE 4')>0);
	this.ie5=(this.version.indexOf('MSIE 5')>0);
	this.ie55=(this.version.indexOf('MSIE 5.5')>0);
	this.ie6=(this.version.indexOf('MSIE 6.0')>0);
	this.opera=(this.b=="opera");
	this.dom=(document.createElement && document.appendChild && document.getElementsByTagName)?true:false;
	this.def=(this.ie||this.dom); // most used browsers, for faster if loops
	var ua=navigator.userAgent.toLowerCase();
	if (ua.indexOf("win")>-1) this.platform="win32";
	else if (ua.indexOf("mac")>-1) this.platform="mac";
	else this.platform="other";	
}
is=new Browser();

/*
   DynAPI Distribution
   DynLayer Class

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.
*/
function DynLayer() {
	this.DynObject = DynObject;
	this.DynObject();

	var a=arguments;
	if(a[0]) this.setID(a[0]);
	this.x=a[1]||0;
	this.y=a[2]||0;
	this.w=a[3]||null;
	this.h=a[4]||null;
	this.bgColor=a[5]||null;
	this.visible=(a[6]!=false && a[6]!='hidden');
	this.z=a[7]||0;
	this.bgImage=a[8]||null;
	this.html=a[9]||null;

	this.elm=null;
	this.doc=null;
	this.css=null;
};
DynLayer.prototype = new DynObject();
DynLayer.prototype.isDynLayer = true;
DynLayer.prototype.specificCreate=function() {
	// Check for this.wasBuiltInline allows inflow layers to skip recreation onResize (NS4)
	if (!this.parent||this.elm||this.wasBuiltInline) return;
	if (is.ns6) {
		var parentElement=(this.parent.isDynLayer)?this.parent.elm:this.parent.doc.body;

		var r = parentElement.ownerDocument.createRange();
		r.setStartBefore(parentElement);
//if (tronOn) {tron('create','c<'); alert(this.getOuterHTML())}
		var ptxt = r.createContextualFragment(this.getOuterHTML());
//if (tronOn) tron('create','c>')
		parentElement.appendChild(ptxt);
		this.elm=parentElement.lastChild;
		this.css=this.elm.style;
		this.doc=this.parent.doc;
		this.css.zIndex=this.z;
	} else if (is.ie) {
		var parentElement=(this.parent.isDynLayer)?this.parent.elm:this.parent.doc.body;
		parentElement.insertAdjacentHTML("beforeEnd",this.getOuterHTML());
		this.elm=parentElement.children[parentElement.children.length-1];
		this.css=this.elm.style;
		this.doc=this.parent.doc;
	} else if (is.ns4) {
		var recycled=this.parent.doc.recycled;
		if (this.created) recycled=[];
		if (recycled && recycled.length>0) {
			this.elm=recycled[recycled.length-1];
			recycled.length--;
		} else {
			this.elm=new Layer(this.w,this.parent.elm);
			this.elm.captureEvents(Event.LOAD);
			this.elm.onload=function() {};
		}
		this.css=this.elm;
		this.doc=this.elm.document;
		this.doc.lyrobj=this;	
		if (this.w) this.css.clip.width=this.w;
		if (this.h) this.css.clip.height=this.h;
		this.elm.moveTo(this.x,this.y);
		this.doc.write(this.getInnerHTML());
		this.doc.close();
		if (this.bgColor!=null) this.setBgColor(this.bgColor);
		if (this.bgImage!=null) this.setBgImage(this.bgImage);
		if (this.clip) this.setClip(this.clip);
		this.css.zIndex=this.z;
		this.css.visibility=this.visible? "inherit" : "hide";
		for (var i=0;i<this.doc.images.length;i++) this.doc.images[i].lyrobj=this;
		for (i=0;i<this.doc.links.length;i++) this.doc.links[i].lyrobj=this;
	}
	this.frame=this.parent.frame;
	this.elm.lyrobj=this;
	this.assignChildren();
	if (this.html!=null) {
		if (this.w==null && this.getContentWidth()>0) this.setWidth(this.getContentWidth(), false);
		if (this.h==null && this.getContentHeight()>0) this.setHeight(this.getContentHeight(), false);
	}
};
DynLayer.prototype.assignChildren=function() {
	var l=this.children.length;
	if(is.def) {
		for (var i=0; i<l; i++) {
			var child=this.children[i];
			if (is.ie) var elm=this.elm.all[child.id];
			else var elm=this.doc.getElementById(child.id);
			child.elm=elm;
			child.css=child.elm.style;
			child.doc=this.doc;
			child.elm.lyrobj=child;
			child.frame=this.frame;
			child.assignChildren();
			if (child.z) child.css.zIndex=child.z;
			if (child.w==null && child.getContentWidth()>0) child.setWidth(child.getContentWidth(), false);
			if (child.h==null && child.getContentHeight()>0) child.setHeight(child.getContentHeight(), false);
		}
	} else if(is.ns4) {
		for (var i=0; i<l; i++) {
			var child=this.children[i];
			// In order to allow inline dynlayers, which are wrapped by a ILAYER. See getOuterHTML()
			var elm=this.doc.layers[child.id]||this.doc.layers[child.id+"C"].document.layers[child.id];
			child.elm=elm;
			child.css=elm;
			child.doc=elm.document;
			child.doc.lyrobj=child;
			child.elm.lyrobj=child;
			for (var j=0;j<child.doc.images.length;j++) child.doc.images[j].lyrobj=child;
			for (j=0;j<child.doc.links.length;j++) child.doc.links[j].lyrobj=child;
			child.assignChildren();
			if (child.z) child.css.zIndex=child.z;
			if (child.w==null && child.getContentWidth()>0) child.setWidth(child.getContentWidth(), false);
			if (child.h==null && child.getContentHeight()>0) child.setHeight(child.getContentHeight(), false);
		}
	}
};
//If DynDocument was included before DynLayer
if(DynDocument)DynDocument.prototype.assignChildren=DynLayer.prototype.assignChildren;

DynLayer.prototype.specificRemove=function() {
	if (is.def && this.elm) {
		this.elm.style.visibility = "hidden";
		this.elm.innerHTML = "";
		this.elm.outerHTML = "";
	}
	else if (is.ns4 && this.elm) {
		if(!this.wasBuiltInline) {
			// These can't be reused
			if (!this.parent.doc.recycled) this.parent.doc.recycled=[];
			this.parent.doc.recycled[this.parent.doc.recycled.length]=this.elm;
		}
		this.wasBuiltInline = false
		this.elm.visibility="hide";
	}
	this.frame = null;
	this.elm = null;
	this.doc = null;
	this.css = null;
};
DynLayer.prototype.getInnerHTML=function() {
	var s="";
	if (this.html!=null) s+=this.html;
	var l=this.children.length;
	for (var i=0;i<l;i++) s+=this.children[i].getOuterHTML();
	return s;
};
if (is.def) {
	DynLayer.prototype.getOuterHTML=function(inflow) {
		var s='<div id="'+this.id+'" style="';
		if (this.visible==false) s+=' visibility:hidden;';
		if (!inflow && this.x!=null) s+=' left:'+this.x+'px;';
		if (!inflow && this.y!=null) s+=' top:'+this.y+'px;';
		if (this.w!=null) s+=' width:'+this.w+'px;';
		if (this.h!=null) s+=' height:'+this.h+'px;';
		if (this.clip) s+=' clip:rect('+this.clip[0]+'px '+this.clip[1]+'px '+this.clip[2]+'px '+this.clip[3]+'px);';
		else if (this.w!=null && this.h!=null) s+=' clip:rect(0px '+this.w+'px '+this.h+'px 0px);';
		if (this.z!=null) s+=' z-index='+this.z+';';
		if (this.bgImage!=null)	s+=' background-image:url('+this.bgImage+');';
		if (this.bgColor!=null)	s+=' background-color:'+this.bgColor+';';
		if (is.ie55 && this.bgImage==null && this.html==null) s+=' background-image:url('+DynAPI.librarypath+'dynapi/images/common/transparent.gif);';
		if(!inflow) s+=' position:absolute;'; else s+=' position:relative;';
		s+=' overflow:hidden">';
		if (this.html!=null) s+=this.html;
		for (var i=0; i<this.children.length; i++) s+=this.children[i].getOuterHTML();
		s+='</div>';
		return s;

	};
} else if (is.ns4) {
	DynLayer.prototype.getOuterHTML=function(inflow) {
		var s='\n'
		if(inflow) {
			// These should not be recreated on resize
			this.wasBuiltInline = true

			s+= '<ilayer id="'+this.id+'C"' 
			if (this.w!=null) s+=' width='+this.w+'';
			if (this.h!=null) s+=' height='+this.h+'';
			s+= '">'
		}
	
		s+='<layer id="'+this.id+'"';
		if (this.visible==false) s+=' visibility="hide"';
		if (!inflow && this.x!=null) s+=' left='+this.x;
		if (!inflow && this.y!=null) s+=' top='+this.y;
		if (this.w!=null) s+=' width='+this.w;
		if (this.h!=null) s+=' height='+this.h;
		if (this.clip) s+=' clip="'+this.clip[3]+','+this.clip[0]+','+this.clip[1]+','+this.clip[2]+'"';
		else if (this.w!=null && this.h!=null) s+=' clip="0,0,'+this.w+','+this.h+'"';
		if (this.z!=null) s+=' zIndex='+this.z;
		if (this.bgImage!=null)	s+=' background="'+this.bgImage+'"';
		if (this.bgColor!=null)	s+=' bgcolor="'+this.bgColor+'"';
		s+='>';
		if (this.html!=null) s+=this.html;
		for (var i=0; i<this.children.length; i++) s+=this.children[i].getOuterHTML();
		s+='</layer>';
		
		if(inflow) s+="</ilayer>\n"
		return s;
	};
};
DynLayer.prototype._dynlayer_create = DynLayer.prototype.create;
DynLayer.prototype.create = function() {
	this._dynlayer_create();
	this.invokeEvent("resize");
};
if (is.ns) {
	DynLayer.prototype._setX=function(){ this.css.left=this.x; };
	DynLayer.prototype._setY=function(){ this.css.top=this.y; };
} else {
	DynLayer.prototype._setX=function(){ this.css.pixelLeft=this.x; };
	DynLayer.prototype._setY=function(){ this.css.pixelTop=this.y; };
};
DynLayer.prototype.moveTo=function(x,y) {
	if (x!=null) this.x=x;
	if (y!=null) this.y=y;
	if (this.css==null) return;
	this._setX();
	this._setY();
	this.invokeEvent('move');
};
DynLayer.prototype.moveBy=function(x,y) {
	this.moveTo(this.x+x,this.y+y);
};
DynLayer.prototype.setX=function(x) { this.moveTo(x,null); };
DynLayer.prototype.setY=function(y) { this.moveTo(null,y); };
DynLayer.prototype.getX=function() { return this.x; };
DynLayer.prototype.getY=function() { return this.y; };
DynLayer.prototype.getPageX=function() {
	if (this.css==null) return null;
	if (is.ns4) return this.css.pageX;
	else return (this.isChild)? this.parent.getPageX()+this.x : this.x;
};
DynLayer.prototype.getPageY=function() {
	if (this.css==null) return null;
	if (is.ns4) return this.css.pageY;
	else return (this.isChild)? this.parent.getPageY()+this.y : this.y;
};
DynLayer.prototype.setPageX=function(x) {
	if (this.css==null) return;
	if (is.ns4) this.css.pageX=x;
	if (is.ie) {
		if (this.isChild) this.setX(x-this.parent.getPageX());
		else this.setX(x);
	}
	this.getX();
	this.invokeEvent('move');
};
DynLayer.prototype.setPageY=function(y) {
	if (this.css==null) return;
	if (is.ns4) this.css.pageY=y;
	if (is.ie) {
		if (this.isChild) this.setY(y-this.parent.getPageY());
		else this.setY(y);
	}
	this.getY();
	this.invokeEvent('move');
};
DynLayer.prototype.setVisible=function(b) {
	this.visible=b;
	if (this.css==null) return;
	this.css.visibility = b? "inherit" : (is.ns4?"hide":"hidden");
};
DynLayer.prototype.getVisible=function() {
	return this.visible;
};
DynLayer.prototype.setZIndex=function(z) {
	this.z=z;
	if (this.css==null) return;
	this.css.zIndex=z;
};
DynLayer.prototype.getZIndex=function() {
	return this.z;
};
DynLayer.prototype.setBgImage=function(path) {
	this.bgImage=path;
	if (this.css==null) return;
	if (is.ns4) {
		this.elm.background.src=path;	
		if (!path) this.setBgColor(this.getBgColor());
	}
	else this.css.backgroundImage='url('+path+')';
};
DynLayer.prototype.getBgImage=function() {
	return this.bgImage;
};
DynLayer.prototype.setBgColor=function(color) {
	if (color==null) {
		if (is.ns4) color=null;
		else color='transparent';
	}
	this.bgColor=color;
	if (this.css==null) return;
	if (is.ns4) this.doc.bgColor=color;
	else this.css.backgroundColor=color;	
};
DynLayer.prototype.getBgColor=function() {
	return this.bgColor;
};
if (is.ns4) {
	DynLayer.prototype._setHTML=function(html) {
		//=====================
		return
		//=====================		
		var sTmp=(this.w==null)?'<NOBR>'+this.html+'</NOBR>':this.html;
		this.doc.open();
		this.doc.write(sTmp);
		this.doc.close();
        	for (var i=0;i<this.doc.images.length;i++) this.doc.images[i].lyrobj=this;
        	for (i=0;i<this.doc.links.length;i++) this.doc.links[i].lyrobj=this;
	}
} else if (is.ie) {
	DynLayer.prototype._setHTML=function(html) {
		if (is.platform=="mac") html+='\n';
		this.elm.innerHTML=html;
		var images = this.elm.all.tags("img");
		for (var i=0;i<images.length;i++) images[i].lyrobj=this;
	}
} else {
	DynLayer.prototype._setHTML=function(html) {
		sTmp=(this.w==null)?'<NOBR>'+this.html+'</NOBR>':this.html;
		while (this.elm.hasChildNodes()) this.elm.removeChild(this.elm.firstChild);
		var r=this.elm.ownerDocument.createRange();
		r.selectNodeContents(this.elm);
		r.collapse(true);
		var df=r.createContextualFragment(sTmp);
		this.elm.appendChild(df);
	}
};
DynLayer.prototype.setHTML=function(html,noevt) {
	this.html=html?html:'';
	if (this.css==null) return;
	if (noevt!=false) this.invokeEvent("beforeload");
	this._setHTML(html);
	if (noevt!=false) this.invokeEvent("load");
}
DynLayer.prototype.getHTML=function() {
	return this.html;
};
DynLayer.prototype.setSize = function(w,h,noevt) {
	this.w=(w==null)?this.w:w<0?0:w;
	this.h=(h==null)?this.h:h<0?0:h;
	if (this.w==null&&this.h==null) return;
	if (this.css!=null) {
		if (is.ns4) {
			this.css.clip.width = this.w;
			this.css.clip.height = this.h;
			}
		else {
			this.css.width = this.w;
			this.css.height = this.h;
			this.css.clip = 'rect(0px '+(this.w||0)+'px '+(this.h||0)+'px 0px)';
		}
	}
    if (noevt!=false) this.invokeEvent('resize');
};
DynLayer.prototype.setWidth=function(w,noevt) {
	this.w=(w==null)?this.w:w<0?0:w;
	if (this.w==null) return;
	if (this.css!=null) {
		if (is.ns4) this.css.clip.width = this.w;
		else {
			this.css.width = this.w;
			this.css.clip = 'rect(0px '+(this.w||0)+'px '+(this.h||0)+'px 0px)';
		}
	}
    if (noevt!=false) this.invokeEvent('resize');
};
DynLayer.prototype.setHeight=function(h,noevt) {
	this.h=(h==null)?this.h:h<0?0:h;
	if (this.h==null) return;
	if (this.css!=null) {
		if (is.ns4) this.css.clip.height = this.h;
		else {
			this.css.height = this.h;
			this.css.clip = 'rect(0px '+(this.w||0)+'px '+(this.h||0)+'px 0px)';
		}
	}
	if (noevt!=false) this.invokeEvent('resize');
};
DynLayer.prototype.getWidth=function() {
	return this.w;
};
DynLayer.prototype.getHeight=function() {
	return this.h;
};
DynLayer.prototype.getContentWidth=function() {
	if (this.elm==null) return 0;
	else {
		if (is.ns4) return this.doc.width;
		//if this.elm.offsetWidth/Height is not accessed, then ie5mac will return NaN.
		else if (is.ie) {
       			if (is.platform=="mac") this.elm.offsetWidth=this.elm.offsetWidth;
        		return parseInt(this.elm.scrollWidth);
		}
		else {
			var tw = this.elm.style.width;
			this.elm.style.width = "auto";
        	var w = this.elm.offsetWidth;
        	this.elm.style.width = tw;
        	return w;
		}
	};
};
DynLayer.prototype.getContentHeight=function() {
	if (this.elm==null) return 0;
	else {
		if (is.ns4) return this.doc.height;
		//if this.elm.offsetWidth/Height is not accessed, then ie5mac will return NaN.
		else if (is.ie) {
       			if (is.platform=="mac") this.elm.offsetHeight=this.elm.offsetHeight;
        		return parseInt(this.elm.scrollHeight);
			}
		else {
			var th = this.elm.style.height;
			this.elm.style.height = "auto";
	        	var h = this.elm.offsetHeight;
        		this.elm.style.height = th;
        		return h;
		}
	}
};
DynLayer.prototype.setClip=function(clip) {
	var cc=this.getClip();
	for (var i=0;i<clip.length;i++) if (clip[i]==null) clip[i]=cc[i];
	this.clip=clip;
	if (this.css==null) return;
	var c=this.css.clip;
	if (is.ns4) c.top=clip[0], c.right=clip[1], c.bottom=clip[2], c.left=clip[3];
	else this.css.clip="rect("+clip[0]+"px "+clip[1]+"px "+clip[2]+"px "+clip[3]+"px)";
};
DynLayer.prototype.getClip=function() {
	if (this.css==null || !this.css.clip) return [0,0,0,0];
	var c = this.css.clip;
	if (c) {
		if (is.ns4) return [c.top,c.right,c.bottom,c.left];
		if (c.indexOf("rect(")>-1) {
			c=c.split("rect(")[1].split(")")[0].split("px");
			for (var i=0;i<c.length;i++) c[i]=parseInt(c[i]);
			return [c[0],c[1],c[2],c[3]];
		}
		else return [0,this.w,this.h,0];
	}
};

/*
   DynAPI Distribution
   DynDocument Class

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.
*/
DynDocument = function(frame) {
	this.DynObject = DynObject
	this.DynObject()
	this.elm = frame;
	this.doc = frame.document;
	this.frame = frame;
	this.fgColor = this.doc.fgColor||'';
	this.bgColor = this.doc.bgColor||'';
	this.elm.lyrobj=this;
	this.doc.lyrobj=this;
}
DynDocument.prototype = new DynObject();
DynDocument.prototype.isDynDocument = true;
DynDocument.prototype.getBgColor = function() {
	return this.bgColor;
};
DynDocument.prototype.specificCreate=function() {
	this.findDimensions();
	// Following Silly Patch allows sharing of assignChildren() between DynDocument and DynLayer (IE only)
	if(is.ie) this.elm.all = this.doc.all
	this.assignChildren();
	DynAPI.addResizeFunction(this+".resizeHandler()");
};
DynDocument.prototype._Old_addChild=DynDocument.prototype.addChild;
DynDocument.prototype.addChild=function(c) {
//if (tronOn) tron('addChild','a<')		
	if(!this.created) this.doc.write(c.getOuterHTML());
	return this._Old_addChild(c);
//if (tronOn) tron('addChild','a>')		
};
DynDocument.prototype.addInflowChild=function(c) {
	if(!this.created) this.doc.write(c.getOuterHTML(true));
	return this._Old_addChild(c);
};
DynDocument.prototype.specificRemove=function() {
	this.elm=null;
	this.doc=null;
	this.frame=null;
};
DynDocument.prototype.getX=function() { return 0; };
DynDocument.prototype.getY=function() { return 0; };
DynDocument.prototype.getPageX=function() { return 0; };
DynDocument.prototype.getPageY=function() { return 0; };
DynDocument.prototype.getWidth = function() {
	if (!this.w) this.findDimensions();
	return this.w;
};
DynDocument.prototype.getHeight = function() {
	if (!this.h) this.findDimensions();
	return this.h;
};
DynDocument.prototype.findDimensions = function() {
	this.w=(is.ns||is.opera)? this.elm.innerWidth : this.doc.body.clientWidth;
	this.h=(is.ns||is.opera)? this.elm.innerHeight : this.doc.body.clientHeight;
	if (is.ns && this.frame.parent.frames.length>1) {
		if (is.ns4) { this.w=this.w+4; this.h=this.h+4; }
		else this.h=this.h-2;
	};
};
DynDocument.prototype.setBgColor = function(color) {
	if (color == null) color='';
	if (is.ns4 && color == '') color = '#ffffff';
	this.bgColor = color;
	this.doc.bgColor = color;
};
DynDocument.prototype.setFgColor = function(color) {
	if (color == null) color='';
	if (is.ns4 && color == '') color='#ffffff';
	this.fgColor = color;
	this.doc.fgColor = color;
};
DynDocument.prototype.load = function(path) {
	this.doc.location = path;
};
DynDocument.prototype.resizeHandler=function() {
	var w=this.w;
	var h=this.h;
	this.findDimensions();
	if (is.ns4&&((this.w!=w)||(this.h!=h)))	{
		for (var i=0;i<this.children.length;i++) {
			this.children[i].elm=null;
			this.children[i].specificCreate();
		}
	}
};
//If DynLayer was included before DynDocument
if(DynLayer)DynDocument.prototype.assignChildren=DynLayer.prototype.assignChildren;

DynAPI.document = DynAPI.addChild(new DynDocument(self));
DynAPI.document.all = DynObject.all;

/*
   DynAPI Distribution
   Advanced Event object. Generic Event Listeners

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.
*/
DynEvent=function(type,src,target) {
	this.type=type;
	this.src=src;
	this.target=target;
	this.bubble=false;
};
DynEvent.prototype.setBubble=function(b) {this.bubble=b};
DynEvent.prototype.getType=function() {return this.type};
DynEvent.prototype.getSource=function() {return this.src};
DynEvent.prototype.getTarget=function() {return this.target};
DynEvent.prototype.preBubbleCode = function() {};

EventListener = function(target) { this.target=target };
EventListener.prototype.handleEvent=function(type,e,args) {
	if(this["on"+type]) this["on"+type](e,args);
};
// Extend DynObject to support EventListeners
DynObject.prototype.addEventListener=function(listener) {
	//removed to counter inheritance bug (#425789)
	//if(!this.eventListeners) { this.eventListeners = []; }
	this.hasEventListeners = true;
	for (var i=0;i<this.eventListeners.length;i++) if (this.eventListeners[i]==listener) return;
	this.eventListeners[this.eventListeners.length]=listener;
}
DynObject.prototype.removeEventListener=function(listener) {
	Methods.removeFromArray(this.eventListeners, listener, false);
	if(this.eventListeners.length==0) {
		this.hasEventListeners=false;
	}
}
DynObject.prototype.removeAllEventListeners=function() {
	if (!this.hasEventListeners) return;
	this.eventListeners=[];
	this.hasEventListeners=false;
}
DynObject.prototype.invokeEvent=function(type,e,args) {
	if (!e) e=new DynEvent(type,this);
	if (this.hasEventListeners) for(var i=0;i<this.eventListeners.length;i++) {
		e.target=this.eventListeners[i].target;
		this.eventListeners[i].handleEvent(type,e,args);
	}
	if(e.bubble && this.parent) {
		e.preBubbleCode();
		e.src = this.parent;
		this.parent.invokeEvent(type,e,args);
	}
}
//removed to counter inheritance bug (#425789)
//DynObject.prototype.eventListeners = null;
DynObject.prototype._listeners_del = DynObject.prototype.del
DynObject.prototype.del = function() {
    this.removeAllEventListeners();
    this._listeners_del();
};

/*
   DynAPI Distribution
   Event Classes

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.

   Requirements:
	dynapi.api [dynlayer, dyndocument, browser]
	dynapi.event [listeners]

*/
// The mouseEvent object
DynMouseEvent=function(old) {
	this.DynEvent=DynEvent;
	this.DynEvent();
	// Copy properties from given event, if any
	if (old) for(var i in old) this[i]=old[i]
};
DynMouseEvent.prototype=new DynEvent();
DynMouseEvent.prototype.preBubbleCode=function() {
	this.x+=this.src.x;
	this.y+=this.src.y;
};
DynMouseEvent.prototype.getX=function() {return this.x};
DynMouseEvent.prototype.getY=function() {return this.y};
DynMouseEvent.prototype.getPageX=function() {return this.pageX};
DynMouseEvent.prototype.getPageY=function() {return this.pageY};
DynMouseEvent.prototype.cancelBrowserEvent=function() {
	this.browserReturn=false
	var evt = DynMouseEvent._e
	if(!is.ns4 || evt.type != "mousedown") return
	// If we cancel a mousedown in NS4. We must remember it so a click event is manually
	// generated afterwards
	var realsrc = evt.src
	realsrc.ns4clktimer = true
	setTimeout(realsrc+'.ns4clktimer=false',300);
};
// This is THE event.
DynMouseEvent._e=new DynMouseEvent()
// If this is true, then mouseups always happen where the mousedown happened ( true is recommended )
DynMouseEvent.forceMouseUp = true

DynMouseEvent.EventMethod=function(e) {
	var dynobject=this.lyrobj;
	if(is.def) {
		if (is.ie) var e=dynobject.frame.event
        	e.cancelBubble=true;

		if (DynAPI.wasDragging && e.type=="click") {
			DynAPI.wasDragging=false;
			return false;
		}
	}

	// Get the real source for the event
	if(is.def) var realsrc = Methods.getContainerLayerOf(is.ie?e.srcElement:e.target) || dynobject
	else if(is.ns4) var realsrc=e.target.lyrobj || dynobject

	// Now 'realsrc' should point to the DynLayer object where the event initially was triggered
	if (!realsrc) { alert('Error in MouseEvents'); return false; }

	if(is.def) {
		if(e.type=="mouseout" && realsrc.isParentOf(Methods.getContainerLayerOf(is.ie?e.toElement:e.relatedTarget),true)) return true;
		if(e.type=="mouseover" && realsrc.isParentOf(Methods.getContainerLayerOf(is.ie?e.fromElement:e.relatedTarget),true)) return true;
	}
	var evt=DynMouseEvent._e
	// Step one: properties common to all DynEvents
	var type = e.type
	evt.type = type;
	evt.src=realsrc;
	evt.browserReturn=true;
	evt.bubble=true;

	// Step two: mouse coordinate properties
	if (is.ns4 && type=='mouseover') {
		// debugging for NS4 mouseover event
		evt.pageX=evt.pageX;
		evt.pageY=evt.pageY;
		evt.x=evt.pageX-evt.src.getPageX()
		evt.y=evt.pageY-evt.src.getPageY()
	} else {
		// standard DynAPI coordinate calculation
		evt.pageX=is.ie?e.x+document.body.scrollLeft:e.pageX;
		evt.pageY=is.ie?e.y+document.body.scrollTop:e.pageY;
		evt.x=is.ie?evt.pageX-evt.src.getPageX():e.layerX
		evt.y=is.ie?evt.pageY-evt.src.getPageY():e.layerY
	}

	// Step three: mouse buttons
	var b=is.ie?e.button:e.which;
	if (is.ie){
		if (b==2) b=3;
		else if (b==4) b=2;
	};
	evt.button=b;
	if (evt.button==2 && (type=='mousedown' || type=='mouseup' || type=='mouseclick')) type=evt.type='md'+type;
	if (evt.button==3 && (type=='mousedown' || type=='mouseup' || type=='mouseclick')) type=evt.type='rt'+type;

	// Step four: modifiers
	if (is.def){
		evt.altKey=(e.altKey||e.altLeft);
		evt.ctrlKey=(e.ctrlKey||e.ctrlLeft);
		evt.shiftKey=(e.shiftKey||e.shiftLeft);
	}
	else if (is.ns4){
		var m=e.modifiers;
		evt.altKey=(m==1||m==3||m==5||m==7);
		evt.ctrlKey=(m==2||m==3||m==6||m==7);
		evt.shiftKey=(m==4||m==5||m==6||m==7);
	}

	// Step five: reference to the original event
	evt.orig=e

	if(is.def) {
		if (evt.type=='mouseover') {
			var fromL = Methods.getContainerLayerOf(is.ie?e.fromElement:e.relatedTarget)
			if(fromL && fromL.isChildOf(realsrc.parent,true)) evt.setBubble(false);
		}
		if (evt.type=='mouseout') {
			var toL = Methods.getContainerLayerOf(is.ie?e.toElement:e.relatedTarget)
			if(toL && toL.isChildOf(realsrc.parent,true)) evt.setBubble(false);
		}
	}
	else if(is.ns4 && (e.type=="mouseover" || e.type=="mouseout")) evt.setBubble(false);

	// This forces mouseUps to happen in the same place where mousedowns took place
	if (DynMouseEvent.forceMouseUp && is.def) {
		if (e.type=='mousedown') DynMouseEvent.focus=realsrc;
		else if (e.type=='mouseup' && DynMouseEvent.focus!=null)
		evt.src=realsrc=DynMouseEvent.focus;
	};
//==================================================================================================================
	if (is.ns4 && e.type.toString() == 'click') {		
		strHRef=e.target.toString()		
		if (strHRef.indexOf('checkbox') == -1 && strHRef.indexOf('radio') == -1) {		
			x=routeEvent(e)
			if (x) { // = 'NS layer handled' or back from DFrame
				if (realsrc.isDFrame) {
					return true //DFrame return true to DynAPI.document so that DynAPI.document will return false 
				} else {
					return false //DynAPI.document return false so that the link is not followed
				}
			} else {
				
			}	
		}
	} else if (is.ie) evt.orgSrc = e.srcElement
//==================================================================================================================

	// Invoke the event
	realsrc.invokeEvent(type,evt);
//==================================================================================================================
	if (evt.button==3) return false;
//==================================================================================================================

	// Other checks. NS4 mainly
	if (is.ns4) {
		// See cancelBrowserEvent()
		if (realsrc.ns4clktimer && type=="mouseup") {
			evt.type=type="click";
			evt.bubble = true;
			realsrc.invokeEvent(type,evt);
		}
		// Linux platforms' dblclicks
		if (is.platform=="other" && type=="mousedown") {
			if (realsrc.dbltimer!=null) {
				evt.type=type="dblclick";
				evt.bubble = true;
				realsrc.invokeEvent(type,evt);
			}
			else realsrc.dbltimer=setTimeout(realsrc+'.dbltimer=null',300);
		}

	        // Click on links and form elements
	        if(e && e.target.handleEvent && e.target!=this && (e.target.handleEvent(e) == false)) evt.browserReturn = false;
        }
        else {
                if(e.preventDefault && !evt.browserReturn) e.preventDefault();
		if (evt.type=='rtmouseup') document.oncontextmenu=evt.browserReturn ? null : DynAPI.FalseFunction;
		else if (evt.type=='mousedown') document.onselectstart=evt.browserReturn ? null : DynAPI.FalseFunction; 
        }
        // If Internet Explorer AND evt.browserReturn is false,
        // OR _any other browser_, THEN return evt.browserReturn.
        // [So in IE either return false or nothing at all. This allows user
        // code (<A onclick> for example) to set e.returnValue (in IE) or return
        // true/false. If evt.browserReturn is false it means we're to
        // disable the default action, no matter what.]
        if(!is.ie || evt.browserReturn==false) return evt.browserReturn;
}
DynAPI.FalseFunction = function() { return false }
// Extend DynDocument to capture its events
DynDocument.prototype.captureMouseEvents = function() {
	if(is.def&&!is.ie) {
		this.doc.addEventListener("mousemove",DynMouseEvent.EventMethod,false)
		this.doc.addEventListener("mousedown",DynMouseEvent.EventMethod,false)
		this.doc.addEventListener("mouseup",DynMouseEvent.EventMethod,false)
		this.doc.addEventListener("mouseover",DynMouseEvent.EventMethod,false)
		this.doc.addEventListener("mouseout",DynMouseEvent.EventMethod,false)
		this.doc.addEventListener("click",DynMouseEvent.EventMethod,false)
		this.doc.addEventListener("dblclick",DynMouseEvent.EventMethod,false)
	}
	else {
		if (is.ns4) this.doc.captureEvents(Event.MOUSEMOVE | Event.MOUSEOVER | Event.MOUSEOUT | Event.MOUSEDOWN | Event.MOUSEUP | Event.CLICK | Event.DBLCLICK);
		this.doc.onmouseover=this.doc.onmouseout=this.doc.onmousemove=this.doc.onmousedown=this.doc.onmouseup=this.doc.onclick=this.doc.ondblclick=DynMouseEvent.EventMethod;
	}
}
DynDocument.prototype.releaseMouseEvents=function() {
	if(is.def&&!is.ie) {
		this.doc.removeEventListener("mousemove",DynMouseEvent.EventMethod,false)
		this.doc.removeEventListener("mousedown",DynMouseEvent.EventMethod,false)
		this.doc.removeEventListener("mouseup",DynMouseEvent.EventMethod,false)
		this.doc.removeEventListener("mouseover",DynMouseEvent.EventMethod,false)
		this.doc.removeEventListener("mouseout",DynMouseEvent.EventMethod,false)
		this.doc.removeEventListener("click",DynMouseEvent.EventMethod,false)
		this.doc.removeEventListener("dblclick",DynMouseEvent.EventMethod,false)
	}
	else {
		if (is.ns4) this.doc.releaseEvents(Event.MOUSEMOVE | Event.MOUSEOVER | Event.MOUSEOUT | Event.MOUSEDOWN | Event.MOUSEUP | Event.CLICK | Event.DBLCLICK);
		this.doc.onmouseover=this.doc.onmouseout=this.doc.onmousemove=this.doc.onmousedown=this.doc.onmouseup=this.doc.onclick=this.doc.ondblclick=null
	}
}
// DynDocument Specific
DynDocument.prototype._OldM_specificCreate = DynDocument.prototype.specificCreate
DynDocument.prototype.specificCreate = function() {
	this._OldM_specificCreate()
	this.captureMouseEvents()
}
DynDocument.prototype._OldM_specificRemove = DynDocument.prototype.specificRemove
DynDocument.prototype.specificRemove = function() {
	this.releaseMouseEvents()
	this._OldM_specificRemove()
}

/*
   DynAPI Distribution
   DragEvent Class

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.
*/

// DragEvent object
function DragEvent(type,src) {
	this.DynEvent = DynEvent
	this.DynEvent()
	this.dragEnabled=true;
}
DragEvent.prototype = new DynEvent()
DragEvent.prototype.getX=function() {return this.x;};
DragEvent.prototype.getY=function() {return this.y;};
DragEvent.prototype.getPageX=function() {return this.pageX;};
DragEvent.prototype.getPageY=function() {return this.pageY;};
DragEvent.prototype.cancelDrag=function() {this.dragEnabled=false;};
DragEvent.dragPlay=0;
DragEvent.dragevent=new DragEvent();

DragEvent.lyrListener=new EventListener();
DragEvent.lyrListener.onmousedown=function(e) {
	//fix to allow forms in draggable layers to select text.
	if (is.def&&e.orig) {
		//var tn = is.ie? e.orig.srcElement.tagName : e.orig.target.tagName;
		//if (tn=="INPUT" || tn=="TEXTAREA") return;
	}

	e.cancelBrowserEvent();
	if (DragEvent.dragevent.src) return;

	var lyr=e.getSource();
	if (is.ie) lyr.doc.body.onselectstart = function() { return false; }

	// Initialize dragEvent object
	var de=DragEvent.dragevent;
	de.type="dragstart"
	de.src=lyr

	// Set properties
	de.isDragging=false;
	de.x=e.getPageX()-e.getSource().getPageX();
	de.y=e.getPageY()-e.getSource().getPageY();
	de.pageX=e.getPageX();
	de.pageY=e.getPageY();
	de.parentPageX=lyr.parent.getPageX();
	de.parentPageY=lyr.parent.getPageY();
};
DragEvent.docListener=new EventListener();
DragEvent.docListener.onmousemove=function(e) {
	// Get, if any, the currently drag in process and the layer. If none, return
	var de = DragEvent.dragevent;
	if (!de) return;
	var lyr = de.src;
	if (!lyr) return;
	// Also, if the dragged layer is not in this document, return
	if(lyr.frame&&lyr.frame.lyrobj!=e.getSource()) return

	if(!de.isDragging)
	// Detect if we should start the drag
	if(DragEvent.dragPlay==0 || (Math.abs(de.pageX-e.getPageX())-DragEvent.dragPlay>0) || (Math.abs(de.pageY-e.getPageY())-DragEvent.dragPlay>0)) {
		de.isDragging=true;
		de.src.invokeEvent("dragstart",de);
		e.setBubble(de.bubble);
	}
	if (!de.isDragging) return;
	else if (!de.dragEnabled) {
		// This allows 'cancelDrag' method to fire the mouseUp as if had been released by the user
		lyr.invokeEvent("mouseup");
		return;
	}

	// Properties
	de.type="dragmove";
	de.pageX=e.getPageX();
	de.pageY=e.getPageY();
	var x=de.pageX-de.parentPageX-de.x;
	var y=de.pageY-de.parentPageY-de.y;

	// Respect boundary, if any
	if (lyr.dragBoundary) {
		var dB=lyr.dragBoundary;
		if (dB=="parent") {
			var b=lyr.parent.getHeight();
			var r=lyr.parent.getWidth();
			var l=0;
			var t=0;
		} else {
			var b=dB[2];
			var r=dB[1];
			var l=dB[3];
			var t=dB[0];
		}
		var w=lyr.w;
		var h=lyr.h;
		if (x<l) x=l;
		else if (x+w>r) x=r-w;
		if (y<t) y=t;
		else if (y+h>b) y=b-h;
	}

	// Move dragged layer
	lyr.moveTo(x,y);
	lyr.invokeEvent("dragmove",de);
	e.cancelBrowserEvent();
	e.setBubble(de.bubble);
};
DragEvent.docListener.onmouseup=function(e) {
	// Get, if any, the currently drag in process and the layer. If none, return
	var de=DragEvent.dragevent;
	if (!de) return;
	var lyr=de.src;
	if (!lyr) return;

	if (!de.isDragging) {
	    	de.type="dragend";
    		de.src=null;
    		e.setBubble(true);
		return;
	}
	if (is.ie) lyr.doc.body.onselectstart = null;

	//refresh screen to display form objects in draggable layers
	if(lyr.doc.forms.length>0){
		if (is.ie && is.platform=="mac") document.body.className = document.body.className;
		else if (is.ns4 && is.platform=="win32") document.bgColor = document.bgColor;
	}

	// Avoid click for the dragged layer ( with MouseEvent addition )
	if (is.def) DynAPI.wasDragging=true;
	if (lyr.parent.DragDrop) lyr.parent.DragDrop(lyr,e);
	// Properties for the event
	de.type="dragend";
	de.isDragging=false;
	lyr.invokeEvent("dragend",de);

	// Clean drag stuff
	de.src=null;
	e.cancelBrowserEvent();
	e.setBubble(de.bubble);
};
DragEvent.setDragBoundary=function(dlyr,t,r,b,l) {
	var a=arguments;
	if (a.length==0) return;
	if (a.length==1) dlyr.dragBoundary="parent";
	else if (a.length==5) dlyr.dragBoundary=new Array(t,r,b,l);
};
DragEvent.enableDragEvents=function(dlyr,doc) {
	if (!dlyr.isDynLayer) return;
	dlyr.addEventListener(DragEvent.lyrListener);
	var dyndoc=doc||DynAPI.document;
	if (dlyr.frame) dyndoc=dlyr.frame.lyrobj;
	dyndoc.addEventListener(DragEvent.docListener);
	dyndoc.dragEnabled=true;
};
DragEvent.disableDragEvents=function() {
	for (var i=0;i<arguments.length;i++) {
		var lyr=arguments[i];
		lyr.removeEventListener(DragEvent.lyrListener);
	}
};
/*
   DynAPI Distribution
   Key Event Extensions by Henrik Vglin (hvaglin@yahoo.com)

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.

   Requirements:
	dynapi.api [dynlayer, dyndocument, browser]
	dynapi.event [listeners]
*/
DynKeyEvent=function() {
	this.DynEvent=DynEvent;
	this.DynEvent();
};
DynKeyEvent.prototype=new DynEvent();
DynKeyEvent.prototype.getKey=function() {
	return this.charKey;
};
DynKeyEvent.prototype.bubbleEvent=function() {
	if (!this.bubble||this.src.isDynDocument||this.src.parent==null) return;
	this.src=this.src.parent;
	this.src.invokeEvent(this.type,this);
	this.bubbleEvent();
	return;
};
DynKeyEvent.EventMethod = function(e) {
	var dynobject=this.lyrobj;
	if(is.def) {
		if (is.ie) var e=dynobject.frame.event;
		else if (e.eventPhase!=3) return false;
	        e.cancelBubble=true;
	}
	if(is.def) var realsrc = Methods.getContainerLayerOf(is.ie?e.srcElement:e.target)||dynobject;
	else if(is.ns4) var realsrc=e.target.lyrobj||dynobject;

	if (!realsrc) { alert('Error in MouseEvents'); return true; }

	var evt=DynKeyEvent._e;
	evt.type=e.type;
	evt.src=realsrc;
	evt.browserReturn=true;
	evt.bubble=true;
	evt.which=(is.ns4)?e.which:e.keyCode;
	var curKey = String.fromCharCode(evt.which).toLowerCase();

	if (((curKey>='a')&&(curKey<='z'))||((curKey>='0')&&(curKey<='9'))) evt.charKey=curKey;
	else evt.charKey=null;

	evt.ctrlKey=(is.ns4)?(e.modifiers & Event.CONTROL_MASK):(e.ctrlKey||e.ctrlLeft||e.keyCode==17);
	evt.shiftKey=(is.ns4)?(e.modifiers & Event.SHIFT_MASK):(e.shiftKey||e.shiftLeft||e.keyCode==16);
	evt.orig=e;

	realsrc.invokeEvent(evt.type,evt);
	evt.bubbleEvent();
	return evt.browserReturn;
};
DynKeyEvent._e=new DynKeyEvent();
DynDocument.prototype.captureKeyEvents=function() {
	if(is.def&&!is.ie) {
		this.doc.addEventListener("keydown",DynKeyEvent.EventMethod,false)
		this.doc.addEventListener("keyup",DynKeyEvent.EventMethod,false)
		this.doc.addEventListener("keypress",DynKeyEvent.EventMethod,false)
	}
	else {
		if (is.ns4) this.doc.captureEvents(Event.KEYPRESS | Event.KEYDOWN | Event.KEYUP);
		this.doc.onkeypress=this.doc.onkeydown=this.doc.onkeyup=DynKeyEvent.EventMethod;
	};
};
DynDocument.prototype.releaseKeyEvents=function() {
	if(is.def&&!is.ie) {
		this.doc.removeEventListener("keydown",DynKeyEvent.EventMethod,false)
		this.doc.removeEventListener("keyup",DynKeyEvent.EventMethod,false)
		this.doc.removeEventListener("keypress",DynKeyEvent.EventMethod,false)
	}
	else {
		if (is.ns4) this.doc.releaseEvents(Event.KEYPRESS | Event.KEYDOWN | Event.KEYUP);
		this.doc.onkeypress=this.doc.onkeydown=this.doc.onkeyup=null;
	};
};
// DynDocument specific
DynDocument.prototype._OldK_specificCreate = DynDocument.prototype.specificCreate;
DynDocument.prototype.specificCreate = function() {
	this._OldK_specificCreate();
	this.captureKeyEvents();
};
DynDocument.prototype._OldK_specificRemove = DynDocument.prototype.specificRemove;
DynDocument.prototype.specificRemove = function() {
	this.releaseKeyEvents();
	this._OldK_specificCreate();
};

/*
   DynAPI Distribution
   DynImage Class

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.

   Requirements:
	dynapi.api [dynlayer, dyndocument, browser, events]
*/
function DynImage() {
	this.DynLayer = DynLayer;
	this.DynLayer();

	if (typeof(arguments[0])=="string") this.setImageSrc(arguments[0]);
	else if (typeof(arguments[0])=="object") this.setImage(arguments[0]);
	else this.img = null;
	if (this.img && this.img.dynimages) {
		this.img.dynimages[this.img.dynimages.length]=this;
  		this.imgresize=true;
	}
	this.addEventListener(DynImage.listener);
};
DynImage.prototype = new DynLayer;

DynImage.listener = new EventListener();

DynImage.listener.onprecreate = function(e) {
	var o = e.getSource();
	if (o.w!=null && o.h!=null) {
		o.setImage(o.img,true);
	}
};

DynImage.listener.onresize = function (e) {
	var o = e.getSource();
	if (o.created) {
		if (o.img) {
			o.setImage(o.img,true);
		}
	}
};

// this is an optional method that only effects the behaviour on subsequent image changes.
// During the first creation of DynImage if no w/h is set it will automatically resize
// during creation regardless of whether this value is set or not (that is a function of the DynLayer).
// If you setAutoResize(true) when you change images after creation it will resize itself again.
DynImage.prototype.setAutoResize = function (b) {
	this.autoResize = b;
	if (this.created) this.setImage(this.img);
};

DynImage.prototype.setImage = function (imgObject,bRedraw) {
	if (!imgObject) {
		return;
	}
	this.img = imgObject;

	if (this.created && this.autoResize && !bRedraw) {
		if (this.img.width!=this.w && this.img.height!=this.h) {
			this.setSize(this.img.width, this.img.height, false);
			bRedraw = true;
		}
	}

//=================
	if (!this.created || bRedraw) {
		var wh = ((this.w!=null && this.h!=null)) ? ' width='+this.w+' height='+this.h : '';
		if (is.ns4) {
			this.setHTML('<img src="'+imgObject.src+'"'+wh+' border=0>');
		} else this.setHTML('<img name="'+this.id+'Image" src="'+imgObject.src+'"'+wh+' border=0>');
	}
	else if (this.created) {
		if (is.ns4) this.doc.images[0].src = this.img.src;
		else this.doc.images[this.id+'Image'].src = this.img.src;		
	}
//====================	
};
DynImage.prototype.getImage = function (imgObject) {
	return this.img;
};
DynImage.prototype.setImageSrc = function (imgsrc) {
	if (imgsrc) {
		this.setImage(DynImage.getImage(imgsrc));
	}
};
DynImage.prototype.getImageSrc = function () {
	return this.img? this.img.src : null;
};

// Functions

DynImage.loadimages=[];
DynImage.getImage=function(src,w,h) {
	for (var i=0;i<DynImage.loadimages.length;i++) {
		if (DynImage.loadimages[i].img.origsrc==src || DynImage.loadimages[i].img.src==src)
			return DynImage.loadimages[i].img;
	}
	DynImage.loadimages[i] = {};
	if (w&&h) DynImage.loadimages[i].img = new Image(w,h);
	else DynImage.loadimages[i].img = new Image();
	DynImage.loadimages[i].img.src=DynImage.loadimages[i].img.origsrc=src;
	DynImage.loadimages[i].img.dynimages=[];
	if (DynAPI.loaded && !DynImage.timerId) DynImage.loaderStart();
	return DynImage.loadimages[i].img;
};
DynImage.loaderStart=function() {
	DynImage.timerId=setTimeout('DynImage.loadercheck()',50);
	if (DynImage.onLoaderStart) DynImage.onLoaderStart();
};
DynImage.loadercheck=function() {
	DynImage.ItemsDone=0;
	var max=DynImage.loadimages.length;
	for (var i=0; i<max; i++) if (DynImage.loadimages[i].img.complete) DynImage.ItemsDone+=1;
	if (DynImage.ItemsDone<max) {
		if (DynImage.onLoading) DynImage.onLoading();
		DynImage.timerId=setTimeout('DynImage.loadercheck()',25);
	}
	else {
	for (var i=0; i<DynImage.loadimages.length; i++) {
    		if (DynImage.loadimages[i].img.dynimages) {
				if (is.def&&(!is.ie||(is.ie&&is.platform=="mac"))) {
					DynImage.loadimages[i].img.width = DynImage.loadimages[i].img.w;
					DynImage.loadimages[i].img.height = DynImage.loadimages[i].img.h;
				}
				var dlen=DynImage.loadimages[i].img.dynimages.length;
    	  		for (var j=dlen-1;j>=0;j--){
    	    			if (DynImage.loadimages[i].img.dynimages[j].imgresize) {
    	    				DynImage.loadimages[i].img.dynimages[j].setSize(DynImage.loadimages[i].img.width,DynImage.loadimages[i].img.height,false);
							DynImage.loadimages[i].img.dynimages[j].imgresize=false;
							DynImage.loadimages[i].img.dynimages[j]=null;
						}
          			}
          		DynImage.loadimages[i].img.dynimages=null;
			}
		}
		if (DynImage.onLoaderDone) DynImage.onLoaderDone();
		DynImage.timerId=null;
	}
};
DynAPI.addLoadFunction("DynImage.loaderStart()")

/*
   DynAPI Distribution
   Label Class

   The DynAPI Distribution is distributed under the terms of the GNU LGPL license.

   Requirements:
	dynapi.api [dynlayer, dyndocument, browser, events]
*/
function Label(text) {
	this.DynLayer = DynLayer;
	this.DynLayer();
	this.wrap = false;
	this.padding = 0;
	this.align = 'left';
	this.font = {};
	this.font.family="arial";
	this.font.size="2";
	this.font.color="#000000";
	this.pWidth = false;
	this.pHeight = false;
	this.selectable	= true
	this.setText(text);
	this.first = true

	var listener = new EventListener(this);
	listener.oncreate = function(e)	{
		var o = e.target;
		if (!o.selectable) {
			if (o.created&&(is.def)) {
				o.css.cursor="default";
			}
		}
	};
	listener.onresize = function(e) {
		var o = e.target;
		if (o.created) {
			if(is.ns4&&o.wrap) o.setText(o.text)
			o.pack((o.getWidth()==null)||(o.wrap&&o.pWidth),o.getHeight()==null||o.pHeight)
		}
	};
	this.addEventListener(listener);
	this.selectListener = new EventListener(this);
	this.selectListener.onmousedown = function(e) {
		e.cancelBrowserEvent();
	};
	this.selectListener.onmousemove = function(e) {
		e.cancelBrowserEvent();
	};
	this.selectListener.onmouseup = function(e) {
		e.cancelBrowserEvent();
	};
};
Label.prototype = new DynLayer();
Label.prototype.setText = function(text) {
	this.text = text || '';
	var styled = '<font size="'+this.font.size+'" face="'+this.font.family+'" color="'+this.font.color+'">'+this.text+'</font>';
	if (this.font.bold) styled = '<b>'+styled+'</b>';
	if (this.font.italic) styled = '<i>'+styled+'</i>';
	
	var width = this.wrap? 'width='+this.w : '';
	var wrap = this.wrap? '':'nowrap';
	this.textFull = '<table '+width+' cellpadding='+this.padding+' cellspacing=0 border=0><tr><td align="'+this.align+'" '+wrap+'>'+styled+'</td></tr></table>';
	this.setHTML(this.textFull);
};
Label.prototype.setFontFamily = function(f,noevt) {
	this.font.family = f;
	if (noevt!=false) this.setText(this.text);
};
Label.prototype.setFontSize = function(s,noevt) {
	this.font.size = s;
	if (noevt!=false) this.setText(this.text);
};
Label.prototype.setFontBold = function(b,noevt) {
	this.font.bold = b;
	if (noevt!=false) this.setText(this.text);
};
Label.prototype.setFontItalic = function(b,noevt) {
	this.font.italic = b;
	if (noevt!=false) this.setText(this.text);
};
Label.prototype.setFontColor = function(b,noevt) {
	this.font.color = b;
	if (noevt!=false) this.setText(this.text);
};
Label.prototype.getText = function() {
	return this.text;
};
Label.prototype.setWrap = function(wrap,noevt) {
	this.wrap = wrap;
	if (noevt!=false) this.setText(this.text);
};
Label.prototype.setPadding = function(p,noevt) {
	this.padding = p;
	if (noevt!=false) this.setText(this.text);
};
Label.prototype.setAlignment = function(a,noevt) {
	this.align = a;
	if (noevt!=false) this.setText(this.text);
};
Label.prototype.setSelectable = function(b) {
	this.selectable=b
	if (b==false) {
		this.addEventListener(this.selectListener);
		if (this.created&&(is.ie||is.dom)) {
			this.css.cursor="default";
		}
	}
	else {
		this.removeEventListener(this.selectListener);
		if (this.created&&(is.ie||is.dom)) {
			this.css.cursor="text";
		}
	}
};
Label.prototype.packWidth = function() {
	this.pack(true,false);
};
Label.prototype.packHeight = function() {
	this.pack(false,true);
};
Label.prototype.pack = function(bWidth,bHeight) {
	if (!bWidth && bWidth!=false) bWidth=true;
	if (!bHeight && bHeight!=false) bHeight=true;
	this.pWidth = bWidth;
	this.pHeight = bHeight;
	var w = bWidth? this.getContentWidth() : this.w;
//alert('in pack: '+this.text+Rc+bWidth+Rc+w+Rc+this.w)	
	var h = bHeight? this.getContentHeight() : this.h;
	//alert(this.created+' '+w+' '+h)
	if (this.created) this.setSize(w,h,false);
};

