/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSGStateA.h
*********************************************************************/

#ifndef VSGStateA_H
#define VSGStateA_H
#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */

#include "VSTypes.h"

#ifdef __cplusplus
extern "C"{
#endif
	/* Converting CIE-based colors to device colors  */
    typedef enum {
		ReIntAbsoluteColormetric,    /* Colors are represented solely with respect to the light source; no
									 correction is made for the output mediums white point (such as
									 the color of unprinted paper). */
		ReIntRelativeColorMetrics,   /* Colors are represented with respect to the combination of the
								 	 light source and the output mediums white point (such as the
									 color of unprinted paper).    */
        ReIntSaturation,             /* Colors are represented in a manner that preserves or 
									 emphasizes saturation. */
        ReIntPerceptual              /* Colors are represented in a manner that provides a pleasing 
									 perceptual appearance. */
    } PDFRenderingIntents;
    
	/* Blending mode */
    typedef enum {
        blmoNormal,                  /* Selects the source color, ignoring the backdrop */ 
        blmoMultiply,                /* Multiplies the backdrop and source color values */ 
		blmoScreen,                  /* Multiplies the complements of the backdrop and source color
									 values, then complements the result*/
        blmoOverlay,                 /* Multiplies or screens the colors, depending on the backdrop color. */
        blmoDarken,                  /* Selects the darker of the backdrop and source colors. */ 
        blmoLighten,                 /* Selects the lighter of the backdrop and source colors. */
		blmoColorDodge,              /* Brightens the backdrop color to reflect the source color. Painting
									 with black produces no change. */
        blmoColorBurn,               /* Darkens the backdrop color to reflect the source color. 
									 Painting with white produces no change. */
        blmoHardLight,               /* Multiplies or screens the colors, depending on the source 
									 color value. */
        blmoSoftLight,               /* Darkens or lightens the colors, depending on the source color value. */
        blmoDifference,              /* Subtracts the darker of the two constituent colors from the lighter. */
		blmoExclusion                /* Produces an effect similar to that of the Difference mode, but lower
									 in contrast. */
    } PDFBlendMode;

	/********************************************************************
    Description:
        Creates graphic state in document.
    Parameters:
           Doc                  - [ in ] Current PDF document.
    Returns:
        Graphic state index.
    *********************************************************************/
    ppInt32 PDFExtGraphicStateCreate(PDFDocHandle Doc);

	/* Description
	   Setting line width for current graphic state.
	   Parameters
	   Doc :        [ in, out ] Current PDF document.
	   GState :     [ in ] Graphic state index.
	   LineWidth :  [ in ] Line width.
	   Returns
	   None.                                          */
    void PDFExtGraphicStateSetLineWidth(PDFDocHandle Doc, ppInt32 GState, ppReal LineWidth);

	/* Description
	   Setting line cap for current graphic state.
	   Parameters
	   Doc :      [ in, out ] Current PDF document.
	   GState :   [ in ] Graphic state index.
	   LineCap :  [ in ] Line cap.
	   Returns
	   None.                                        */
    void PDFExtGraphicStateSetLineCap(PDFDocHandle Doc, ppInt32 GState, ppInt32 LineCap);

	/* Description
	   Setting line cap for current graphic state.
	   Parameters
	   Doc :       [ in, out ] Current PDF document.
	   GState :    [ in ] Graphic state index.
	   LineJoin :  [ in ] Line join.
	   Returns
	   None.                                         */
	void PDFExtGraphicStateSetLineJoin(PDFDocHandle Doc, ppInt32 GState, ppInt32 LineJoin);

	/* Description
	   Setting mitter limit for current graphic state.
	   Parameters
	   Doc :          [ in, out ] Current PDF document.
	   GState :       [ in ] Graphic state index.
	   MitterLimit :  [ in ] Mitter limit.
	   Returns
	   None.                                            */
	void PDFExtGraphicStateSetMitterLimit(PDFDocHandle Doc, ppInt32 GState, ppReal MitterLimit);

	/* Description
	   Setting dash pattern for current graphic state.
	   Parameters
	   Doc :          [ in, out ] Current PDF document.
	   GState :       [ in ] Graphic state index.
	   DashPattern :  [ in ] Dash pattern.
	   Returns
	   None.                                            */
    void PDFExtGraphicStateSetDashPattern(PDFDocHandle Doc, ppInt32 GState, PDFCosHandle DashPattern);

	/* Description
	   Setting "alpha is shape" for current graphic state.
	   Parameters
	   Doc :           [ in, out ] Current PDF document.
	   GState :        [ in ] Graphic state index.
	   AlphaIsShape :  [ in ] Alpha is shape.
	   Returns
	   None.                                               */
	void PDFExtGraphicStateSetAlphaIsShape(PDFDocHandle Doc, ppInt32 GState, ppBool AlphaIsShape);

	/* Description
	   Setting alpha stroke for current graphic state.
	   Parameters
	   Doc :           [ in, out ] Current PDF document.
	   GState :        [ in ] Graphic state index.
	   AlphaIsShape :  [ in ] Alpha stroke.
	   Returns
	   None.                                             */
	void PDFExtGraphicStateSetAlphaStroke(PDFDocHandle Doc, ppInt32 GState, ppReal AlphaStroke);

	/* Description
	   Setting alpha fill for current graphic state.
	   Parameters
	   Doc :        [ in, out ] Current PDF document.
	   GState :     [ in ] Graphic state index.
	   AlphaFill :  [ in ] Alpha fill.
	   Returns
	   None.                                          */
	void PDFExtGraphicStateSetAlphaFill(PDFDocHandle Doc, ppInt32 GState, ppReal AlphaFill);

	/* Description
	   Setting text knockout for current graphic state.
	   Parameters
	   Doc :           [ in, out ] Current PDF document.
	   GState :        [ in ] Graphic state index.
	   TextKnockout :  [ in ] Text knockout.
	   Returns
	   None.                                             */
	void PDFExtGraphicStateSetTextKnockout(PDFDocHandle Doc, ppInt32 GState, ppBool TextKnockout);

	/* Description
	   Setting overprint stroke for current graphic state.
	   Parameters
	   Doc :              [ in, out ] Current PDF document.
	   GState :           [ in ] Graphic state index.
	   OverprintStroke :  [ in ] Overprint stroke.
	   Returns
	   None.                                                */
    void PDFExtGraphicStateSetOverprintStroke(PDFDocHandle Doc, ppInt32 GState, ppBool OverprintStroke);

	/* Description
	   Setting overprint fill for current graphic state.
	   Parameters
	   Doc :            [ in, out ] Current PDF document.
	   GState :         [ in ] Graphic state index.
	   OverprintFill :  [ in ] Overprint fill.
	   Returns
	   None.                                              */
    void PDFExtGraphicStateSetOverprintFill(PDFDocHandle Doc, ppInt32 GState, ppBool OverprintFill);

	/* Description
	   Setting overprint mode for current graphic state.
	   Parameters
	   Doc :            [ in, out ] Current PDF document.
	   GState :         [ in ] Graphic state index.
	   OverprintMode :  [ in ] Overprint mode.
	   Returns
	   None.                                              */
    void PDFExtGraphicStateSetOverprintMode(PDFDocHandle Doc, ppInt32 GState, ppInt32 OverprintMode);

	/* Description
	   Setting flatness for current graphic state.
	   Parameters
	   Doc :       [ in, out ] Current PDF document.
	   GState :    [ in ] Graphic state index.
	   Flatness :  [ in ] Graphic state flatness.
	   Returns
	   None.                                         */
    void PDFExtGraphicStateSetFlatness(PDFDocHandle Doc, ppInt32 GState, ppReal Flatness);

	/* Description
	   Setting graphic state rendering intents.
	   Parameters
	   Doc :     [ in, out ] Current PDF document.
	   GState :  [ in ] Graphic state index.
	   Intent :  [ in ] Rendering intents.
	   Returns
	   None.                                       */
    void PDFExtGraphicStateSetRenderingIntent(PDFDocHandle Doc, ppInt32 GState, PDFRenderingIntents Intent);

	/* Description
	   Setting blending mode for current graphic state.
	   Parameters
	   Doc :        [ in, out ] Current PDF document.
	   GState :     [ in ] Graphic state index.
	   BlendMode :  [ in ] Blending mode.
	   Returns
	   None.                                            */
    void PDFExtGraphicStateSetBlendMode(PDFDocHandle Doc, ppInt32 GState, PDFBlendMode BlendMode);

	/* Description
	   Setting smoothness for current graphic state.
	   Parameters
	   Doc :         [ in, out ] Current PDF document.
	   GState :      [ in ] Graphic state index.
	   Smoothness :  [ in ] Smoothness value.
	   Returns
	   None.                                           */
    void PDFExtGraphicStateSetSmoothness(PDFDocHandle Doc, ppInt32 GState, ppReal Smoothness);

	/* Description
	   Setting stroke adjustment for current graphic state.
	   Parameters
	   Doc :               [ in, out ] Current PDF document.
	   GState :            [ in ] Graphic state index.
	   StrokeAdjustment :  [ in ] Stroke adjustment.
	   Returns
	   None.                                                 */
    void PDFExtGraphicStateSetStrokeAdjustment(PDFDocHandle Doc, ppInt32 GState, ppBool StrokeAdjustment);


#ifdef __cplusplus
}
#endif

#endif /* #ifndef VSGStateA_H */
