/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>

#include "VSLibA.h"         /* Use Versy PDF Library */
#include "VSExcept.h"       /* Use Exceptions API */
#include "VSError.h"        /* Use Errors API */
#include "VSDocA.h"         /* Use PDF Document API */
#include "VSAcroObjects.h"  /* Use Acro Objects API */

int main( int argc, char* argv[] )  /* Get PDF filename as first parameter */
{
    PDFLibHandle	PDFLibrary; /* PDF Library Handle */
    PDFDocHandle	Doc = NULL; /* PDF Document Handle */
    TPDFDocumentSignature DocumentSignature; /* Document Signature Acro Object */
    ppInt32         ErrorCode;/* Check Error Code */

    PDFLibrary = InitPDFLibrary( NULL, NULL );/* Initialize PDF Library */
    PDFTRY( PDFLibrary ) {/* On error keep exception */
            Doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf" );/* Load existing PDF file */
            PDFDocSetLinearized( Doc, false );/* Set non-linearize option for crypted PDF file */

            if ( PDFDocGetPageCount( Doc ) > 0 ) {/* If have one or more pages in source document */
                PDFDocSetAutoLaunch( Doc, true );/* Launch destination PDF file after work */

                DocumentSignature.FileName =    (char *)malloc(255);/* Memory allocation for Document Signature PFX-filename */
                DocumentSignature.Name =        (char *)malloc(255);/* Memory allocation for Signature Name */
                DocumentSignature.Owner =       (char *)malloc(255);/* Memory allocation for Owner of Signature */
                DocumentSignature.Password =    (char *)malloc(255);/* Memory allocation for Signature Password */
                DocumentSignature.Reason =      (char *)malloc(255);/* Memory allocation for Reason of Sign */


                sprintf( DocumentSignature.FileName, "../Data/in/dig-signature.pfx" ); /* Set Document Signature PFX-filename as "dig-signature.pfx" */
                sprintf( DocumentSignature.Name,     "DocumentSignature" ); /* Set Signature Name as "DocumentSignature" */
                sprintf( DocumentSignature.Owner,    "Ted Thompson" );/* Set Owner's name as "Ted Thompson" */
                sprintf( DocumentSignature.Password, "123456" );/* Set Password as "123456" */
                sprintf( DocumentSignature.Reason,   "I agree..." );/* Set Reason, for example "I agree..." */
                DocumentSignature.PKCS7 = true; /* Set Crypt Algorithm as Adobe.PPKMS with sub filter adbe.pkcs7.sha1 */

                PDFAcroSignDocument( Doc, 0, DocumentSignature ); /* Set invisible document digital signature and link with first page */

                free( DocumentSignature.FileName );/* Free memory of Document Signature PFX-filename */
                free( DocumentSignature.Name );/* Free memory of Signature Name */
                free( DocumentSignature.Owner );/* Free memory of Owner name */
                free( DocumentSignature.Password );/* Free memory of Signature Password */
                free( DocumentSignature.Reason );/* Free memory of Sign Reason */

                PDFDocSaveToFile( Doc, "../Data/out/SignDocTest.pdf" );/* Save destination PDF file as "sign-doc-test.pdf" in current path */
            }
    }
    PDFFINALLY( PDFLibrary )/* Do further if haven't PDF Library Exceptions */
		if ( Doc ) PDFDocClose ( Doc );/* Close PDF Document and free memory */
		ErrorCode = PDFLASTERROR( PDFLibrary );/* Check last error, if 0 then finished successfully */
        DonePDFLibrary( &PDFLibrary );/* Free PDF Library */
    PDFTRYEND( PDFLibrary );/* End of try...end block */
    return ErrorCode;/* Return Error Code as program result */
}

