/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TRubberStampAnnotDict RubberStampAnnotation;  /* Rubber stamp annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );             /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			RubberStampAnnotation.Contents = "Draft rubber stamp annotation"; /* Annotation content filling */
			RubberStampAnnotation.ContLength = 29;
			RubberStampAnnotation.Open = false;                     /* Set open property to false */
			RubberStampAnnotation.BSDict = NULL;                    /* Zeroizing unused properties */
			RubberStampAnnotation.DateTime = NULL;
            RubberStampAnnotation.AppearanceStream =  CosNewNull ( doc ); 
			RubberStampAnnotation.Action = CosNewNull ( doc );      
			RubberStampAnnotation.AdditAction = CosNewNull ( doc );
			RubberStampAnnotation.Popup = CosNewNull ( doc );
            RubberStampAnnotation.AnFlags = 0;
			RubberStampAnnotation.Transparency = 1;
			RubberStampAnnotation.Rectangle.pt1.X = 200;              /* Setting annotation sizes */
			RubberStampAnnotation.Rectangle.pt1.Y = 800;
			RubberStampAnnotation.Rectangle.pt2.X = 400;
			RubberStampAnnotation.Rectangle.pt2.Y = 600;
			RubberStampAnnotation.Color.blue = 1.0;                   /* Setting annotation color to blue */ 
			RubberStampAnnotation.Color.red = 0.0;
			RubberStampAnnotation.Color.green = 0.0;
			RubberStampAnnotation.TitleText = "Rubber Stamp title";   /* Setting annotation title */
			RubberStampAnnotation.TTLength = 18;
			RubberStampAnnotation.IconStyleName = inDraft;            /* Setting annotation style as Draft */ 
			PDFPageAddRubberStampAnnotation( doc, 0, RubberStampAnnotation ); /* Adding annotation to the document */ 
			PDFDocSaveToFile( doc, "../Data/out/RubberStampAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}