/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	TPopupAnnotDict PopupAnnotation;              /* Popup annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocCreate( PDFLibrary );             /* Create new PDF file */
		PDFDocSetAutoLaunch( doc, true );             /* Launch destination PDF file after work */
		PDFDocAppendPage2(doc, psA4,poPagePortrait);  /* Insert new page into document */
		PopupAnnotation.Contents = "Popup annotation";    /* Annotation content filling */
		PopupAnnotation.ContLength = 16;
		PopupAnnotation.Open = true;                      /* Set open property to true */
		PopupAnnotation.BSDict = NULL;                    /* Zeroizing unused properties */
		PopupAnnotation.DateTime = NULL;
		PopupAnnotation.Parent = CosNewNull ( doc );      
		PopupAnnotation.Action = CosNewNull ( doc );      
		PopupAnnotation.AdditAction = CosNewNull ( doc );
		PopupAnnotation.Popup = CosNewNull ( doc );
        PopupAnnotation.AnFlags = 0;
        PopupAnnotation.Transparency = 1;
		PopupAnnotation.IconName = anInsert;               /* Setting icon name */
		PopupAnnotation.Rectangle.pt1.X = 200;              /* Setting annotation sizes */
		PopupAnnotation.Rectangle.pt1.Y = 600;
		PopupAnnotation.Rectangle.pt2.X = 400;
		PopupAnnotation.Rectangle.pt2.Y = 800;
		PopupAnnotation.Color.blue = 1.0;                 /* Setting annotation color to blue */ 
		PopupAnnotation.Color.red = 0.0;
		PopupAnnotation.Color.green = 0.0;
		PopupAnnotation.TitleText = "Popup title";        /* Setting annotation title */   
		PopupAnnotation.TTLength = 11;
		PDFPageAddPopupAnnotation( doc, 0, PopupAnnotation ); /* Adding annotation to the document */ 
		PDFDocSaveToFile( doc, "../Data/out/PopupAnnotationTest.pdf" );      /* Saving the document */ 
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}