/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TPolyAnnotDict PolyAnnotation;  /* Poly annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );                     /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			PolyAnnotation.Contents = "Poly annotation";    /* Annotation content filling */
			PolyAnnotation.ContLength = 15;
			PolyAnnotation.IconName = anDefault;
			PolyAnnotation.Type = ptPolygon;			
			PolyAnnotation.Open = true;                      /* Set open property to true */
			PolyAnnotation.BSDict = NULL;                    /* Zeroizing unused properties */
			PolyAnnotation.DateTime = NULL;
			PolyAnnotation.InteriorColor = NULL;
			PolyAnnotation.BorderEffect = CosNewNull ( doc );
			PolyAnnotation.Action = CosNewNull ( doc );      
			PolyAnnotation.AdditAction = CosNewNull ( doc );
			PolyAnnotation.Popup = CosNewNull ( doc );
			PolyAnnotation.AnFlags = 0;
			PolyAnnotation.Transparency = 1;
			PolyAnnotation.Vertices = malloc (sizeof( int )* 8 ); /* Allocating polygon with two points */
			PolyAnnotation.Vertices[0] =  266;   /* First point X coordinate */
			PolyAnnotation.Vertices[1] =  800;   /* First point Y coordinate */
			PolyAnnotation.Vertices[2] =  430;   /* Second point X coordinate */
			PolyAnnotation.Vertices[3] =  700;   /* Second point Y coordinate */ 
			PolyAnnotation.VertLength = 4;       /* Sets length of vertices */ 
			PolyAnnotation.LineEnding [0] = lesSquare;
			PolyAnnotation.LineEnding [1] = lesCircle;
			PolyAnnotation.Rectangle.pt1.X = 266;              /* Setting annotation sizes */
			PolyAnnotation.Rectangle.pt1.Y = 800;
			PolyAnnotation.Rectangle.pt2.X = 430;
			PolyAnnotation.Rectangle.pt2.Y = 700;
			PolyAnnotation.Color.blue = 1.0;                 /* Setting annotation color to blue */ 
			PolyAnnotation.Color.red = 0.0;
			PolyAnnotation.Color.green = 0.0;
			PolyAnnotation.TitleText = "Poly title";   /* Setting annotation title */
			PolyAnnotation.TTLength = 10;
			PDFPageAddPolyAnnotation( doc, 0, PolyAnnotation ); /* Adding annotation to the document */ 
			PDFDocSaveToFile( doc, "../Data/out/PolyAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}
