/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>          /* Use standard Input/Output Console API */

#include "VSLibA.h"         /* Use Versy PDF Library */
#include "VSExcept.h"       /* Use Exceptions API */
#include "VSError.h"        /* Use Errors API */
#include "VSDocA.h"         /* Use PDF Document API */

#include "VSPagesA.h"       /* Use Pages API */

int main( int argc, char* argv[] )              /* Get PDF filename as first parameter */
{
    PDFLibHandle	PDFLibrary = NULL;          /* PDF Library Handle */

	PDFDocHandle	SourceDocument      = NULL; /* Source PDF Document Handle */
    PDFDocHandle	DestinationDocument = NULL; /* Destination PDF Document Handle */

    TPDFDocumentConnection DocumentConnection;  /* Document Connection Structure */
    ppInt32         ErrorCode;                  /* Check Error Code */
    ppInt32         i;                          /* Variable counter */

    PDFLibrary = InitPDFLibrary( NULL, NULL );/* Initialize PDF Library */
    PDFTRY( PDFLibrary ) {/* On error keep exception */


            SourceDocument = PDFDocLoadFromFile( PDFLibrary, "../Data/in/violet-file.pdf" );/* Load existing source PDF file */
            DestinationDocument = PDFDocCreate( PDFLibrary );/* Create new destination PDF file */
            PDFDocSetAutoLaunch( DestinationDocument, true );/* Launch destination PDF file after work */

            /* Initialize source and destination documents connection */
            PDFCreateDocumentConnection( SourceDocument, DestinationDocument, &DocumentConnection );

            /* Take each page from source PDF document, by increase page number and select it for copy */
            for ( i = 0; i < PDFDocGetPageCount( SourceDocument ); i++ )
                PDFSelectPageFromSourceDocument( &DocumentConnection, i );

            /* Copy all selected in connection pages from source to destination PDF Document */
            PDFCopyPagesToDestinationDocument( &DocumentConnection );

            /* Take each page from source PDF document, by decrease page number and select it for copy */
            for ( i = PDFDocGetPageCount( SourceDocument ); i > 0; i-- )
                PDFSelectPageFromSourceDocument( &DocumentConnection, i - 1 );

            /* Copy all selected in connection pages from source to destination PDF Document */
            PDFCopyPagesToDestinationDocument( &DocumentConnection );

            /* Disconnect PDF documents, free memory and load destination document pages */
            PDFFreeDocumentConnection( &DocumentConnection );

            /* Save destination PDF file as "pages-api-test.pdf" in current path */
            PDFDocSaveToFile( DestinationDocument, "../Data/out/PagesAPITest.pdf" );

    } PDFFINALLY( PDFLibrary ) { /* Do further if haven't PDF Library Exceptions */
        /* Close source PDF Document and free memory */
        if ( SourceDocument ) PDFDocClose ( SourceDocument );
        /* Close destination PDF Document and free memory */
        if ( DestinationDocument ) PDFDocClose ( DestinationDocument );
        ErrorCode = PDFLASTERROR( PDFLibrary );/* Check last error, if 0 then finished successfully */
        DonePDFLibrary( &PDFLibrary );/* Free PDF Library */
    }
    PDFTRYEND( PDFLibrary );/* End of try...end block */
    return ErrorCode; /* Return Error Code as program result */
}

