/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TFileAttachAnnotDict FileAttachAnnotation;    /* File Attach annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );                     /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			FileAttachAnnotation.Contents = "File annotation";     /* Annotation content filling */
			FileAttachAnnotation.ContLength = 15;
			FileAttachAnnotation.Open = true;                      /* Set open property to true */
			FileAttachAnnotation.DateTime = NULL;                  /* Zeroizing unused properties */
            FileAttachAnnotation.AnFlags = 0;
            FileAttachAnnotation.Transparency = 1;
			FileAttachAnnotation.Rectangle.pt1.X = 200;            /* Setting annotation sizes */
			FileAttachAnnotation.Rectangle.pt1.Y = 800;
			FileAttachAnnotation.Rectangle.pt2.X = 400;
			FileAttachAnnotation.Rectangle.pt2.Y = 700;
			FileAttachAnnotation.FileName = "../Data/in/attach";     /* Set filename */        
			FileAttachAnnotation.FNLength = 17;
			FileAttachAnnotation.Color.blue = 0.0;                 /* Setting annotation color to yellow */ 
			FileAttachAnnotation.Color.red = 1.0;
			FileAttachAnnotation.Color.green = 1.0;
			PDFPageAddFileAttachAnnotation( doc, 0, FileAttachAnnotation ); /* Adding annotation to the document */ 
			PDFDocSaveToFile( doc, "../Data/out/FileAttachAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}