/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"

int main( void )
{
	int Page;                                     /* Page index variable description */
	PBXHandle PB;                                 /* Paint box variable description */ 
	HENHMETAFILE hemf;                            /* Metafile variable description */ 
	PDFDocHandle doc = NULL;                      /* Document variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocCreate( PDFLibrary );             /* Create new PDF file */
		PDFDocSetAutoLaunch( doc, true );             /* Launch destination PDF file after work */
		Page = PDFDocAppendPage2( doc, psA4,poPagePortrait );  /* Insert new page into document */
		PB = PDFPageCreatePaintBox( doc, Page, 72 );    /* Create paintbox */ 
		hemf = GetEnhMetaFile ( "../Data/in/logo.emf" );        /* Load metafile*/ 
		if ( !hemf ) return 1;
		PDFTRY ( PDFLibrary ){
			PBXPlayMetaFile ( PB, hemf, 10.0, 20.0, 1.0 , 1.0 );  /* Add metafile to document in coordinates X=10, Y=20, X Size = 1, Y Size = 1 */
		} PDFFINALLY ( PDFLibrary ) {
			DeleteEnhMetaFile ( hemf );                         /* Close metafile */
		}
		PDFFINALLYEND ( PDFLibrary );   
		PBXClose( PB, true );                                     /* Close paintbox */
		PDFDocSaveToFile( doc, "../Data/out/EmfTest.pdf" );      /* Saving the document */ 
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}
