/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TCaretAnnotDict CaretAnnotation;              /* Caret annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );                     /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			CaretAnnotation.Contents = "Caret annotation";    /* Annotation content filling */
			CaretAnnotation.ContLength = 16;
			CaretAnnotation.Open = true;                      /* Set open property to true */
			CaretAnnotation.BSDict = NULL;                    /* Zeroizing unused properties */
			CaretAnnotation.DateTime = NULL;
			CaretAnnotation.RectBound = NULL;
			CaretAnnotation.Action = CosNewNull ( doc );      
			CaretAnnotation.AdditAction = CosNewNull ( doc );
			CaretAnnotation.Popup = CosNewNull ( doc );
            CaretAnnotation.AnFlags = 0;
            CaretAnnotation.Transparency = 1;
			CaretAnnotation.IconName = anNewParagraph;               /* Setting icon name */
			CaretAnnotation.Rectangle.pt1.X = 20;              /* Setting annotation sizes */
			CaretAnnotation.Rectangle.pt1.Y = 400;
			CaretAnnotation.Rectangle.pt2.X = 120;
			CaretAnnotation.Rectangle.pt2.Y = 800;
			CaretAnnotation.Color.blue = 1.0;                 /* Setting annotation color to blue */ 
			CaretAnnotation.Color.red = 0.0;
			CaretAnnotation.Color.green = 0.0;
			CaretAnnotation.TitleText = "Caret title";        /* Setting annotation title */       
			CaretAnnotation.TTLength = 11;
			PDFPageAddCaretAnnotation( doc, 0, CaretAnnotation ); /* Adding annotation to the document */ 
			PDFDocSaveToFile( doc, "../Data/out/CaretAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}