/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>                      /* Use standard Input/Output Console API */

#include "VSLibA.h"                     /* Use Versy PDF Library */
#include "VSExcept.h"                   /* Use Exceptions API */
#include "VSError.h"                    /* Use Errors API */
#include "VSDocA.h"                     /* Use PDF Document API */

#include "VSAcroObjects.h"              /* Use Acro Objects API */

int main( int argc, char* argv[] )      /* Get PDF filename as first parameter */
{
    PDFLibHandle	PDFLibrary;         /* PDF Library Handle */
	PDFDocHandle	Doc = NULL;         /* PDF Document Handle */

    ppUns32         Key;                /* Acro Object Index in PDF Document */
    ppUns32         Count;              /* Count of Acro Objects in PDF Document */
    char           *FieldName = NULL;   /* Variable Acro Field's Name */
    char           *FieldValue = NULL;  /* Variable Acro Field's Value */
    char            SettingName[100];   /* Constant Acro Field's Name */
    ppInt32         ErrorCode;          /* Check Error Code */

    PDFLibrary = InitPDFLibrary( NULL, NULL ); /* Initialize PDF Library */
    PDFTRY( PDFLibrary )                /* On error keep exception */

            Doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/acroform-api-test.pdf"); /* Load existing PDF file */
            PDFDocSetAutoLaunch( Doc, true );   /* Launch destination PDF file after work */

            Count = PDFAcroGetCount( Doc ); /* Check Count of Acro Objects in PDF Document */
            for ( Key = 0; Key < Count; Key++ ) { /* Take each Acro Objects one by one */
                FieldName = PDFAcroGetNameByKey( Doc, Key ); /* Get Acro Object's Name */
                FieldValue = PDFAcroGetValueByKey( Doc, Key ); /* Get Acro Object's Value */
                if ( FieldName || FieldValue ) {    /* If we had any not null option then ... */
                    /* Print Name and Value of current Object */
                    printf("Field with name '%s' have value '%s' yet.\n", FieldName, FieldValue );
                    free( FieldName ); /* Free Object's name */
                    free( FieldValue );/* Free Object's value */
                    FieldValue = NULL; /* Set as NULL */
                    FieldName = NULL;  /* Set as NULL */
                }
            }

            sprintf( SettingName, "cp" ); /* Intention to change field with name "cp" (Contact Person) */
            PDFAcroSetValueByName( Doc, SettingName, "Ted Thompson" ); /* Set Field "cp" Value
                                                                       as "Ted Thompson"*/
            FieldValue = PDFAcroGetValueByName( Doc, SettingName ); /* Get Field "cp" Value */
            if ( FieldValue ) { /* If Value of Contact Person Field is not NULL then ...*/
                /* Print Name and Value of Contact Person Field */
                printf("Field with name '%s' have value '%s' now.\n", SettingName, FieldValue );
                free( FieldValue ); /* Free Object's value */
                FieldValue = NULL; /* Set as NULL */
            }

            sprintf( SettingName, "cn" ); /* Intention to change field with name "cn" (Company Name) */
            PDFAcroSetValueByName( Doc, SettingName, "Thallium Inc." ); /* Set Field "cn" Value
                                                                        as "Thallium Inc."*/
            FieldValue = PDFAcroGetValueByName( Doc, SettingName ); /* Get Field "cn" Value */
            if ( FieldValue ) { /* If Value of Company Name Field is not NULL then ...*/
                /* Print Name and Value of Company Name Field */
                printf("Field with name '%s' have value '%s' now.\n", SettingName, FieldValue );
                free( FieldValue ); /* Free Object's value */
                FieldValue = NULL; /* Set as NULL */
            }

            sprintf( SettingName, "dp" ); /* Intention to change field with name "dp" (Department) */
            /* Set Field "dp" Value as "202 Software Department"*/
            PDFAcroSetValueByName( Doc, SettingName, "202 Software Department" );
            FieldValue = PDFAcroGetValueByName( Doc, SettingName ); /* Get Field "dp" Value */
            if ( FieldValue ) { /* If Value of Department Field is not NULL then ...*/
                /* Print Name and Value of Department Field */
                printf("Field with name '%s' have value '%s' now.\n", SettingName, FieldValue );
                free( FieldValue ); /* Free Object's value */
                FieldValue = NULL; /* Set as NULL */
            }

            PDFDocSaveToFile( Doc, "../Data/out/AcroFormTest.pdf" ); /* Save destination PDF file as
                                                                  "acroform-get-set-test.pdf" in
                                                                  current path */
    PDFFINALLY( PDFLibrary ) /* Do further if haven't PDF Library Exceptions */
		if ( Doc ) PDFDocClose ( Doc ); /* Close PDF Document and free memory */
		ErrorCode = PDFLASTERROR( PDFLibrary ); /* Check last error, if 0 then finished successfully */
        DonePDFLibrary( &PDFLibrary ); /* Free PDF Library */
    PDFTRYEND( PDFLibrary ); /* End of try...end block */
    return ErrorCode;   /* Return Error Code as program result */
}

