//	terrain.h
// Initialization file for Levels.
// Also, draws the terrain, and displays messages.

#include <windows.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

bool 		ShowHitScore;		// Show score for every target hit.

const int MsgTotal = 9;    // Total # of Messages
const int LvlTotal = 6;    // Total # of Levels
int curMsg =0;					// Current Message

// Graphic Objects
	strLevel CurLvl;
// Message Objects
	strMsg Msg[MsgTotal];

////////////////////////////////////////////////////////////////////////////////
void CreateLevel (strLevel &CurLvl)
// This Function initializes the Level.
{

   int hgt=120,h=4;           // Height starts at 120
   for(int i=1;i<MsgTotal;i++) Msg[i].active =false; // All Msgs set to inactive
   for(int i=0;i<65;i++){     // for loop creates all the Terrain Heights
   	CurLvl.hgt[i]=hgt;      // main height
   	CurLvl.lhgt[i]=hgt;     // last height
   	hgt+=h;                 // increment height with h
   	if (hgt>=200) hgt = 200;// if > 200, make 200.
   	if (random(10)>7) hgt+=random(16)-8;	// make bumpy terrain by
                                             // randomizing height
   	if (hgt<=120) hgt = 120;// if < 120, make 120.
    	if (random(10)>8) h--;                 // randomly decrement h

   }

}
////////////////////////////////////////////////////////////////////////////////
void DrawLevel (bool White,bool slow,int from,int to)
// This Function draws the Level.
{
	if (from <=0) from = 0;                   // Error Checking
	if (from >=65) from = 64;                 // Error Checking
	if (to <=0) to = 0;                       // Error Checking
	if (to >=65) to = 64;                     // Error Checking
   for(int i=from;i<to+0;i++)                // Loop 1 to 65
   {
   	// if white, make a white line
   	if (White==true) Line(i*10,CurLvl.hgt[i],(i+1)*10,CurLvl.hgt[i+1],WHITE);
   	else
      {
 		   Line(i*10,CurLvl.lhgt[i],(i+1)*10,CurLvl.lhgt[i+1],BGCol);
         // erase last line
 		   Line(i*10,CurLvl.hgt[i],(i+1)*10,CurLvl.hgt[i+1],WHITE);
         // draw a new line.
     }
   	if (slow) Sleep(10);  // If slow, draw it slowly.
   }
}
////////////////////////////////////////////////////////////////////////////////
int LvlHgt(int x)
// This function returns the ground's height in relation to horizontal distance.
{
	if (x <=0) x = 0;
	if (x >=800) x = 800;
   return CurLvl.hgt[x/10];
}
////////////////////////////////////////////////////////////////////////////////
void Message(int x,int y,char ch[],int msgTyp)
// This function creates a message.
{
	if ((ShowHitScore) || (msgTyp == 1)){ // If ShowHitScore is active.
		curMsg++;                          // Increment current message
   	if (curMsg>=MsgTotal) curMsg =1;   // If curMsg is too high.
   	Msg[curMsg].x = x;
   	Msg[curMsg].y = y;
   	Msg[curMsg].active = true;         // Intialize a new message.
   	Msg[curMsg].ch = ch;
   	Msg[curMsg].Rev = 40;
   	Msg[curMsg].msgTyp = msgTyp;
   }

}
////////////////////////////////////////////////////////////////////////////////
void DoMessage()
//This function controls the movement of the Messages.
{
	for(int i = 1;i<MsgTotal;i++){ // Loop for all Messages.
   	if (Msg[i].active){         	// If message is active
      	Msg[i].Rev--;              // decrement revolution.
         switch(Msg[i].msgTyp){     // switch for message type.
         	case 1:     // Blinking message
      			if (int(Msg[i].Rev/12)*12 == Msg[i].Rev)
      				Text(Msg[i].x,Msg[i].y,Msg[i].ch,BGCol);
                  // make Text black every 6th interval
      			if (int((Msg[i].Rev+6)/12)*12 == Msg[i].Rev+6)
      				Text(Msg[i].x,Msg[i].y,Msg[i].ch,WHITE);
                  // make Text white every other 6th interval
               if (Msg[i].Rev <= 0) Msg[i].active = false;
               	// if Rev timer ran out, make Message inactive.
				break;
            case 2:   	// Rising message
            	Msg[i].Rev--;    // decrement rev faster.
               Text(Msg[i].x,Msg[i].y,Msg[i].ch,BGCol);
               	// erase last message.
               Msg[i].y+=5;
               	// increase height by 5.
               Text(Msg[i].x,Msg[i].y,Msg[i].ch,RGB(Msg[i].Rev*3+125,240-Msg[i].Rev*3,125));
               	// output new message with new color.
      			if (Msg[i].Rev <= 0) {
               		// if Rev timer ran out
               	Msg[i].active = false;
                  	// make inactive
               	Text(Msg[i].x,Msg[i].y,Msg[i].ch,BGCol);
							// Erase final message.
               }
            break;
            default:

            break;
         }  // End switch
   	}  // End if active
   }  // End for loop
}  // End Function.
