/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

public class RMatrix {
    private int rows;
    private int columns;
    private double[][] data;

    public RMatrix(double[][] dArray) {
        this.rows = dArray.length;
        this.columns = dArray[0].length;
        this.data = dArray;
    }

    public RMatrix(int[][] nArray) {
        this.rows = nArray.length;
        this.columns = nArray[0].length;
        this.data = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.data[i][j] = nArray[i][j];
            }
        }
    }

    public RMatrix(int n, int n2) {
        this.rows = n;
        this.columns = n2;
        this.data = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.data[i][j] = 0.0;
            }
        }
    }

    public RMatrix add(RMatrix rMatrix) {
        RMatrix rMatrix2 = new RMatrix(this.rows, this.columns);
        if (this.rows == rMatrix.rows && this.columns == rMatrix.columns) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    rMatrix2.data[i][j] = this.data[i][j] + rMatrix.data[i][j];
                }
            }
        }
        return rMatrix2;
    }

    public RMatrix invert() {
        int n;
        int n2;
        int n3 = this.data.length;
        double[][] dArray = new double[n3 + 1][2 * n3 + 2];
        for (n2 = 0; n2 < this.rows; ++n2) {
            for (n = 0; n < this.columns; ++n) {
                dArray[n2 + 1][n + 1] = this.data[n2][n];
            }
        }
        boolean bl = false;
        int n4 = 2 * n3;
        for (n2 = 1; n2 <= n3; ++n2) {
            for (n = 1; n <= n3; ++n) {
                dArray[n2][n + n3] = 0.0;
            }
            dArray[n2][n2 + n3] = 1.0;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            double d = dArray[n2][n2];
            if (d == 0.0) {
                bl = true;
                break;
            }
            for (n = 1; n <= n4; ++n) {
                dArray[n2][n] = dArray[n2][n] / d;
            }
            for (int i = 1; i <= n3; ++i) {
                if (i - n2 == 0) continue;
                double d2 = dArray[i][n2];
                for (n = 1; n <= n4; ++n) {
                    dArray[i][n] = dArray[i][n] - d2 * dArray[n2][n];
                }
            }
        }
        RMatrix rMatrix = new RMatrix(this.rows, this.columns);
        for (n2 = 0; n2 < this.rows; ++n2) {
            for (n = 0; n < this.columns; ++n) {
                rMatrix.data[n2][n] = dArray[n2 + 1][n + 1 + n3];
            }
        }
        return rMatrix;
    }

    public RMatrix mult(double d) {
        RMatrix rMatrix = new RMatrix(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                rMatrix.data[i][j] = d * this.data[i][j];
            }
        }
        return rMatrix;
    }

    public void setValue(int n, int n2, double d) {
        this.data[n][n2] = d;
    }

    public double getValue(int n, int n2) {
        return this.data[n][n2];
    }

    public RMatrix mult(RMatrix rMatrix) {
        RMatrix rMatrix2 = this;
        RMatrix rMatrix3 = new RMatrix(rMatrix2.rows, rMatrix.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < rMatrix.columns; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    double[] dArray = rMatrix3.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.data[i][k] * rMatrix.data[k][j];
                }
            }
        }
        return rMatrix3;
    }

    public RMatrix transpose() {
        RMatrix rMatrix = new RMatrix(this.columns, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                rMatrix.data[j][i] = this.data[i][j];
            }
        }
        return rMatrix;
    }
}

