/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.BarPlotter;
import com.java4less.rchart.BarPlotter3D;
import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartComponent;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.LinePlotter;
import com.java4less.rchart.LinePlotter3D;
import com.java4less.rchart.RadarPlotter;
import com.java4less.rchart.Scale;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class Plotter
extends ChartComponent {
    protected int needsAxis = 2;
    protected boolean combinable = true;
    public Scale XScale;
    public Scale YScale;
    public Scale Y2Scale;
    public FillStyle back = null;
    public Image backImage;
    public int visibleWidth = 0;
    public int visibleHeight = 0;
    public int depth = 0;
    Vector Series = new Vector(0, 1);

    public int getNeedsAxis() {
        return this.needsAxis;
    }

    public boolean getCombinable() {
        return this.combinable;
    }

    public void plotBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        if (this.back != null) {
            n5 = 0;
            if (this instanceof BarPlotter3D) {
                n5 = 1;
            }
            if (this instanceof LinePlotter3D) {
                n5 = 1;
            }
            if (n5 != 0) {
                int[] nArray = new int[6];
                int[] nArray2 = new int[6];
                nArray[0] = this.x + n3;
                nArray2[0] = this.y + n4;
                nArray[1] = this.x + n3 + this.depth;
                nArray2[1] = this.y + n4 - this.depth;
                nArray[2] = this.x + n3 + this.visibleWidth;
                nArray2[2] = this.y + n4 - this.depth;
                nArray[3] = this.x + n3 + this.visibleWidth;
                nArray2[3] = this.y + n4 + this.visibleHeight - this.depth - this.depth;
                nArray[4] = this.x + n3 + this.visibleWidth - this.depth;
                nArray2[4] = this.y + n4 + this.visibleHeight - this.depth;
                nArray[5] = this.x + n3;
                nArray2[5] = this.y + n4 + this.visibleHeight - this.depth;
                this.back.drawPolygon(graphics, nArray, nArray2, 6);
            } else {
                this.back.draw(graphics, this.x, this.y, this.x + n, this.y + n2);
            }
        }
        if (this.backImage != null) {
            n5 = this.backImage.getWidth(null);
            int n6 = this.backImage.getHeight(null);
            if (n5 > -1 && n6 > -1) {
                int n7;
                int n8 = (n - n5) / 2;
                if (n8 < 0) {
                    n8 = 0;
                }
                if ((n7 = (n2 - n6) / 2) < 0) {
                    n7 = 0;
                }
                graphics.drawImage(this.backImage, n8 + this.x, this.y + n7, null);
            }
        }
    }

    public void plot(Graphics graphics) {
        for (int i = 0; i < this.Series.size(); ++i) {
            DataSerie dataSerie = (DataSerie)this.Series.elementAt(i);
            this.plotSerie(graphics, dataSerie, i);
        }
    }

    protected void plotSerie(Graphics graphics, DataSerie dataSerie, int n) {
    }

    public int getSeriesCount() {
        return this.Series.size();
    }

    public DataSerie getSerie(int n) {
        return (DataSerie)this.Series.elementAt(n);
    }

    public void setSerie(int n, DataSerie dataSerie) {
        if (n < this.Series.size()) {
            this.Series.setElementAt(dataSerie, n);
        }
    }

    public void addSerie(DataSerie dataSerie) {
        this.replaceSerie(-1, dataSerie);
    }

    public void replaceSerie(int n, DataSerie dataSerie) {
        if (n >= this.Series.size()) {
            return;
        }
        if (Chart.d() != 1 && dataSerie.getSize() > 8) {
            return;
        }
        if (Chart.d() != 1 && this.Series.size() > 3) {
            return;
        }
        if (n == -1) {
            this.Series.addElement(dataSerie);
        } else {
            this.Series.setElementAt(dataSerie, n);
        }
        boolean bl = false;
        if (this instanceof LinePlotter) {
            bl = ((LinePlotter)this).fixedLimits;
        }
        boolean bl2 = false;
        if (this instanceof BarPlotter && ((BarPlotter)this).cumulative && !((BarPlotter)this).cumulativeBackwardsCompatible) {
            bl2 = true;
        }
        if (this instanceof BarPlotter3D && ((BarPlotter3D)this).cumulative) {
            bl2 = true;
        }
        if (!(this instanceof RadarPlotter)) {
            for (int i = 0; i < dataSerie.getSize(); ++i) {
                if (dataSerie.getElementY(i) == null) continue;
                double d = (Double)dataSerie.getElementX(i);
                double d2 = (Double)dataSerie.getElementY(i);
                if (bl2) {
                    d2 = 0.0;
                    for (int j = 0; j < this.Series.size(); ++j) {
                        DataSerie dataSerie2 = (DataSerie)this.Series.elementAt(j);
                        if (dataSerie2.getSize() <= i || dataSerie2.getElementY(i) == null) continue;
                        double d3 = (Double)dataSerie2.getElementY(i);
                        d2 += d3;
                    }
                }
                if (d >= this.XScale.max) {
                    if (this instanceof BarPlotter || this instanceof BarPlotter3D) {
                        this.XScale.max = d + 1.0;
                        if (this instanceof BarPlotter && ((BarPlotter)this).barAtAxis) {
                            this.XScale.max = d;
                        }
                    } else {
                        this.calculateNewMax(this.XScale, d);
                    }
                }
                if (d < this.XScale.min) {
                    this.calculateNewMin(this.XScale, d);
                }
                if (bl) continue;
                if (dataSerie.secondYAxis && this.Y2Scale != null) {
                    if (d2 > this.Y2Scale.max) {
                        this.calculateNewMax(this.Y2Scale, d2);
                    }
                    if (!(d2 < this.Y2Scale.min)) continue;
                    this.calculateNewMin(this.Y2Scale, d2);
                    continue;
                }
                if (d2 > this.YScale.max) {
                    this.calculateNewMax(this.YScale, d2);
                }
                if (!(d2 < this.YScale.min)) continue;
                this.calculateNewMin(this.YScale, d2);
            }
        }
    }

    private void calculateNewMax(Scale scale, double d) {
        if (!scale.exactMaxValue) {
            scale.max = d;
            return;
        }
        if (scale.preferred_MaxMin_values != null && scale.preferred_MaxMin_values.length > 0) {
            for (int i = 0; i < scale.preferred_MaxMin_values.length; ++i) {
                if (!(scale.preferred_MaxMin_values[i] >= d)) continue;
                scale.max = scale.preferred_MaxMin_values[i];
                break;
            }
        }
    }

    private void calculateNewMin(Scale scale, double d) {
        if (!scale.exactMinValue) {
            scale.min = d;
            return;
        }
        if (scale.preferred_MaxMin_values != null && scale.preferred_MaxMin_values.length > 0) {
            for (int i = scale.preferred_MaxMin_values.length - 1; i > 0; --i) {
                if (!(scale.preferred_MaxMin_values[i] <= d)) continue;
                scale.min = scale.preferred_MaxMin_values[i];
                break;
            }
        }
    }
}

