/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Axis;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.GaugeDataSerie;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.Plotter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.text.DecimalFormat;
import java.util.Vector;

public class GaugePlotter
extends Plotter {
    public int needleBase = 8;
    public double radiusModifier = 1.0;
    public LineStyle border = new LineStyle(2.0f, Color.black, 1);
    private Vector lblPositions = new Vector(10);
    public int axis1LabelMargin = 10;
    public int axis2LabelMargin = -20;
    public int axis2Margin = 40;
    public int axis1Margin = 5;
    public Axis axis1;
    public Axis axis2;
    public FillStyle maxZoneColor = new FillStyle(Color.red);
    public int maxminZoneWidth = 50;
    public int maxminZoneMargin = 5;
    public double maxZone = -1.0;
    public FillStyle minZoneColor = new FillStyle(Color.green);
    public double minZone = -1.0;
    public int startAngle = -20;
    public int endAngle = 200;
    public FillStyle gaugeback = new FillStyle(Color.blue);
    private int angleRange = 0;
    private int CenterX = 0;
    private int CenterY = 0;
    public GaugePlotter subGauge1 = null;
    public GaugePlotter subGauge2 = null;
    protected GaugePlotter parentGauge = null;
    public int subGaugeSize = 30;

    public GaugePlotter() {
        this.combinable = false;
        this.needsAxis = 0;
    }

    protected void plotSerie(Graphics graphics, DataSerie dataSerie, int n) {
        int n2 = 0;
        n2 = this.width;
        if (this.height < n2) {
            n2 = this.height;
        }
        n2 = (int)((double)n2 * this.radiusModifier);
        if (this.axis1 == null) {
            graphics.setColor(Color.red);
            graphics.drawString("Error: No axis/scale has been defined", 30, 30);
            return;
        }
        int n3 = (this.width - n2) / 2;
        int n4 = (this.height - n2) / 2;
        dataSerie.hotAreas.removeAllElements();
        this.plotGauge(graphics, dataSerie, n, n3, n4, n2, false);
    }

    protected void plotGauge(Graphics graphics, DataSerie dataSerie, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl2 = false;
        if (this.startAngle > 180 || this.endAngle > 180) {
            bl2 = true;
        }
        if (!(dataSerie instanceof GaugeDataSerie)) {
            return;
        }
        GaugeDataSerie gaugeDataSerie = (GaugeDataSerie)dataSerie;
        int n9 = 180;
        if (bl2) {
            n9 = 360;
        }
        if (!bl2) {
            n3 += n4 / 4;
        }
        this.CenterX = n2 + this.x + n4 / 2;
        this.CenterY = n3 + this.y + n4 / 2;
        this.angleRange = this.startAngle - this.endAngle;
        this.angleRange = Math.abs(this.angleRange);
        if (this.axis1 != null) {
            this.axis1.scale.screenMin = 0;
            this.axis1.scale.screenMax = 100;
            this.axis1.scale.screenMaxMargin = 100;
            this.axis1.scale.reverse = false;
        }
        if (this.axis2 != null) {
            this.axis2.scale.screenMin = 0;
            this.axis2.scale.screenMax = 100;
            this.axis2.scale.screenMaxMargin = 100;
            this.axis2.scale.reverse = false;
        }
        this.gaugeback.drawArc(graphics, n2 + this.x, n3 + this.y, n4, n4, 0, n9);
        if (this.maxZone > 0.0 && this.axis1 != null) {
            n8 = this.getAngleForValue(this.axis1, this.maxZone);
            n7 = this.getAngleForValue(this.axis1, this.axis1.scale.max);
            this.maxZoneColor.drawArc(graphics, n2 + this.x + this.maxminZoneMargin, n3 + this.y + this.maxminZoneMargin, n4 - this.maxminZoneMargin * 2, n4 - this.maxminZoneMargin * 2, n8, n7 - n8);
            n6 = -5;
            if (this.startAngle > this.endAngle) {
                n6 = 5;
            }
            this.gaugeback.drawArc(graphics, n2 + this.x + (this.maxminZoneWidth + this.maxminZoneMargin), n3 + this.y + (this.maxminZoneWidth + this.maxminZoneMargin), n4 - (this.maxminZoneWidth + this.maxminZoneMargin) * 2, n4 - (this.maxminZoneWidth + this.maxminZoneMargin) * 2, n8 + n6, n7 - n8 - n6 * 2);
        }
        if (this.minZone > 0.0 && this.axis1 != null) {
            n8 = this.getAngleForValue(this.axis1, this.minZone);
            n7 = this.getAngleForValue(this.axis1, this.axis1.scale.min);
            this.minZoneColor.drawArc(graphics, n2 + this.x + this.maxminZoneMargin, n3 + this.y + this.maxminZoneMargin, n4 - this.maxminZoneMargin * 2, n4 - this.maxminZoneMargin * 2, n7, n8 - n7);
            n6 = -5;
            if (this.startAngle > this.endAngle) {
                n6 = 5;
            }
            this.gaugeback.drawArc(graphics, n2 + this.x + (this.maxminZoneWidth + this.maxminZoneMargin), n3 + this.y + (this.maxminZoneWidth + this.maxminZoneMargin), n4 - (this.maxminZoneWidth + this.maxminZoneMargin) * 2, n4 - (this.maxminZoneWidth + this.maxminZoneMargin) * 2, n7 + n6, n8 - n7 - n6 * 2);
        }
        if (this.axis2 != null) {
            this.paintScale(graphics, this.axis2, this.axis2Margin, n4, this.axis2LabelMargin);
        }
        if (this.axis1 != null) {
            this.paintScale(graphics, this.axis1, this.axis1Margin, n4, this.axis1LabelMargin);
        }
        if (this.border != null) {
            this.border.drawArc(graphics, n2 + this.x, n3 + this.y, n4, n4, 0, n9);
        }
        if (!bl2) {
            this.border.draw(graphics, n2 + this.x, n3 + this.y + n4 / 2, n2 + this.x + n4, n3 + this.y + n4 / 2);
        }
        if (!bl && this.subGauge1 != null) {
            double d = n4;
            d = d * (double)this.subGaugeSize / (double)100;
            n6 = (int)((double)(n2 + n4 / 2) - d / (double)2);
            n5 = (int)((double)(n3 + n4 / 4) - d / (double)2);
            this.subGauge1.x = this.x;
            this.subGauge1.y = this.y;
            this.subGauge1.parentGauge = this;
            this.subGauge1.plotGauge(graphics, dataSerie, n, n6, n5, (int)d, true);
        }
        if (!bl && this.subGauge2 != null) {
            double d = n4;
            d = d * (double)this.subGaugeSize / (double)100;
            n6 = (int)((double)(n2 + n4 / 2) - d / (double)2);
            n5 = (int)((double)(n3 + n4 / 2 + n4 / 4) - d / (double)2);
            this.subGauge2.x = this.x;
            this.subGauge2.y = this.y;
            this.subGauge2.parentGauge = this;
            this.subGauge2.plotGauge(graphics, dataSerie, n, n6, n5, (int)d, true);
        }
        int n10 = 0;
        n7 = 0;
        if (!bl) {
            if (this.subGauge1 != null) {
                ++n10;
            }
            if (this.subGauge2 != null) {
                ++n10;
            }
        } else {
            n7 = gaugeDataSerie.yData.size() - 1;
            if (this.parentGauge.subGauge1 == this && this.parentGauge.subGauge2 != null) {
                n7 = gaugeDataSerie.yData.size() - 2;
            }
        }
        n6 = gaugeDataSerie.yData.size() - n10;
        n5 = 0;
        for (int i = n7; i < n6; ++i) {
            Object object;
            FillStyle fillStyle = null;
            if (gaugeDataSerie.Styles.size() > i) {
                fillStyle = (FillStyle)gaugeDataSerie.Styles.elementAt(i);
            }
            if (fillStyle == null) {
                fillStyle = new FillStyle(gaugeDataSerie.needleStyle.color);
            }
            LineStyle lineStyle = new LineStyle(gaugeDataSerie.needleStyle.getWidth(), fillStyle.color, gaugeDataSerie.needleStyle.getType());
            double d = n4 * this.needleBase / 100;
            double d2 = n4 / 2 * (100 - this.needleBase) / 100;
            fillStyle.drawArc(graphics, n5 * 3 + n2 + this.x + (int)d2, n5 * 3 + n3 + this.y + (int)d2, (int)d - n5 * 6, (int)d - n5 * 6, 0, 360);
            double d3 = (Double)gaugeDataSerie.getElementY(i);
            int n11 = this.getAngleForValue(this.axis1, d3);
            Point point = this.getArcPoint(n11, (int)((double)(n4 / 2) * (double)gaugeDataSerie.needleLength / (double)100));
            lineStyle.draw(graphics, this.CenterX + point.x, this.CenterY + point.y, this.CenterX, this.CenterY);
            if (gaugeDataSerie.valueFont != null && i == n7 && !bl) {
                graphics.setFont(gaugeDataSerie.valueFont);
                graphics.setColor(gaugeDataSerie.valueColor);
                object = "".concat(String.valueOf(String.valueOf(d3)));
                int n12 = graphics.getFontMetrics().getHeight();
                int n13 = graphics.getFontMetrics().stringWidth((String)object);
                graphics.drawString((String)object, this.CenterX - n13 / 2, this.CenterY + n12 + 5 + n4 / 2 * (this.needleBase / 100));
            }
            if (bl) break;
            ++n5;
            if (bl) continue;
            object = new Polygon();
            ((Polygon)object).addPoint(this.CenterX + point.x, this.CenterY + point.y);
            ((Polygon)object).addPoint(this.CenterX, this.CenterY);
            if (point.y <= 20) {
                ((Polygon)object).addPoint(this.CenterX, this.CenterY + 5);
                ((Polygon)object).addPoint(this.CenterX + point.x, this.CenterY + point.y + 5);
            } else {
                ((Polygon)object).addPoint(this.CenterX + 5, this.CenterY);
                ((Polygon)object).addPoint(this.CenterX + point.x + 5, this.CenterY + point.y);
            }
            dataSerie.hotAreas.addElement(object);
        }
    }

    private void paintScale(Graphics graphics, Axis axis, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (axis.startWithBigTick) {
            n5 = axis.bigTickInterval - 1;
        }
        for (double d = axis.scale.min; d <= axis.scale.max; d += axis.scaleTickInterval) {
            ++n5;
            int n6 = this.getAngleForValue(axis, d);
            Point point = this.getArcPoint(n6, n2 / 2 - n);
            int n7 = point.y;
            int n8 = point.x;
            point = this.getArcPoint(n6, n2 / 2 - axis.tickPixels - n);
            int n9 = point.y;
            int n10 = point.x;
            if (n5 == axis.bigTickInterval) {
                point = this.getArcPoint(n6, n2 / 2 - axis.bigTickPixels - n);
                n9 = point.y;
                n10 = point.x;
            }
            axis.style.draw(graphics, this.CenterX + n10, this.CenterY + n9, this.CenterX + n8, this.CenterY + n7);
            if (n5 != axis.bigTickInterval) continue;
            ++n4;
            if (axis.DescFont != null) {
                graphics.setFont(axis.DescFont);
                graphics.setColor(axis.DescColor);
                String string = new Double(d).toString();
                if (axis.scaleLabelFormat.length() > 0) {
                    DecimalFormat decimalFormat = new DecimalFormat(axis.scaleLabelFormat);
                    string = decimalFormat.format(new Double(d));
                }
                if (axis.IntegerScale) {
                    string = new Integer((int)d).toString();
                }
                if (axis.tickLabels != null) {
                    string = axis.tickLabels.length >= n4 ? axis.tickLabels[n4 - 1] : " ";
                }
                point = this.getArcPoint(n6, n2 / 2 - n + n3);
                int n11 = graphics.getFontMetrics().getHeight();
                int n12 = graphics.getFontMetrics().stringWidth(string);
                Point point2 = this.getArcPoint(n6, n2 / 2 - n);
                if (this.axis1LabelMargin > 0) {
                    if (point.x + n12 > point2.x && point.x < point2.x) {
                        graphics.drawString(string, this.CenterX + point.x - n12, this.CenterY + point.y);
                    } else {
                        graphics.drawString(string, this.CenterX + point.x, this.CenterY + point.y);
                    }
                } else if (point.x + n12 > point2.x && point.x < point2.x) {
                    graphics.drawString(string, this.CenterX + point.x - n12, this.CenterY + point.y);
                } else {
                    graphics.drawString(string, this.CenterX + point.x, this.CenterY + point.y);
                }
            }
            n5 = 0;
        }
    }

    private int getAngleForValue(Axis axis, double d) {
        int n = (int)((double)axis.scale.getScreenCoord(d) * (double)this.angleRange / (double)100);
        if (this.startAngle > this.endAngle) {
            n = this.angleRange - n;
            return this.endAngle + n;
        }
        return this.startAngle + n;
    }

    private Point getArcPoint(int n, int n2) {
        double d = 0.01745277777777778 * (double)n;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = d2 * (double)n2;
        double d5 = d3 * (double)n2;
        return new Point((int)d5, (int)(d4 *= (double)-1));
    }
}

