/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Axis;
import com.java4less.rchart.BarPlotter3D;
import com.java4less.rchart.ChartListener;
import com.java4less.rchart.DataSerie;
import com.java4less.rchart.FillStyle;
import com.java4less.rchart.HAxisLabel;
import com.java4less.rchart.Legend;
import com.java4less.rchart.LinePlotter3D;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.Title;
import com.java4less.rchart.VAxisLabel;
import com.java4less.rchart.encoder.chartEncoder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Vector;

public class Chart
extends Canvas
implements MouseMotionListener {
    public static final int LAYOUT_LEGEND_RIGHT = 0;
    public static final int LAYOUT_LEGEND_TOP = 1;
    public static final int LAYOUT_LEGEND_BOTTOM = 2;
    public static final int dnum = 8;
    public boolean activateSelection = false;
    public int currentX;
    public int currentY;
    public double currentValueX;
    public double currentValueY;
    public double currentValueY2;
    public VAxisLabel YLabel;
    public VAxisLabel Y2Label;
    public HAxisLabel XLabel;
    public Legend legend;
    public Axis XAxis;
    public Axis YAxis;
    public Axis Y2Axis;
    public Title title;
    public double bottomMargin = 0.125;
    public double topMargin = 0.125;
    public double secondYAxisMargin = 0.0;
    public double leftMargin = 0.125;
    public double rightMargin = 0.125;
    public double legendMargin = 0.2;
    public double axisMargin = 0.0625;
    public boolean autoSize = true;
    public Plotter[] Plotters = new Plotter[10];
    private int PlottersCount = 0;
    public int layout = 0;
    public FillStyle back = null;
    public LineStyle border = null;
    public int offsetX = 0;
    public int offsetY = 0;
    private int lastWidth = -1;
    private int lastHeight = -1;
    public String selectedSerie = "";
    public int selectedSeriePoint = -1;
    public static Image tmpImage = null;
    public Image backImage;
    private Image chartImage = null;
    private Image finalImage = null;
    private Image backTmpImage = null;
    public boolean doubleBuffering = true;
    public int virtualWidth = 0;
    public int virtualHeight = 0;
    private int originalVirtualWidth = -1;
    private int originalVirtualHeight = -1;
    public boolean withScroll = false;
    public boolean repaintAll = true;
    public boolean repaintAlways = true;
    private ChartListener chartListener;
    public boolean fullXAxis = false;
    public Component visibleComponent = this;

    public Chart(Title title, Plotter plotter, Axis axis, Axis axis2) {
        this.Plotters[0] = plotter;
        this.XAxis = axis;
        this.YAxis = axis2;
        if (axis != null) {
            this.Plotters[0].XScale = axis.scale;
            axis.plot = this.Plotters[0];
        }
        if (axis2 != null) {
            this.Plotters[0].YScale = axis2.scale;
            axis2.plot = this.Plotters[0];
        }
        this.title = title;
        if (this.title == null) {
            this.title = new Title("");
        }
        this.PlottersCount = 1;
        this.addMouseMotionListener(this);
    }

    public void resetChart(Title title, Plotter plotter, Axis axis, Axis axis2) {
        this.Plotters[0] = plotter;
        this.XAxis = axis;
        this.YAxis = axis2;
        if (axis != null) {
            this.Plotters[0].XScale = axis.scale;
            axis.plot = this.Plotters[0];
        }
        if (axis2 != null) {
            this.Plotters[0].YScale = axis2.scale;
            axis2.plot = this.Plotters[0];
        }
        this.title = title;
        if (this.title == null) {
            this.title = new Title("");
        }
        this.PlottersCount = 1;
    }

    public static int d() {
        return 0;
    }

    public void setChartListener(ChartListener chartListener) {
        this.chartListener = chartListener;
    }

    public void addPlotter(Plotter plotter) {
        this.Plotters[this.PlottersCount] = plotter;
        this.Plotters[this.PlottersCount].XScale = this.Plotters[0].XScale;
        this.Plotters[this.PlottersCount].YScale = this.Plotters[0].YScale;
        this.Plotters[this.PlottersCount].Y2Scale = this.Plotters[0].Y2Scale;
        ++this.PlottersCount;
    }

    public void removePlotters() {
        for (int i = 0; i < this.PlottersCount; ++i) {
            this.Plotters[i] = null;
        }
        this.PlottersCount = 0;
    }

    private void AutoSize() {
        if (this.layout == 0) {
            this.AutoSize_LayoutRight();
        }
        if (this.layout == 1) {
            this.AutoSize_LayoutTop();
        }
        if (this.layout == 2) {
            this.AutoSize_LayoutBottom();
        }
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    public void setY2Scale(Axis axis) {
        this.Plotters[0].Y2Scale = axis.scale;
        this.Y2Axis = axis;
        axis.rightAxis = true;
        axis.plot = this.Plotters[0];
    }

    private void setPlotterSize() {
        for (int i = 1; i < this.PlottersCount; ++i) {
            this.Plotters[i].x = this.Plotters[0].x;
            this.Plotters[i].y = this.Plotters[0].y;
            this.Plotters[i].width = this.Plotters[0].width;
            this.Plotters[i].height = this.Plotters[0].height;
        }
    }

    private void AutoSize_LayoutTop() {
        int n = this.getSize().height;
        int n2 = this.getSize().width;
        if (this.virtualWidth < n2) {
            this.virtualWidth = n2;
        }
        if (this.virtualHeight < n) {
            this.virtualHeight = n;
        }
        this.Plotters[0].visibleWidth = (int)((double)n2 * (1.0 - (this.leftMargin + this.rightMargin)));
        this.Plotters[0].visibleHeight = (int)((double)n * (1.0 - (this.topMargin + this.legendMargin + this.bottomMargin)));
        this.Plotters[0].x = (int)((double)n2 * this.leftMargin);
        this.Plotters[0].y = (int)((double)n * (this.topMargin + this.legendMargin));
        this.Plotters[0].width = this.virtualWidth - (n2 - this.Plotters[0].visibleWidth);
        this.Plotters[0].height = this.virtualHeight - (n - this.Plotters[0].visibleHeight);
        this.title.x = 0;
        this.title.y = 0;
        this.title.height = (int)((double)n * this.topMargin);
        this.title.width = n2;
        if (this.XAxis != null) {
            this.XAxis.x = (int)((double)n2 * this.leftMargin);
            this.XAxis.y = this.virtualHeight - (int)((double)n * this.bottomMargin);
            this.XAxis.realPosition = (int)((double)n * (1.0 - this.bottomMargin));
            this.XAxis.height = (int)((double)n * (this.bottomMargin / (double)2));
            this.XAxis.visibleSize = (int)((double)n2 * (1.0 - (this.leftMargin + this.rightMargin)));
            this.XAxis.width = this.virtualWidth - (n2 - this.XAxis.visibleSize);
        }
        if (this.YAxis != null) {
            this.YAxis.realPosition = this.YAxis.x = (int)((double)n2 * (this.leftMargin / (double)2));
            this.YAxis.y = (int)((double)n * (this.topMargin + this.legendMargin));
            this.YAxis.visibleSize = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.YAxis.height = this.virtualHeight - (n - this.YAxis.visibleSize);
            this.YAxis.width = (int)((double)n2 * (this.leftMargin / (double)2));
        }
        if (this.XLabel != null) {
            this.XLabel.x = (int)((double)n2 * this.leftMargin);
            this.XLabel.y = (int)((double)n * (1.0 - this.bottomMargin / (double)2));
            this.XLabel.height = (int)((double)n * (this.bottomMargin / (double)2));
            this.XLabel.width = (int)((double)n2 * (1.0 - (this.leftMargin + this.leftMargin)));
        }
        if (this.YLabel != null) {
            this.YLabel.x = 0;
            this.YLabel.y = (int)((double)n * (this.topMargin + this.legendMargin));
            this.YLabel.height = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.YLabel.width = (int)((double)n2 * (this.leftMargin / (double)2));
        }
        if (this.Y2Axis != null) {
            this.Plotters[0].width = (int)((double)this.Plotters[0].width - (double)n2 * this.secondYAxisMargin / (double)2);
        }
        if (this.Y2Label != null) {
            this.Plotters[0].width = (int)((double)this.Plotters[0].width - (double)n2 * this.secondYAxisMargin / (double)2);
        }
        if (this.Y2Axis != null) {
            this.Y2Axis.x = this.Plotters[0].x + this.Plotters[0].width;
            this.Y2Axis.realPosition = this.Plotters[0].x + this.Plotters[0].visibleWidth;
            this.Y2Axis.y = (int)((double)n * (this.topMargin + this.legendMargin));
            this.Y2Axis.visibleSize = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.Y2Axis.width = (int)((double)n2 * this.rightMargin / (double)2);
            this.Y2Axis.height = this.virtualHeight - (n - this.Y2Axis.visibleSize);
        }
        if (this.Y2Label != null) {
            this.Y2Label.x = this.Plotters[0].x + this.Plotters[0].visibleWidth + (int)((double)n2 * this.rightMargin / (double)2);
            this.Y2Label.y = (int)((double)n * (this.topMargin + this.legendMargin));
            this.Y2Label.height = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.Y2Label.width = (int)((double)n2 * this.rightMargin / (double)2);
        }
        if (this.legend != null) {
            this.legend.x = (int)((double)n2 * this.leftMargin);
            this.legend.width = (int)((double)n2 * (1.0 - (this.leftMargin + this.rightMargin)));
            this.legend.y = (int)((double)n * this.topMargin);
            this.legend.height = (int)((double)n * this.legendMargin);
        }
        this.adjustSize3d();
        this.setPlotterSize();
    }

    private void AutoSize_LayoutBottom() {
        int n = this.getSize().height;
        int n2 = this.getSize().width;
        if (this.virtualWidth < n2) {
            this.virtualWidth = n2;
        }
        if (this.virtualHeight < n) {
            this.virtualHeight = n;
        }
        this.Plotters[0].visibleWidth = (int)((double)n2 * (1.0 - (this.leftMargin + this.rightMargin)));
        this.Plotters[0].visibleHeight = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
        this.Plotters[0].x = (int)((double)n2 * this.leftMargin);
        this.Plotters[0].y = (int)((double)n * this.topMargin);
        this.Plotters[0].width = this.virtualWidth - (n2 - this.Plotters[0].visibleWidth);
        this.Plotters[0].height = this.virtualHeight - (n - this.Plotters[0].visibleHeight);
        this.title.x = 0;
        this.title.y = 0;
        this.title.height = (int)((double)n * this.topMargin);
        this.title.width = n2;
        if (this.XAxis != null) {
            this.XAxis.x = (int)((double)n2 * this.leftMargin);
            this.XAxis.y = this.virtualHeight - (int)((double)n * (this.bottomMargin + this.legendMargin));
            this.XAxis.realPosition = (int)((double)n * (1.0 - this.bottomMargin - this.legendMargin));
            this.XAxis.height = (int)((double)n * (this.bottomMargin / (double)2));
            this.XAxis.visibleSize = (int)((double)n2 * (1.0 - (this.leftMargin + this.rightMargin)));
            this.XAxis.width = this.virtualWidth - (n2 - this.XAxis.visibleSize);
        }
        if (this.YAxis != null) {
            this.YAxis.realPosition = this.YAxis.x = (int)((double)n2 * (this.leftMargin / (double)2));
            this.YAxis.y = (int)((double)n * this.topMargin);
            this.YAxis.visibleSize = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.YAxis.width = (int)((double)n2 * (this.leftMargin / (double)2));
            this.YAxis.height = this.virtualHeight - (n - this.YAxis.visibleSize);
        }
        if (this.XLabel != null) {
            this.XLabel.x = (int)((double)n2 * this.leftMargin);
            this.XLabel.y = (int)((double)n * (1.0 - this.bottomMargin / (double)2 - this.legendMargin));
            this.XLabel.height = (int)((double)n * (this.bottomMargin / (double)2));
            this.XLabel.width = (int)((double)n2 * (1.0 - (this.leftMargin + this.leftMargin)));
        }
        if (this.YLabel != null) {
            this.YLabel.x = 0;
            this.YLabel.y = (int)((double)n * this.topMargin);
            this.YLabel.height = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.YLabel.width = (int)((double)n2 * (this.leftMargin / (double)2));
        }
        if (this.Y2Axis != null) {
            this.Plotters[0].width = (int)((double)this.Plotters[0].width - (double)n2 * this.secondYAxisMargin / (double)2);
        }
        if (this.Y2Label != null) {
            this.Plotters[0].width = (int)((double)this.Plotters[0].width - (double)n2 * this.secondYAxisMargin / (double)2);
        }
        if (this.Y2Axis != null) {
            this.Y2Axis.x = this.Plotters[0].x + this.Plotters[0].width;
            this.Y2Axis.realPosition = this.Plotters[0].x + this.Plotters[0].visibleWidth;
            this.Y2Axis.y = (int)((double)n * this.topMargin);
            this.Y2Axis.visibleSize = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.Y2Axis.width = (int)((double)n2 * this.rightMargin / (double)2);
            this.Y2Axis.height = this.virtualHeight - (n - this.Y2Axis.visibleSize);
        }
        if (this.Y2Label != null) {
            this.Y2Label.x = this.Plotters[0].x + this.Plotters[0].visibleWidth + (int)((double)n2 * this.rightMargin / (double)2);
            this.Y2Label.y = (int)((double)n * this.topMargin);
            this.Y2Label.height = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin + this.legendMargin)));
            this.Y2Label.width = (int)((double)n2 * this.rightMargin / (double)2);
        }
        if (this.legend != null) {
            this.legend.x = (int)((double)n2 * this.leftMargin);
            this.legend.width = (int)((double)n2 * (1.0 - (this.leftMargin + this.leftMargin)));
            this.legend.y = (int)((double)n * (1.0 - this.legendMargin));
            this.legend.height = (int)((double)n * this.legendMargin);
        }
        this.adjustSize3d();
        this.setPlotterSize();
    }

    private void AutoSize_LayoutRight() {
        int n = this.getSize().height;
        int n2 = this.getSize().width;
        if (this.virtualWidth < n2) {
            this.virtualWidth = n2;
        }
        if (this.virtualHeight < n) {
            this.virtualHeight = n;
        }
        this.Plotters[0].visibleWidth = (int)((double)n2 * (1.0 - (this.legendMargin + this.leftMargin)));
        if (this.Y2Axis != null) {
            this.Plotters[0].visibleWidth = (int)((double)n2 * (1.0 - (this.legendMargin + this.rightMargin + this.leftMargin)));
        }
        this.Plotters[0].visibleHeight = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin)));
        this.Plotters[0].x = (int)((double)n2 * this.leftMargin);
        this.Plotters[0].y = (int)((double)n * this.topMargin);
        this.Plotters[0].width = this.virtualWidth - (n2 - this.Plotters[0].visibleWidth);
        this.Plotters[0].height = this.virtualHeight - (n - this.Plotters[0].visibleHeight);
        this.title.x = 0;
        this.title.y = 0;
        this.title.height = (int)((double)n * this.topMargin);
        this.title.width = n2;
        if (this.XAxis != null) {
            this.XAxis.x = (int)((double)n2 * this.leftMargin);
            this.XAxis.y = this.virtualHeight - (int)((double)n * this.bottomMargin);
            this.XAxis.realPosition = (int)((double)n * (1.0 - this.bottomMargin));
            this.XAxis.height = (int)((double)n * (this.bottomMargin / (double)2));
            this.XAxis.visibleSize = this.Plotters[0].visibleWidth;
            this.XAxis.width = this.virtualWidth - (n2 - this.XAxis.visibleSize);
        }
        if (this.YAxis != null) {
            this.YAxis.realPosition = this.YAxis.x = (int)((double)n2 * (this.leftMargin / (double)2));
            this.YAxis.y = (int)((double)n * this.topMargin);
            this.YAxis.visibleSize = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin)));
            this.YAxis.width = (int)((double)n2 * (this.leftMargin / (double)2));
            this.YAxis.height = this.virtualHeight - (n - this.YAxis.visibleSize);
        }
        if (this.XLabel != null) {
            this.XLabel.x = (int)((double)n2 * this.leftMargin);
            this.XLabel.y = (int)((double)n * (1.0 - this.bottomMargin / (double)2));
            this.XLabel.height = (int)((double)n * (this.bottomMargin / (double)2));
            this.XLabel.width = (int)((double)n2 * (1.0 - (this.legendMargin + this.leftMargin)));
        }
        if (this.YLabel != null) {
            this.YLabel.x = 0;
            this.YLabel.y = (int)((double)n * this.topMargin);
            this.YLabel.height = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin)));
            this.YLabel.width = (int)((double)n2 * (this.leftMargin / (double)2));
        }
        if (this.Y2Axis != null) {
            this.Plotters[0].width = (int)((double)this.Plotters[0].width - (double)n2 * this.secondYAxisMargin / (double)2);
        }
        if (this.Y2Label != null) {
            this.Plotters[0].width = (int)((double)this.Plotters[0].width - (double)n2 * this.secondYAxisMargin / (double)2);
        }
        if (this.Y2Axis != null) {
            this.Y2Axis.x = this.Plotters[0].x + this.Plotters[0].width;
            this.Y2Axis.realPosition = this.Plotters[0].x + this.Plotters[0].visibleWidth;
            this.Y2Axis.y = (int)((double)n * this.topMargin);
            this.Y2Axis.visibleSize = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin)));
            this.Y2Axis.width = (int)((double)n2 * this.rightMargin / (double)2);
            this.Y2Axis.height = this.virtualHeight - (n - this.Y2Axis.visibleSize);
        }
        if (this.Y2Label != null) {
            this.Y2Label.x = this.Plotters[0].x + this.Plotters[0].visibleWidth + (int)((double)n2 * this.rightMargin / (double)2);
            this.Y2Label.y = (int)((double)n * this.topMargin);
            this.Y2Label.height = (int)((double)n * (1.0 - (this.topMargin + this.bottomMargin)));
            this.Y2Label.width = (int)((double)n2 * this.rightMargin / (double)2);
        }
        if (this.legend != null) {
            this.legend.x = (int)((double)n2 * (1.0 - this.legendMargin));
            this.legend.width = (int)((double)n2 * this.legendMargin);
            this.legend.y = (int)((double)n * this.topMargin);
            this.legend.height = (int)((double)n * 0.5);
        }
        this.adjustSize3d();
        this.setPlotterSize();
    }

    private void adjustSize3d() {
        boolean bl = false;
        if (this.Plotters[0] instanceof BarPlotter3D) {
            bl = true;
        }
        if (this.Plotters[0] instanceof LinePlotter3D) {
            bl = true;
        }
        if (bl && this.Plotters[0].depth == 0) {
            this.Plotters[0].depth = 20;
        }
        this.Plotters[0].width -= this.Plotters[0].depth;
        this.Plotters[0].height -= this.Plotters[0].depth;
        this.Plotters[0].y += this.Plotters[0].depth;
        if (this.Y2Axis != null) {
            this.Y2Axis.visibleSize -= this.Plotters[0].depth;
            this.Y2Axis.y = this.Y2Axis.y;
            this.Y2Axis.height -= this.Plotters[0].depth;
        }
        if (this.YAxis != null) {
            this.YAxis.visibleSize -= this.Plotters[0].depth;
            this.YAxis.y += this.Plotters[0].depth;
            this.YAxis.height -= this.Plotters[0].depth;
        }
        if (this.XAxis != null) {
            this.XAxis.visibleSize -= this.Plotters[0].depth;
            this.XAxis.width -= this.Plotters[0].depth;
        }
    }

    private void drawBackImage(Graphics graphics) {
        int n = this.backImage.getWidth(null);
        int n2 = this.backImage.getHeight(null);
        if (n == -1 || n2 == -1) {
            return;
        }
        for (int i = 0; i < this.virtualWidth; i += n) {
            for (int j = 0; j < this.virtualHeight; j += n2) {
                graphics.drawImage(this.backImage, i, j, null);
            }
        }
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.Plotters[0] == null || this.PlottersCount <= 0) {
            graphics.setColor(Color.red);
            graphics.drawString("Error: No plotters/series have been defined", 30, 30);
            return;
        }
        for (int i = 0; i < this.PlottersCount; ++i) {
            if (this.Plotters[i].getNeedsAxis() > 0 && this.XAxis == null) {
                graphics.setColor(Color.red);
                graphics.drawString("Error: No X axis have been defined", 30, 30);
                return;
            }
            if (this.Plotters[i].getNeedsAxis() > 1 && this.YAxis == null) {
                graphics.setColor(Color.red);
                graphics.drawString("Error: No Y axis have been defined", 30, 30);
                return;
            }
            if (this.PlottersCount <= 1 || this.Plotters[i].getCombinable()) continue;
            graphics.setColor(Color.red);
            graphics.drawString("Error: These plotters cannot be combined", 30, 30);
            return;
        }
        Graphics graphics2 = graphics;
        Graphics graphics3 = graphics;
        Graphics graphics4 = graphics;
        if (this.lastWidth != this.getSize().width || this.lastHeight != this.getSize().height) {
            this.repaintAll = true;
            this.lastWidth = this.getSize().width;
            this.lastHeight = this.getSize().height;
        }
        if (this.originalVirtualHeight == -1) {
            this.originalVirtualHeight = this.virtualHeight;
        }
        if (this.originalVirtualWidth == -1) {
            this.originalVirtualWidth = this.virtualWidth;
        }
        if (!this.withScroll) {
            this.repaintAlways = true;
        }
        if (this.repaintAlways) {
            this.repaintAll = true;
        }
        if (this.autoSize) {
            if (!this.withScroll) {
                this.virtualHeight = this.originalVirtualHeight;
                this.virtualWidth = this.originalVirtualWidth;
            }
            this.AutoSize();
        }
        try {
            if (this.doubleBuffering && (this.repaintAll || this.finalImage == null)) {
                this.finalImage = this.visibleComponent.createImage(this.getSize().width, this.getSize().height);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.finalImage != null) {
            graphics2 = graphics4 = this.finalImage.getGraphics();
            graphics3 = graphics4;
        }
        if (this.withScroll) {
            if (this.repaintAll || this.chartImage == null) {
                this.chartImage = this.visibleComponent.createImage(this.virtualWidth, this.virtualHeight);
            }
            graphics2 = this.chartImage.getGraphics();
            if (this.repaintAll || this.backTmpImage == null) {
                this.backTmpImage = this.visibleComponent.createImage(this.virtualWidth, this.virtualHeight);
            }
            graphics3 = this.backTmpImage.getGraphics();
        }
        if (this.repaintAll) {
            if (this.back != null) {
                this.back.draw(graphics3, 0, 0, this.virtualWidth, this.virtualHeight);
            }
            if (this.backImage != null) {
                this.drawBackImage(graphics3);
            }
        }
        if (this.withScroll && (this.backImage != null || this.back != null)) {
            if (this.repaintAll) {
                graphics2.drawImage(this.backTmpImage, 0, 0, this.virtualWidth, this.virtualHeight, 0, 0, this.virtualWidth, this.virtualHeight, null);
            }
            graphics4.drawImage(this.backTmpImage, 0, 0, this.getSize().width, this.getSize().height, this.offsetX, this.offsetY, this.getSize().width + this.offsetX, this.getSize().height + this.offsetY, null);
        }
        if (this.Plotters[0].XScale != null) {
            this.Plotters[0].XScale.screenMax = this.Plotters[0].x + this.Plotters[0].width;
            this.Plotters[0].XScale.screenMaxMargin = (int)((double)this.Plotters[0].XScale.screenMax * (1.0 - this.axisMargin));
            if (this.fullXAxis) {
                this.Plotters[0].XScale.screenMaxMargin = this.Plotters[0].XScale.screenMax;
            }
            this.Plotters[0].XScale.screenMin = this.Plotters[0].x;
        }
        if (this.Plotters[0].YScale != null) {
            this.Plotters[0].YScale.screenMax = this.Plotters[0].y + this.Plotters[0].height;
            this.Plotters[0].YScale.screenMaxMargin = (int)((double)this.Plotters[0].YScale.screenMax * (1.0 - this.axisMargin));
            this.Plotters[0].YScale.screenMin = this.Plotters[0].y;
        }
        if (this.Plotters[0].Y2Scale != null) {
            this.Plotters[0].Y2Scale.screenMax = this.Plotters[0].y + this.Plotters[0].height - this.Plotters[0].depth;
            this.Plotters[0].Y2Scale.screenMaxMargin = (int)((double)this.Plotters[0].Y2Scale.screenMax * (1.0 - this.axisMargin));
            this.Plotters[0].Y2Scale.screenMin = this.Plotters[0].y - this.Plotters[0].depth;
        }
        if (this.repaintAll) {
            int n2 = this.Plotters[0].width;
            n = this.Plotters[0].height;
            if (this.XAxis != null) {
                n2 = this.XAxis.width;
            }
            if (this.YAxis != null) {
                n = this.YAxis.height;
            }
            this.Plotters[0].plotBackground(graphics2, n2, n, this.offsetX, this.offsetY);
        }
        this.title.draw(graphics4);
        if (this.repaintAll) {
            if (this.XAxis != null) {
                this.XAxis.offset = this.offsetX;
            }
            if (this.YAxis != null) {
                this.YAxis.offset = this.offsetY;
            }
            if (this.Y2Axis != null) {
                this.Y2Axis.offset = this.offsetY;
            }
            if (this.XAxis != null) {
                this.XAxis.drawBackground(graphics2, this.YAxis);
            }
            if (this.YAxis != null) {
                this.YAxis.drawBackground(graphics2, this.XAxis);
            }
            if (this.Y2Axis != null) {
                this.Y2Axis.drawBackground(graphics2, this.XAxis);
            }
        }
        if (Chart.d() != 1 && this.legend == null) {
            this.legend = new Legend();
        }
        if (this.legend != null) {
            this.legend.draw(graphics4);
        }
        if (this.XLabel != null) {
            this.XLabel.draw(graphics4);
        }
        if (this.YLabel != null) {
            this.YLabel.draw(graphics4);
        }
        if (this.Y2Label != null) {
            this.Y2Label.draw(graphics4);
        }
        if (this.repaintAll) {
            for (int i = 0; i < this.PlottersCount; ++i) {
                this.Plotters[i].plot(graphics2);
            }
        }
        if (this.border != null) {
            this.border.drawRect(graphics4, 0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
        if (this.chartImage != null) {
            int n3 = this.Plotters[0].x;
            n = this.Plotters[0].x + this.Plotters[0].visibleWidth;
            int n4 = this.Plotters[0].y - this.Plotters[0].depth;
            int n5 = this.Plotters[0].y - this.Plotters[0].depth + this.Plotters[0].visibleHeight;
            graphics4.drawImage(this.chartImage, n3, n4, n, n5, n3 + this.offsetX, n4 + this.offsetY, n + this.offsetX, n5 + this.offsetY, null);
        }
        if (this.chartListener != null) {
            this.chartListener.paintUserExit(this, graphics4);
        }
        if (this.XAxis != null) {
            this.XAxis.offset = this.offsetX;
            this.XAxis.drawForeground(graphics4, this.YAxis);
        }
        if (this.YAxis != null) {
            this.YAxis.offset = this.offsetY;
            this.YAxis.drawForeground(graphics4, this.XAxis);
        }
        if (this.Y2Axis != null) {
            this.Y2Axis.offset = this.offsetY;
            this.Y2Axis.drawForeground(graphics4, this.XAxis);
        }
        if (this.finalImage != null) {
            graphics.drawImage(this.finalImage, 0, 0, this.getSize().width - 1, this.getSize().height - 1, 0, 0, this.getSize().width - 1, this.getSize().height - 1, null);
        }
        this.repaintAll = false;
    }

    public void addSerie(DataSerie dataSerie) {
        this.Plotters[0].addSerie(dataSerie);
    }

    public static synchronized boolean drawVerticalText(Graphics graphics, Font font, Color color, String string, int n, int n2, boolean bl) {
        Color color2 = Color.white;
        if (color.equals(color2)) {
            color2 = Color.black;
        }
        if (tmpImage == null) {
            return false;
        }
        Graphics graphics2 = tmpImage.getGraphics();
        graphics2.setColor(color2);
        graphics2.setFont(font);
        int n3 = graphics2.getFontMetrics().getHeight();
        int n4 = graphics2.getFontMetrics().stringWidth(string);
        int n5 = n - n3 / 2;
        int n6 = n2;
        if (bl) {
            n6 = n2 - n4 / 2;
        }
        graphics2.fillRect(0, 0, n4, n3);
        graphics2.setColor(color);
        graphics2.drawString(string, 0, n3);
        Image image = Chart.rotate(tmpImage, 90, n4, n3, color2);
        graphics.drawImage(image, n5, n6, null);
        return true;
    }

    public static Image rotate(Image image, int n, int n2, int n3, Color color) {
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (n2 > n4) {
            n2 = n4;
        }
        if (n3 > n5) {
            n3 = n5;
        }
        ColorModel colorModel = null;
        int[] nArray = new int[n4 * n5];
        int[] nArray2 = new int[n2 * n3];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n4, n5, nArray, 0, n4);
        colorModel = pixelGrabber.getColorModel();
        DirectColorModel directColorModel = null;
        IndexColorModel indexColorModel = null;
        if (colorModel instanceof DirectColorModel) {
            directColorModel = (DirectColorModel)colorModel;
        }
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
        }
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            Image image2 = null;
            return image2;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        if (n == 90) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n6 = 0;
                    n6 = nArray[j * n4 + i];
                    int n7 = 0;
                    n7 = directColorModel.getAlpha(n6);
                    if (new Color(n6).equals(color)) {
                        if (indexColorModel != null) {
                            n6 = indexColorModel.getTransparentPixel();
                        }
                        if (directColorModel != null) {
                            n6 = (directColorModel.getBlueMask() | directColorModel.getRedMask() | directColorModel.getGreenMask()) & n6;
                        }
                    }
                    nArray2[n3 * (n2 - (i + 1)) + j] = n6;
                }
            }
            colorModel.finalize();
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n2, colorModel, nArray2, 0, n3));
        }
        if (n == 180) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray2[(n3 - (j + 1)) * n2 + (n2 - (i + 1))] = nArray[j * n4 + i];
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, colorModel, nArray2, 0, n2));
        }
        if (n == 270) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray2[n3 * i + (n3 - (j + 1))] = nArray[j * n4 + i];
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n3, n2, colorModel, nArray2, 0, n3));
        }
        return null;
    }

    public boolean saveToFile(String string, String string2) {
        chartEncoder chartEncoder2 = new chartEncoder(this, string, string2);
        return chartEncoder2.encode();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.Plotters[0] == null) {
            return;
        }
        this.currentValueX = 0.0;
        this.currentValueY = 0.0;
        this.currentValueY2 = 0.0;
        this.currentX = mouseEvent.getX();
        this.currentY = mouseEvent.getY();
        this.selectedSerie = "";
        if (this.currentX < this.Plotters[0].x || this.currentY < this.Plotters[0].y || this.currentX > this.Plotters[0].visibleWidth + this.Plotters[0].x || this.currentY > this.Plotters[0].visibleHeight + this.Plotters[0].y) {
            this.currentX = 0;
            this.currentY = 0;
            return;
        }
        if (this.XAxis != null) {
            this.currentValueX = this.XAxis.scale.getValue(this.currentX + this.offsetX);
        }
        if (this.YAxis != null) {
            this.currentValueY = this.YAxis.scale.getValue(this.currentY + this.offsetY);
            if (this.Y2Axis != null) {
                this.currentValueY2 = this.Y2Axis.scale.getValue(this.currentY + this.offsetY);
            }
        }
        if (this.activateSelection) {
            for (int i = 0; i < this.Plotters.length && this.Plotters[i] != null; ++i) {
                Vector vector = this.Plotters[i].Series;
                for (int j = 0; j < vector.size(); ++j) {
                    DataSerie dataSerie = (DataSerie)vector.elementAt(j);
                    for (int k = 0; k < dataSerie.hotAreas.size(); ++k) {
                        if (!((Polygon)dataSerie.hotAreas.elementAt(k)).contains(this.currentX + this.offsetX, this.currentY + this.offsetY)) continue;
                        this.selectedSerie = dataSerie.name;
                        this.selectedSeriePoint = k;
                    }
                }
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

